/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.application.connector;

import java.io.IOException;
import java.time.Instant;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xcontent.XContentParserConfiguration;
import org.elasticsearch.xcontent.XContentType;
import org.elasticsearch.xpack.application.connector.filtering.FilteringAdvancedSnippet;
import org.elasticsearch.xpack.application.connector.filtering.FilteringPolicy;
import org.elasticsearch.xpack.application.connector.filtering.FilteringRule;
import org.elasticsearch.xpack.application.connector.filtering.FilteringRuleCondition;
import org.elasticsearch.xpack.application.connector.filtering.FilteringRules;
import org.elasticsearch.xpack.application.connector.filtering.FilteringValidationInfo;
import org.elasticsearch.xpack.application.connector.filtering.FilteringValidationState;

public class ConnectorFiltering
implements Writeable,
ToXContentObject {
    private final FilteringRules active;
    private final String domain;
    private final FilteringRules draft;
    private static final ParseField ACTIVE_FIELD = new ParseField("active", new String[0]);
    private static final ParseField DOMAIN_FIELD = new ParseField("domain", new String[0]);
    private static final ParseField DRAFT_FIELD = new ParseField("draft", new String[0]);
    private static final ConstructingObjectParser<ConnectorFiltering, Void> PARSER = new ConstructingObjectParser("connector_filtering", true, args -> new Builder().setActive((FilteringRules)args[0]).setDomain((String)args[1]).setDraft((FilteringRules)args[2]).build());

    public ConnectorFiltering(FilteringRules active, String domain, FilteringRules draft) {
        this.active = active;
        this.domain = domain;
        this.draft = draft;
    }

    public ConnectorFiltering(StreamInput in) throws IOException {
        this.active = new FilteringRules(in);
        this.domain = in.readString();
        this.draft = new FilteringRules(in);
    }

    public FilteringRules getActive() {
        return this.active;
    }

    public String getDomain() {
        return this.domain;
    }

    public FilteringRules getDraft() {
        return this.draft;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(ACTIVE_FIELD.getPreferredName(), (ToXContent)this.active);
        builder.field(DOMAIN_FIELD.getPreferredName(), this.domain);
        builder.field(DRAFT_FIELD.getPreferredName(), (ToXContent)this.draft);
        builder.endObject();
        return builder;
    }

    public static ConnectorFiltering fromXContent(XContentParser parser) throws IOException {
        return (ConnectorFiltering)PARSER.parse(parser, null);
    }

    public static ConnectorFiltering fromXContentBytes(BytesReference source, XContentType xContentType) {
        ConnectorFiltering connectorFiltering;
        block8: {
            XContentParser parser = XContentHelper.createParser((XContentParserConfiguration)XContentParserConfiguration.EMPTY, (BytesReference)source, (XContentType)xContentType);
            try {
                connectorFiltering = ConnectorFiltering.fromXContent(parser);
                if (parser == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (parser != null) {
                        try {
                            parser.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new ElasticsearchParseException("Failed to parse a connector filtering.", (Throwable)e, new Object[0]);
                }
            }
            parser.close();
        }
        return connectorFiltering;
    }

    public void writeTo(StreamOutput out) throws IOException {
        this.active.writeTo(out);
        out.writeString(this.domain);
        this.draft.writeTo(out);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ConnectorFiltering that = (ConnectorFiltering)o;
        return Objects.equals(this.active, that.active) && Objects.equals(this.domain, that.domain) && Objects.equals(this.draft, that.draft);
    }

    public int hashCode() {
        return Objects.hash(this.active, this.domain, this.draft);
    }

    public static ConnectorFiltering getDefaultConnectorFilteringConfig() {
        Instant currentTimestamp = Instant.now();
        return new Builder().setActive(new FilteringRules.Builder().setAdvancedSnippet(new FilteringAdvancedSnippet.Builder().setAdvancedSnippetCreatedAt(currentTimestamp).setAdvancedSnippetUpdatedAt(currentTimestamp).setAdvancedSnippetValue(Collections.emptyMap()).build()).setRules(List.of(new FilteringRule.Builder().setCreatedAt(currentTimestamp).setField("_").setId("DEFAULT").setOrder(0).setPolicy(FilteringPolicy.INCLUDE).setRule(FilteringRuleCondition.REGEX).setUpdatedAt(currentTimestamp).setValue(".*").build())).setFilteringValidationInfo(new FilteringValidationInfo.Builder().setValidationErrors(Collections.emptyList()).setValidationState(FilteringValidationState.VALID).build()).build()).setDomain("DEFAULT").setDraft(new FilteringRules.Builder().setAdvancedSnippet(new FilteringAdvancedSnippet.Builder().setAdvancedSnippetCreatedAt(currentTimestamp).setAdvancedSnippetUpdatedAt(currentTimestamp).setAdvancedSnippetValue(Collections.emptyMap()).build()).setRules(List.of(new FilteringRule.Builder().setCreatedAt(currentTimestamp).setField("_").setId("DEFAULT").setOrder(0).setPolicy(FilteringPolicy.INCLUDE).setRule(FilteringRuleCondition.REGEX).setUpdatedAt(currentTimestamp).setValue(".*").build())).setFilteringValidationInfo(new FilteringValidationInfo.Builder().setValidationErrors(Collections.emptyList()).setValidationState(FilteringValidationState.VALID).build()).build()).build();
    }

    static {
        PARSER.declareObject(ConstructingObjectParser.constructorArg(), (p, c) -> FilteringRules.fromXContent(p), ACTIVE_FIELD);
        PARSER.declareString(ConstructingObjectParser.constructorArg(), DOMAIN_FIELD);
        PARSER.declareObject(ConstructingObjectParser.constructorArg(), (p, c) -> FilteringRules.fromXContent(p), DRAFT_FIELD);
    }

    public static class Builder {
        private FilteringRules active;
        private String domain;
        private FilteringRules draft;

        public Builder setActive(FilteringRules active) {
            this.active = active;
            return this;
        }

        public Builder setDomain(String domain) {
            this.domain = domain;
            return this;
        }

        public Builder setDraft(FilteringRules draft) {
            this.draft = draft;
            return this;
        }

        public ConnectorFiltering build() {
            return new ConnectorFiltering(this.active, this.domain, this.draft);
        }
    }
}

