/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.services;

import java.io.Closeable;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.lucene.util.SetOnce;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.core.IOUtils;
import org.elasticsearch.inference.InferenceService;
import org.elasticsearch.inference.InferenceServiceResults;
import org.elasticsearch.inference.Model;
import org.elasticsearch.xpack.inference.external.http.sender.HttpRequestSenderFactory;
import org.elasticsearch.xpack.inference.external.http.sender.Sender;
import org.elasticsearch.xpack.inference.services.ServiceComponents;

public abstract class SenderService
implements InferenceService {
    private final SetOnce<HttpRequestSenderFactory> factory;
    private final SetOnce<ServiceComponents> serviceComponents;
    private final AtomicReference<Sender> sender = new AtomicReference();

    public SenderService(SetOnce<HttpRequestSenderFactory> factory, SetOnce<ServiceComponents> serviceComponents) {
        this.factory = Objects.requireNonNull(factory);
        this.serviceComponents = Objects.requireNonNull(serviceComponents);
    }

    protected Sender getSender() {
        return this.sender.get();
    }

    protected ServiceComponents getServiceComponents() {
        return (ServiceComponents)this.serviceComponents.get();
    }

    public void infer(Model model, List<String> input, Map<String, Object> taskSettings, ActionListener<InferenceServiceResults> listener) {
        this.init();
        this.doInfer(model, input, taskSettings, listener);
    }

    protected abstract void doInfer(Model var1, List<String> var2, Map<String, Object> var3, ActionListener<InferenceServiceResults> var4);

    public void start(Model model, ActionListener<Boolean> listener) {
        this.init();
        this.doStart(model, listener);
    }

    protected void doStart(Model model, ActionListener<Boolean> listener) {
        listener.onResponse((Object)true);
    }

    private void init() {
        this.sender.updateAndGet(current -> Objects.requireNonNullElseGet(current, () -> ((HttpRequestSenderFactory)this.factory.get()).createSender(this.name())));
        this.sender.get().start();
    }

    public void close() throws IOException {
        IOUtils.closeWhileHandlingException((Closeable)this.sender.get());
    }
}

