/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.rest;

import java.util.List;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.client.internal.node.NodeClient;
import org.elasticsearch.inference.TaskType;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.action.RestToXContentListener;
import org.elasticsearch.xpack.core.inference.action.GetInferenceModelAction;

public class RestGetInferenceModelAction
extends BaseRestHandler {
    public String getName() {
        return "get_inference_model_action";
    }

    public List<RestHandler.Route> routes() {
        return List.of(new RestHandler.Route(RestRequest.Method.GET, "_inference/{task_type}/{model_id}"), new RestHandler.Route(RestRequest.Method.GET, "_inference/_all"));
    }

    protected BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest restRequest, NodeClient client) {
        String modelId = null;
        TaskType taskType = null;
        if (!restRequest.hasParam("task_type") && !restRequest.hasParam("model_id")) {
            modelId = "_all";
            taskType = TaskType.ANY;
        } else {
            taskType = TaskType.fromStringOrStatusException((String)restRequest.param("task_type"));
            modelId = restRequest.param("model_id");
        }
        GetInferenceModelAction.Request request = new GetInferenceModelAction.Request(modelId, taskType);
        return channel -> client.execute((ActionType)GetInferenceModelAction.INSTANCE, (ActionRequest)request, (ActionListener)new RestToXContentListener(channel));
    }
}

