/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.external.response.huggingface;

import java.io.IOException;
import java.util.List;
import org.elasticsearch.common.xcontent.LoggingDeprecationHandler;
import org.elasticsearch.common.xcontent.XContentParserUtils;
import org.elasticsearch.xcontent.DeprecationHandler;
import org.elasticsearch.xcontent.XContentFactory;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xcontent.XContentParserConfiguration;
import org.elasticsearch.xcontent.XContentType;
import org.elasticsearch.xpack.core.inference.results.TextEmbeddingResults;
import org.elasticsearch.xpack.inference.external.http.HttpResult;
import org.elasticsearch.xpack.inference.external.request.Request;
import org.elasticsearch.xpack.inference.external.response.XContentUtils;

public class HuggingFaceEmbeddingsResponseEntity {
    private static final String FAILED_TO_FIND_FIELD_TEMPLATE = "Failed to find required field [%s] in Hugging Face embeddings response";

    public static TextEmbeddingResults fromResponse(Request request, HttpResult response) throws IOException {
        XContentParserConfiguration parserConfig = XContentParserConfiguration.EMPTY.withDeprecationHandler((DeprecationHandler)LoggingDeprecationHandler.INSTANCE);
        try (XContentParser jsonParser = XContentFactory.xContent((XContentType)XContentType.JSON).createParser(parserConfig, response.body());){
            XContentUtils.moveToFirstToken(jsonParser);
            XContentParser.Token token = jsonParser.currentToken();
            if (token == XContentParser.Token.START_ARRAY) {
                TextEmbeddingResults textEmbeddingResults = HuggingFaceEmbeddingsResponseEntity.parseArrayFormat(jsonParser);
                return textEmbeddingResults;
            }
            if (token == XContentParser.Token.START_OBJECT) {
                TextEmbeddingResults textEmbeddingResults = HuggingFaceEmbeddingsResponseEntity.parseObjectFormat(jsonParser);
                return textEmbeddingResults;
            }
            XContentParserUtils.throwUnknownToken((XContentParser.Token)token, (XContentParser)jsonParser);
        }
        throw new IllegalStateException("Reached an invalid state while parsing the hugging face response");
    }

    private static TextEmbeddingResults parseArrayFormat(XContentParser parser) throws IOException {
        List embeddingList = XContentParserUtils.parseList((XContentParser)parser, HuggingFaceEmbeddingsResponseEntity::parseEmbeddingEntry);
        return new TextEmbeddingResults(embeddingList);
    }

    private static TextEmbeddingResults parseObjectFormat(XContentParser parser) throws IOException {
        XContentUtils.positionParserAtTokenAfterField(parser, "embeddings", FAILED_TO_FIND_FIELD_TEMPLATE);
        List embeddingList = XContentParserUtils.parseList((XContentParser)parser, HuggingFaceEmbeddingsResponseEntity::parseEmbeddingEntry);
        return new TextEmbeddingResults(embeddingList);
    }

    private static TextEmbeddingResults.Embedding parseEmbeddingEntry(XContentParser parser) throws IOException {
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_ARRAY, (XContentParser.Token)parser.currentToken(), (XContentParser)parser);
        List embeddingValues = XContentParserUtils.parseList((XContentParser)parser, HuggingFaceEmbeddingsResponseEntity::parseEmbeddingList);
        return new TextEmbeddingResults.Embedding(embeddingValues);
    }

    private static float parseEmbeddingList(XContentParser parser) throws IOException {
        XContentParser.Token token = parser.currentToken();
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.VALUE_NUMBER, (XContentParser.Token)token, (XContentParser)parser);
        return parser.floatValue();
    }

    private HuggingFaceEmbeddingsResponseEntity() {
    }
}

