/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.external.request.huggingface;

import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.entity.ByteArrayEntity;
import org.elasticsearch.common.Strings;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentType;
import org.elasticsearch.xpack.inference.common.Truncator;
import org.elasticsearch.xpack.inference.external.huggingface.HuggingFaceAccount;
import org.elasticsearch.xpack.inference.external.request.Request;
import org.elasticsearch.xpack.inference.external.request.RequestUtils;
import org.elasticsearch.xpack.inference.external.request.huggingface.HuggingFaceInferenceRequestEntity;

public class HuggingFaceInferenceRequest
implements Request {
    private final Truncator truncator;
    private final HuggingFaceAccount account;
    private final Truncator.TruncationResult truncationResult;

    public HuggingFaceInferenceRequest(Truncator truncator, HuggingFaceAccount account, Truncator.TruncationResult input) {
        this.truncator = Objects.requireNonNull(truncator);
        this.account = Objects.requireNonNull(account);
        this.truncationResult = Objects.requireNonNull(input);
    }

    @Override
    public HttpRequestBase createRequest() {
        HttpPost httpPost = new HttpPost(this.account.url());
        ByteArrayEntity byteEntity = new ByteArrayEntity(Strings.toString((ToXContent)new HuggingFaceInferenceRequestEntity(this.truncationResult.input())).getBytes(StandardCharsets.UTF_8));
        httpPost.setEntity((HttpEntity)byteEntity);
        httpPost.setHeader("Content-Type", XContentType.JSON.mediaTypeWithoutParameters());
        httpPost.setHeader(RequestUtils.createAuthBearerHeader(this.account.apiKey()));
        return httpPost;
    }

    @Override
    public URI getURI() {
        return this.account.url();
    }

    @Override
    public Request truncate() {
        Truncator.TruncationResult truncateResult = this.truncator.truncate(this.truncationResult.input());
        return new HuggingFaceInferenceRequest(this.truncator, this.account, truncateResult);
    }

    @Override
    public boolean[] getTruncationInfo() {
        return (boolean[])this.truncationResult.truncated().clone();
    }
}

