/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.external.http;

import org.apache.http.client.methods.HttpRequestBase;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.core.Strings;
import org.elasticsearch.xpack.inference.external.http.HttpResult;
import org.elasticsearch.xpack.inference.logging.ThrottlerManager;

public class HttpUtils {
    public static void checkForFailureStatusCode(ThrottlerManager throttlerManager, Logger logger, HttpRequestBase request, HttpResult result) {
        if (result.response().getStatusLine().getStatusCode() >= 300) {
            String message = HttpUtils.getStatusCodeErrorMessage(request, result);
            throttlerManager.warn(logger, message);
            throw new IllegalStateException(message);
        }
    }

    private static String getStatusCodeErrorMessage(HttpRequestBase request, HttpResult result) {
        int statusCode = result.response().getStatusLine().getStatusCode();
        if (statusCode >= 400) {
            return Strings.format((String)"Received a failure status code for request [%s] status [%s]", (Object[])new Object[]{request.getRequestLine(), result.response().getStatusLine().getStatusCode()});
        }
        if (statusCode >= 300) {
            return Strings.format((String)"Unhandled redirection for request [%s] status [%s]", (Object[])new Object[]{request.getRequestLine(), result.response().getStatusLine().getStatusCode()});
        }
        return "";
    }

    public static void checkForEmptyBody(ThrottlerManager throttlerManager, Logger logger, HttpRequestBase request, HttpResult result) {
        if (result.isBodyEmpty()) {
            String message = Strings.format((String)"Response body was empty for request [%s]", (Object[])new Object[]{request.getRequestLine()});
            throttlerManager.warn(logger, message);
            throw new IllegalStateException(message);
        }
    }

    private HttpUtils() {
    }
}

