/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.action;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.Executor;
import org.elasticsearch.ElasticsearchStatusException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRunnable;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.HandledTransportAction;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.inference.InferenceService;
import org.elasticsearch.inference.InferenceServiceRegistry;
import org.elasticsearch.inference.Model;
import org.elasticsearch.inference.ModelConfigurations;
import org.elasticsearch.inference.TaskType;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.core.inference.action.GetInferenceModelAction;
import org.elasticsearch.xpack.inference.registry.ModelRegistry;

public class TransportGetInferenceModelAction
extends HandledTransportAction<GetInferenceModelAction.Request, GetInferenceModelAction.Response> {
    private final ModelRegistry modelRegistry;
    private final InferenceServiceRegistry serviceRegistry;
    private final Executor executor;

    @Inject
    public TransportGetInferenceModelAction(TransportService transportService, ActionFilters actionFilters, ThreadPool threadPool, ModelRegistry modelRegistry, InferenceServiceRegistry serviceRegistry) {
        super("cluster:admin/xpack/inference/get", transportService, actionFilters, GetInferenceModelAction.Request::new, (Executor)EsExecutors.DIRECT_EXECUTOR_SERVICE);
        this.modelRegistry = modelRegistry;
        this.serviceRegistry = serviceRegistry;
        this.executor = threadPool.executor("inference_utility");
    }

    protected void doExecute(Task task, GetInferenceModelAction.Request request, ActionListener<GetInferenceModelAction.Response> listener) {
        boolean modelIdIsWildCard = Strings.isAllOrWildcard((String)request.getModelId());
        if (request.getTaskType() == TaskType.ANY && modelIdIsWildCard) {
            this.getAllModels(listener);
        } else if (modelIdIsWildCard) {
            this.getModelsByTaskType(request.getTaskType(), listener);
        } else {
            this.getSingleModel(request.getModelId(), request.getTaskType(), listener);
        }
    }

    private void getSingleModel(String modelId, TaskType requestedTaskType, ActionListener<GetInferenceModelAction.Response> listener) {
        this.modelRegistry.getModel(modelId, (ActionListener<ModelRegistry.UnparsedModel>)ActionListener.wrap(unparsedModel -> {
            Optional service = this.serviceRegistry.getService(unparsedModel.service());
            if (service.isEmpty()) {
                listener.onFailure((Exception)new ElasticsearchStatusException("Unknown service [{}] for model [{}]. ", RestStatus.INTERNAL_SERVER_ERROR, new Object[]{unparsedModel.service(), unparsedModel.modelId()}));
                return;
            }
            if (!requestedTaskType.isAnyOrSame(unparsedModel.taskType())) {
                listener.onFailure((Exception)new ElasticsearchStatusException("Requested task type [{}] does not match the model's task type [{}]", RestStatus.BAD_REQUEST, new Object[]{requestedTaskType, unparsedModel.taskType()}));
                return;
            }
            Model model = ((InferenceService)service.get()).parsePersistedConfig(unparsedModel.modelId(), unparsedModel.taskType(), unparsedModel.settings());
            listener.onResponse((Object)new GetInferenceModelAction.Response(List.of(model.getConfigurations())));
        }, arg_0 -> listener.onFailure(arg_0)));
    }

    private void getAllModels(ActionListener<GetInferenceModelAction.Response> listener) {
        this.modelRegistry.getAllModels((ActionListener<List<ModelRegistry.UnparsedModel>>)ActionListener.wrap(models -> this.executor.execute((Runnable)ActionRunnable.supply((ActionListener)listener, () -> this.parseModels((List<ModelRegistry.UnparsedModel>)models))), arg_0 -> listener.onFailure(arg_0)));
    }

    private void getModelsByTaskType(TaskType taskType, ActionListener<GetInferenceModelAction.Response> listener) {
        this.modelRegistry.getModelsByTaskType(taskType, (ActionListener<List<ModelRegistry.UnparsedModel>>)ActionListener.wrap(models -> this.executor.execute((Runnable)ActionRunnable.supply((ActionListener)listener, () -> this.parseModels((List<ModelRegistry.UnparsedModel>)models))), arg_0 -> listener.onFailure(arg_0)));
    }

    private GetInferenceModelAction.Response parseModels(List<ModelRegistry.UnparsedModel> unparsedModels) {
        ArrayList<ModelConfigurations> parsedModels = new ArrayList<ModelConfigurations>();
        for (ModelRegistry.UnparsedModel unparsedModel : unparsedModels) {
            Optional service = this.serviceRegistry.getService(unparsedModel.service());
            if (service.isEmpty()) {
                throw new ElasticsearchStatusException("Unknown service [{}] for model [{}]. ", RestStatus.INTERNAL_SERVER_ERROR, new Object[]{unparsedModel.service(), unparsedModel.modelId()});
            }
            parsedModels.add(((InferenceService)service.get()).parsePersistedConfig(unparsedModel.modelId(), unparsedModel.taskType(), unparsedModel.settings()).getConfigurations());
        }
        return new GetInferenceModelAction.Response(parsedModels);
    }
}

