/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.support;

import java.time.Instant;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.ElasticsearchStatusException;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.ResourceAlreadyExistsException;
import org.elasticsearch.Version;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.UnavailableShardsException;
import org.elasticsearch.action.admin.indices.alias.Alias;
import org.elasticsearch.action.admin.indices.create.CreateIndexRequest;
import org.elasticsearch.action.admin.indices.create.CreateIndexResponse;
import org.elasticsearch.action.admin.indices.mapping.put.PutMappingRequest;
import org.elasticsearch.action.support.ActiveShardCount;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.client.internal.IndicesAdminClient;
import org.elasticsearch.cluster.ClusterChangedEvent;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateListener;
import org.elasticsearch.cluster.health.ClusterHealthStatus;
import org.elasticsearch.cluster.health.ClusterIndexHealth;
import org.elasticsearch.cluster.metadata.IndexAbstraction;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.metadata.MappingMetadata;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.cluster.routing.IndexRoutingTable;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.VersionId;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.core.Tuple;
import org.elasticsearch.gateway.GatewayService;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.IndexNotFoundException;
import org.elasticsearch.indices.IndexClosedException;
import org.elasticsearch.indices.SystemIndexDescriptor;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.xcontent.XContentType;
import org.elasticsearch.xpack.core.ClientHelper;

public class SecurityIndexManager
implements ClusterStateListener {
    public static final String SECURITY_VERSION_STRING = "security-version";
    private static final Logger logger = LogManager.getLogger(SecurityIndexManager.class);
    private final Client client;
    private final SystemIndexDescriptor systemIndexDescriptor;
    private final List<BiConsumer<State, State>> stateChangeListeners = new CopyOnWriteArrayList<BiConsumer<State, State>>();
    private volatile State state;
    private final boolean defensiveCopy;

    public static SecurityIndexManager buildSecurityIndexManager(Client client, ClusterService clusterService, SystemIndexDescriptor descriptor) {
        SecurityIndexManager securityIndexManager = new SecurityIndexManager(client, descriptor, State.UNRECOVERED_STATE, false);
        clusterService.addListener((ClusterStateListener)securityIndexManager);
        return securityIndexManager;
    }

    private SecurityIndexManager(Client client, SystemIndexDescriptor descriptor, State state, boolean defensiveCopy) {
        this.client = client;
        this.state = state;
        this.systemIndexDescriptor = descriptor;
        this.defensiveCopy = defensiveCopy;
    }

    public SecurityIndexManager defensiveCopy() {
        return new SecurityIndexManager(null, this.systemIndexDescriptor, this.state, true);
    }

    public String aliasName() {
        return this.systemIndexDescriptor.getAliasName();
    }

    public boolean indexExists() {
        return this.state.indexExists();
    }

    public boolean indexIsClosed() {
        return this.state.indexState == IndexMetadata.State.CLOSE;
    }

    public Instant getCreationTime() {
        return this.state.creationTime;
    }

    public boolean isIndexUpToDate() {
        return this.state.isIndexUpToDate;
    }

    public boolean isAvailable(Availability availability) {
        switch (availability) {
            case SEARCH_SHARDS: {
                return this.state.indexAvailableForSearch;
            }
            case PRIMARY_SHARDS: {
                return this.state.indexAvailableForWrite;
            }
        }
        throw new IllegalStateException("Unexpected availability enumeration. This is bug, please contact support.");
    }

    public boolean isMappingUpToDate() {
        return this.state.mappingUpToDate;
    }

    public boolean isStateRecovered() {
        return this.state != State.UNRECOVERED_STATE;
    }

    public ElasticsearchException getUnavailableReason(Availability availability) {
        if (!this.defensiveCopy) {
            throw new IllegalStateException("caller must make sure to use a defensive copy");
        }
        State state = this.state;
        if (state.indexState == IndexMetadata.State.CLOSE) {
            return new IndexClosedException(new Index(state.concreteIndexName, "_na_"));
        }
        if (state.indexExists()) {
            assert (!state.indexAvailableForSearch || !state.indexAvailableForWrite);
            if (Availability.PRIMARY_SHARDS.equals((Object)availability) && !state.indexAvailableForWrite) {
                return new UnavailableShardsException(null, "at least one primary shard for the index [" + state.concreteIndexName + "] is unavailable", new Object[0]);
            }
            if (Availability.SEARCH_SHARDS.equals((Object)availability) && !state.indexAvailableForSearch) {
                return new UnavailableShardsException(null, "at least one search shard for the index [" + state.concreteIndexName + "] is unavailable", new Object[0]);
            }
            throw new IllegalStateException("caller must ensure original availability matches the current availability");
        }
        return new IndexNotFoundException(state.concreteIndexName);
    }

    public void addStateListener(BiConsumer<State, State> listener) {
        this.stateChangeListeners.add(listener);
    }

    public void removeStateListener(BiConsumer<State, State> listener) {
        this.stateChangeListeners.remove(listener);
    }

    public void clusterChanged(ClusterChangedEvent event) {
        State newState;
        ClusterHealthStatus indexHealth;
        IndexMetadata.State indexState;
        String concreteIndexName;
        if (event.state().blocks().hasGlobalBlock(GatewayService.STATE_NOT_RECOVERED_BLOCK)) {
            logger.debug("security index manager waiting until state has been recovered");
            return;
        }
        State previousState = this.state;
        IndexMetadata indexMetadata = SecurityIndexManager.resolveConcreteIndex(this.systemIndexDescriptor.getAliasName(), event.state().metadata());
        Instant creationTime = indexMetadata != null ? Instant.ofEpochMilli(indexMetadata.getCreationDate()) : null;
        boolean isIndexUpToDate = indexMetadata == null || ((Integer)IndexMetadata.INDEX_FORMAT_SETTING.get(indexMetadata.getSettings())).intValue() == this.systemIndexDescriptor.getIndexFormat();
        Tuple<Boolean, Boolean> available = this.checkIndexAvailable(event.state());
        boolean indexAvailableForWrite = (Boolean)available.v1();
        boolean indexAvailableForSearch = (Boolean)available.v2();
        boolean mappingIsUpToDate = indexMetadata == null || this.checkIndexMappingUpToDate(event.state());
        Version mappingVersion = this.oldestIndexMappingVersion(event.state());
        String string = concreteIndexName = indexMetadata == null ? this.systemIndexDescriptor.getPrimaryIndex() : indexMetadata.getIndex().getName();
        if (indexMetadata == null) {
            indexState = null;
            indexHealth = null;
        } else if (indexMetadata.getState() == IndexMetadata.State.CLOSE) {
            indexState = IndexMetadata.State.CLOSE;
            indexHealth = null;
            logger.warn("Index [{}] is closed. This is likely to prevent security from functioning correctly", (Object)concreteIndexName);
        } else {
            indexState = IndexMetadata.State.OPEN;
            IndexRoutingTable routingTable = event.state().getRoutingTable().index(indexMetadata.getIndex());
            indexHealth = new ClusterIndexHealth(indexMetadata, routingTable).getStatus();
        }
        String indexUUID = indexMetadata != null ? indexMetadata.getIndexUUID() : null;
        this.state = newState = new State(creationTime, isIndexUpToDate, indexAvailableForSearch, indexAvailableForWrite, mappingIsUpToDate, mappingVersion, concreteIndexName, indexHealth, indexState, event.state().nodes().getSmallestNonClientNodeVersion(), indexUUID);
        if (!newState.equals(previousState)) {
            for (BiConsumer<State, State> listener : this.stateChangeListeners) {
                listener.accept(previousState, newState);
            }
        }
    }

    public void onStateRecovered(Consumer<State> recoveredStateConsumer) {
        BiConsumer<State, State> stateChangeListener = (previousState, nextState) -> {
            boolean stateAlreadyRecovered;
            boolean stateJustRecovered = previousState == State.UNRECOVERED_STATE && nextState != State.UNRECOVERED_STATE;
            boolean bl = stateAlreadyRecovered = previousState != State.UNRECOVERED_STATE;
            if (stateJustRecovered) {
                recoveredStateConsumer.accept((State)nextState);
            } else if (stateAlreadyRecovered) {
                this.stateChangeListeners.remove(this);
            }
        };
        this.stateChangeListeners.add(stateChangeListener);
    }

    private Tuple<Boolean, Boolean> checkIndexAvailable(ClusterState state) {
        String aliasName = this.systemIndexDescriptor.getAliasName();
        IndexMetadata metadata = SecurityIndexManager.resolveConcreteIndex(aliasName, state.metadata());
        if (metadata == null) {
            logger.debug("Index [{}] is not available - no metadata", (Object)aliasName);
            return new Tuple((Object)false, (Object)false);
        }
        if (metadata.getState() == IndexMetadata.State.CLOSE) {
            logger.warn("Index [{}] is closed", (Object)aliasName);
            return new Tuple((Object)false, (Object)false);
        }
        boolean allPrimaryShards = false;
        boolean searchShards = false;
        IndexRoutingTable routingTable = state.routingTable().index(metadata.getIndex());
        if (routingTable != null && routingTable.allPrimaryShardsActive()) {
            allPrimaryShards = true;
        }
        if (routingTable != null && routingTable.readyForSearch(state)) {
            searchShards = true;
        }
        if (!allPrimaryShards || !searchShards) {
            logger.debug("Index [{}] is not fully available. all primary shards available [{}], search shards available, [{}]", (Object)aliasName, (Object)allPrimaryShards, (Object)searchShards);
        }
        return new Tuple((Object)allPrimaryShards, (Object)searchShards);
    }

    private boolean checkIndexMappingUpToDate(ClusterState clusterState) {
        Version minimumNonClientNodeVersion = clusterState.nodes().getSmallestNonClientNodeVersion();
        SystemIndexDescriptor descriptor = this.systemIndexDescriptor.getDescriptorCompatibleWith(minimumNonClientNodeVersion);
        if (descriptor == null) {
            return false;
        }
        return this.checkIndexMappingVersionMatches(clusterState, arg_0 -> ((Version)descriptor.getMappingsNodeVersion()).onOrBefore(arg_0));
    }

    private boolean checkIndexMappingVersionMatches(ClusterState clusterState, Predicate<Version> predicate) {
        return SecurityIndexManager.checkIndexMappingVersionMatches(this.systemIndexDescriptor.getAliasName(), clusterState, logger, predicate);
    }

    public static boolean checkIndexMappingVersionMatches(String indexName, ClusterState clusterState, Logger logger, Predicate<Version> predicate) {
        return SecurityIndexManager.loadIndexMappingVersions(indexName, clusterState, logger).stream().allMatch(predicate);
    }

    private Version oldestIndexMappingVersion(ClusterState clusterState) {
        Set<Version> versions = SecurityIndexManager.loadIndexMappingVersions(this.systemIndexDescriptor.getAliasName(), clusterState, logger);
        return versions.stream().min(VersionId::compareTo).orElse(null);
    }

    private static Set<Version> loadIndexMappingVersions(String aliasName, ClusterState clusterState, Logger logger) {
        MappingMetadata mappingMetadata;
        HashSet<Version> versions = new HashSet<Version>();
        IndexMetadata indexMetadata = SecurityIndexManager.resolveConcreteIndex(aliasName, clusterState.metadata());
        if (indexMetadata != null && (mappingMetadata = indexMetadata.mapping()) != null) {
            versions.add(SecurityIndexManager.readMappingVersion(aliasName, mappingMetadata, logger));
        }
        return versions;
    }

    private static IndexMetadata resolveConcreteIndex(String indexOrAliasName, Metadata metadata) {
        IndexAbstraction indexAbstraction = (IndexAbstraction)metadata.getIndicesLookup().get(indexOrAliasName);
        if (indexAbstraction != null) {
            List indices = indexAbstraction.getIndices();
            if (indexAbstraction.getType() != IndexAbstraction.Type.CONCRETE_INDEX && indices.size() > 1) {
                throw new IllegalStateException("Alias [" + indexOrAliasName + "] points to more than one index: " + indices);
            }
            return metadata.index((Index)indices.get(0));
        }
        return null;
    }

    private static Version readMappingVersion(String indexName, MappingMetadata mappingMetadata, Logger logger) {
        try {
            Map meta = (Map)mappingMetadata.sourceAsMap().get("_meta");
            if (meta == null) {
                logger.info("Missing _meta field in mapping [{}] of index [{}]", (Object)mappingMetadata.type(), (Object)indexName);
                throw new IllegalStateException("Cannot read security-version string in index " + indexName);
            }
            return Version.fromString((String)((String)meta.get(SECURITY_VERSION_STRING)));
        }
        catch (ElasticsearchParseException e) {
            logger.error(() -> "Cannot parse the mapping for index [" + indexName + "]", (Throwable)e);
            throw new ElasticsearchException("Cannot parse the mapping for index [{}]", (Throwable)e, new Object[]{indexName});
        }
    }

    public void checkIndexVersionThenExecute(Consumer<Exception> consumer, Runnable andThen) {
        State state = this.state;
        if (state.indexExists() && !state.isIndexUpToDate) {
            consumer.accept(new IllegalStateException("Index [" + state.concreteIndexName + "] is not on the current version. Security features relying on the index will not be available until the upgrade API is run on the index"));
        } else {
            andThen.run();
        }
    }

    public void prepareIndexIfNeededThenExecute(final Consumer<Exception> consumer, final Runnable andThen) {
        State state = this.state;
        try {
            if (state == State.UNRECOVERED_STATE) {
                throw new ElasticsearchStatusException("Cluster state has not been recovered yet, cannot write to the [" + state.concreteIndexName + "] index", RestStatus.SERVICE_UNAVAILABLE, new Object[0]);
            }
            if (state.indexExists() && !state.isIndexUpToDate) {
                throw new IllegalStateException("Index [" + state.concreteIndexName + "] is not on the current version.Security features relying on the index will not be available until the upgrade API is run on the index");
            }
            if (!state.indexExists()) {
                assert (state.concreteIndexName != null);
                SystemIndexDescriptor descriptorForVersion = this.systemIndexDescriptor.getDescriptorCompatibleWith(state.minimumNodeVersion);
                if (descriptorForVersion == null) {
                    String error = this.systemIndexDescriptor.getMinimumNodeVersionMessage("create index");
                    consumer.accept(new IllegalStateException(error));
                } else {
                    logger.info("security index does not exist, creating [{}] with alias [{}]", (Object)state.concreteIndexName, (Object)descriptorForVersion.getAliasName());
                    CreateIndexRequest request = new CreateIndexRequest(state.concreteIndexName).origin(descriptorForVersion.getOrigin()).mapping(descriptorForVersion.getMappings()).settings(descriptorForVersion.getSettings()).alias(new Alias(descriptorForVersion.getAliasName())).waitForActiveShards(ActiveShardCount.ALL);
                    ClientHelper.executeAsyncWithOrigin((ThreadContext)this.client.threadPool().getThreadContext(), (String)descriptorForVersion.getOrigin(), (ActionRequest)request, (ActionListener)new ActionListener<CreateIndexResponse>(){

                        public void onResponse(CreateIndexResponse createIndexResponse) {
                            if (createIndexResponse.isAcknowledged()) {
                                andThen.run();
                            } else {
                                consumer.accept(new ElasticsearchException("Failed to create security index", new Object[0]));
                            }
                        }

                        public void onFailure(Exception e) {
                            Throwable cause = ExceptionsHelper.unwrapCause((Throwable)e);
                            if (cause instanceof ResourceAlreadyExistsException) {
                                andThen.run();
                            } else {
                                consumer.accept(e);
                            }
                        }
                    }, (arg_0, arg_1) -> ((IndicesAdminClient)this.client.admin().indices()).create(arg_0, arg_1));
                }
            } else if (!state.mappingUpToDate) {
                SystemIndexDescriptor descriptorForVersion = this.systemIndexDescriptor.getDescriptorCompatibleWith(state.minimumNodeVersion);
                if (descriptorForVersion == null) {
                    String error = this.systemIndexDescriptor.getMinimumNodeVersionMessage("updating mapping");
                    consumer.accept(new IllegalStateException(error));
                } else {
                    logger.info("Index [{}] (alias [{}]) is not up to date. Updating mapping", (Object)state.concreteIndexName, (Object)descriptorForVersion.getAliasName());
                    PutMappingRequest request = new PutMappingRequest(new String[]{state.concreteIndexName}).source(descriptorForVersion.getMappings(), XContentType.JSON).origin(descriptorForVersion.getOrigin());
                    ClientHelper.executeAsyncWithOrigin((ThreadContext)this.client.threadPool().getThreadContext(), (String)descriptorForVersion.getOrigin(), (ActionRequest)request, (ActionListener)ActionListener.wrap(putMappingResponse -> {
                        if (putMappingResponse.isAcknowledged()) {
                            andThen.run();
                        } else {
                            consumer.accept(new IllegalStateException("put mapping request was not acknowledged"));
                        }
                    }, consumer), (arg_0, arg_1) -> ((IndicesAdminClient)this.client.admin().indices()).putMapping(arg_0, arg_1));
                }
            } else {
                andThen.run();
            }
        }
        catch (Exception e) {
            consumer.accept(e);
        }
    }

    public static boolean isMoveFromRedToNonRed(State previousState, State currentState) {
        return (previousState.indexHealth == null || previousState.indexHealth == ClusterHealthStatus.RED) && currentState.indexHealth != null && currentState.indexHealth != ClusterHealthStatus.RED;
    }

    public static boolean isIndexDeleted(State previousState, State currentState) {
        return previousState.indexHealth != null && currentState.indexHealth == null;
    }

    public static class State {
        public static final State UNRECOVERED_STATE = new State(null, false, false, false, false, null, null, null, null, null, null);
        public final Instant creationTime;
        public final boolean isIndexUpToDate;
        public final boolean indexAvailableForSearch;
        public final boolean indexAvailableForWrite;
        public final boolean mappingUpToDate;
        public final Version mappingVersion;
        public final String concreteIndexName;
        public final ClusterHealthStatus indexHealth;
        public final IndexMetadata.State indexState;
        public final Version minimumNodeVersion;
        public final String indexUUID;

        public State(Instant creationTime, boolean isIndexUpToDate, boolean indexAvailableForSearch, boolean indexAvailableForWrite, boolean mappingUpToDate, Version mappingVersion, String concreteIndexName, ClusterHealthStatus indexHealth, IndexMetadata.State indexState, Version minimumNodeVersion, String indexUUID) {
            this.creationTime = creationTime;
            this.isIndexUpToDate = isIndexUpToDate;
            this.indexAvailableForSearch = indexAvailableForSearch;
            this.indexAvailableForWrite = indexAvailableForWrite;
            this.mappingUpToDate = mappingUpToDate;
            this.mappingVersion = mappingVersion;
            this.concreteIndexName = concreteIndexName;
            this.indexHealth = indexHealth;
            this.indexState = indexState;
            this.minimumNodeVersion = minimumNodeVersion;
            this.indexUUID = indexUUID;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            State state = (State)o;
            return Objects.equals(this.creationTime, state.creationTime) && this.isIndexUpToDate == state.isIndexUpToDate && this.indexAvailableForSearch == state.indexAvailableForSearch && this.indexAvailableForWrite == state.indexAvailableForWrite && this.mappingUpToDate == state.mappingUpToDate && Objects.equals(this.mappingVersion, state.mappingVersion) && Objects.equals(this.concreteIndexName, state.concreteIndexName) && this.indexHealth == state.indexHealth && this.indexState == state.indexState && Objects.equals(this.minimumNodeVersion, state.minimumNodeVersion);
        }

        public boolean indexExists() {
            return this.creationTime != null;
        }

        public int hashCode() {
            return Objects.hash(this.creationTime, this.isIndexUpToDate, this.indexAvailableForSearch, this.indexAvailableForWrite, this.mappingUpToDate, this.mappingVersion, this.concreteIndexName, this.indexHealth, this.minimumNodeVersion);
        }
    }

    public static enum Availability {
        SEARCH_SHARDS,
        PRIMARY_SHARDS;

    }
}

