/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.authc.ldap;

import com.unboundid.ldap.sdk.BindRequest;
import com.unboundid.ldap.sdk.LDAPConnection;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.LDAPInterface;
import com.unboundid.ldap.sdk.ServerSet;
import com.unboundid.ldap.sdk.SimpleBindRequest;
import java.io.Closeable;
import java.text.FieldPosition;
import java.text.MessageFormat;
import java.util.List;
import java.util.Locale;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.settings.SecureString;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.util.concurrent.AbstractRunnable;
import org.elasticsearch.core.CharArrays;
import org.elasticsearch.core.IOUtils;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.xpack.core.security.authc.RealmConfig;
import org.elasticsearch.xpack.core.security.authc.RealmSettings;
import org.elasticsearch.xpack.core.security.authc.ldap.LdapSessionFactorySettings;
import org.elasticsearch.xpack.core.security.authc.ldap.SearchGroupsResolverSettings;
import org.elasticsearch.xpack.core.ssl.SSLService;
import org.elasticsearch.xpack.security.authc.ldap.SearchGroupsResolver;
import org.elasticsearch.xpack.security.authc.ldap.UserAttributeGroupsResolver;
import org.elasticsearch.xpack.security.authc.ldap.support.LdapSession;
import org.elasticsearch.xpack.security.authc.ldap.support.LdapUtils;
import org.elasticsearch.xpack.security.authc.ldap.support.SessionFactory;

public class LdapSessionFactory
extends SessionFactory {
    private final String[] userDnTemplates;
    private final LdapSession.GroupsResolver groupResolver;

    public LdapSessionFactory(RealmConfig config, SSLService sslService, ThreadPool threadPool) {
        super(config, sslService, threadPool);
        this.userDnTemplates = ((List)config.getSetting(LdapSessionFactorySettings.USER_DN_TEMPLATES_SETTING)).toArray(Strings.EMPTY_ARRAY);
        if (this.userDnTemplates.length == 0) {
            throw new IllegalArgumentException("missing required LDAP setting [" + RealmSettings.getFullSettingKey((RealmConfig)config, (Setting.AffixSetting)LdapSessionFactorySettings.USER_DN_TEMPLATES_SETTING) + "]");
        }
        this.logger.info("Realm [{}] is in user-dn-template mode: [{}]", (Object)config.name(), (Object)this.userDnTemplates);
        this.groupResolver = LdapSessionFactory.groupResolver(config);
    }

    @Override
    public void session(final String username, final SecureString password, final ActionListener<LdapSession> listener) {
        try {
            new AbstractRunnable(){
                final LDAPConnection connection = (LDAPConnection)LdapUtils.privilegedConnect(() -> ((ServerSet)LdapSessionFactory.access$000(LdapSessionFactory.this)).getConnection());
                final byte[] passwordBytes = CharArrays.toUtf8Bytes((char[])password.getChars());
                Exception containerException = null;
                int loopIndex = 0;

                protected void doRun() throws Exception {
                    listener.onResponse((Object)new LdapSession(LdapSessionFactory.this.logger, LdapSessionFactory.this.config, (LDAPInterface)this.connection, ((SimpleBindRequest)this.connection.getLastBindRequest()).getBindDN(), LdapSessionFactory.this.groupResolver, LdapSessionFactory.this.metadataResolver, LdapSessionFactory.this.timeout, null));
                }

                public void onFailure(Exception e) {
                    if (this.containerException == null) {
                        this.containerException = e;
                    } else {
                        this.containerException.addSuppressed(e);
                    }
                    if (this.loopIndex > LdapSessionFactory.this.userDnTemplates.length) {
                        listener.onFailure((Exception)new IllegalStateException("User DN template iteration index out of bounds."));
                    } else if (this.loopIndex == LdapSessionFactory.this.userDnTemplates.length) {
                        IOUtils.closeWhileHandlingException((Closeable)this.connection);
                        listener.onFailure(this.containerException);
                    } else {
                        this.loop();
                    }
                }

                void loop() {
                    String template = LdapSessionFactory.this.userDnTemplates[this.loopIndex++];
                    SimpleBindRequest bind = new SimpleBindRequest(LdapSessionFactory.buildDnFromTemplate(username, template), this.passwordBytes);
                    LdapUtils.maybeForkThenBind(this.connection, (BindRequest)bind, false, LdapSessionFactory.this.threadPool, this);
                }
            }.loop();
        }
        catch (LDAPException e) {
            listener.onFailure((Exception)((Object)e));
        }
    }

    static String buildDnFromTemplate(String username, String template) {
        String escapedUsername = LdapUtils.escapedRDNValue(username);
        return new MessageFormat(template, Locale.ROOT).format(new Object[]{escapedUsername}, new StringBuffer(), (FieldPosition)null).toString();
    }

    static LdapSession.GroupsResolver groupResolver(RealmConfig realmConfig) {
        if (realmConfig.hasSetting(SearchGroupsResolverSettings.BASE_DN)) {
            return new SearchGroupsResolver(realmConfig);
        }
        return new UserAttributeGroupsResolver(realmConfig);
    }

    static /* synthetic */ ServerSet access$000(LdapSessionFactory x0) {
        return x0.serverSet;
    }
}

