/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.authz;

import java.util.Arrays;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.IndicesRequest;
import org.elasticsearch.action.search.TransportSearchAction;
import org.elasticsearch.xpack.core.security.SecurityContext;
import org.elasticsearch.xpack.core.security.authz.AuthorizationEngine;
import org.elasticsearch.xpack.core.security.authz.IndicesAndAliasesResolverField;
import org.elasticsearch.xpack.core.security.authz.accesscontrol.IndicesAccessControl;
import org.elasticsearch.xpack.core.security.authz.permission.Role;
import org.elasticsearch.xpack.security.authz.RBACEngine;

public final class PreAuthorizationUtils {
    private static final Logger logger = LogManager.getLogger(PreAuthorizationUtils.class);
    public static final Map<String, Set<String>> CHILD_ACTIONS_PRE_AUTHORIZED_BY_PARENT = Map.of(TransportSearchAction.TYPE.name(), Set.of("indices:data/read/search[free_context]", "indices:data/read/search[phase/dfs]", "indices:data/read/search[phase/query]", "indices:data/read/search[phase/query/id]", "indices:data/read/search[phase/fetch/id]", "indices:data/read/search[can_match][n]"));

    public static void maybeSkipChildrenActionAuthorization(SecurityContext securityContext, AuthorizationEngine.AuthorizationContext parentAuthorizationContext) {
        String parentAction = parentAuthorizationContext.getAction();
        if (!CHILD_ACTIONS_PRE_AUTHORIZED_BY_PARENT.containsKey(parentAction)) {
            return;
        }
        IndicesAccessControl indicesAccessControl = parentAuthorizationContext.getIndicesAccessControl();
        if (indicesAccessControl == null) {
            return;
        }
        if (!indicesAccessControl.isGranted()) {
            return;
        }
        Role role = RBACEngine.maybeGetRBACEngineRole(parentAuthorizationContext.getAuthorizationInfo());
        if (role == null) {
            return;
        }
        if (role.hasFieldOrDocumentLevelSecurity()) {
            return;
        }
        AuthorizationEngine.ParentActionAuthorization existingParentAuthorization = securityContext.getParentAuthorization();
        if (existingParentAuthorization != null) {
            throw new AssertionError((Object)("found parent authorization for action [" + existingParentAuthorization.action() + "] while attempting to set authorization for new parent action [" + parentAction + "]"));
        }
        if (logger.isDebugEnabled()) {
            logger.debug("adding authorization for parent action [" + parentAction + "] to the thread context");
        }
        securityContext.setParentAuthorization(new AuthorizationEngine.ParentActionAuthorization(parentAction));
    }

    private static boolean shouldPreAuthorizeChildActionOfParent(String parent, String child) {
        Set<String> children = CHILD_ACTIONS_PRE_AUTHORIZED_BY_PARENT.get(parent);
        return children != null && children.contains(child);
    }

    public static boolean shouldRemoveParentAuthorizationFromThreadContext(Optional<String> remoteClusterAlias, String childAction, SecurityContext securityContext) {
        AuthorizationEngine.ParentActionAuthorization parentAuthorization = securityContext.getParentAuthorization();
        if (parentAuthorization == null) {
            return false;
        }
        if (remoteClusterAlias.isPresent()) {
            return true;
        }
        return !PreAuthorizationUtils.shouldPreAuthorizeChildActionOfParent(parentAuthorization.action(), childAction);
    }

    public static boolean shouldPreAuthorizeChildByParentAction(AuthorizationEngine.RequestInfo childRequestInfo, AuthorizationEngine.AuthorizationInfo childAuthorizationInfo) {
        String childAction;
        AuthorizationEngine.ParentActionAuthorization parentAuthorization = childRequestInfo.getParentAuthorization();
        if (parentAuthorization == null) {
            return false;
        }
        Role role = RBACEngine.maybeGetRBACEngineRole(childAuthorizationInfo);
        if (role == null) {
            return false;
        }
        if (role.hasFieldOrDocumentLevelSecurity()) {
            return false;
        }
        String parentAction = parentAuthorization.action();
        if (!PreAuthorizationUtils.shouldPreAuthorizeChildActionOfParent(parentAction, childAction = childRequestInfo.getAction())) {
            return false;
        }
        if (!(childRequestInfo.getRequest() instanceof IndicesRequest)) {
            return false;
        }
        IndicesRequest indicesRequest = (IndicesRequest)childRequestInfo.getRequest();
        Object[] indices = indicesRequest.indices();
        if (indices == null || indices.length == 0) {
            return false;
        }
        if (Arrays.equals(IndicesAndAliasesResolverField.NO_INDICES_OR_ALIASES_ARRAY, indices)) {
            return false;
        }
        if (logger.isDebugEnabled()) {
            logger.debug("pre-authorizing child action [" + childAction + "] of parent action [" + parentAction + "]");
        }
        return true;
    }

    private PreAuthorizationUtils() {
        throw new IllegalAccessError();
    }
}

