/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.operator.topn;

import org.apache.lucene.util.BytesRef;
import org.elasticsearch.compute.data.BytesRefBlock;
import org.elasticsearch.compute.data.BytesRefVector;
import org.elasticsearch.compute.operator.BreakingBytesRefBuilder;
import org.elasticsearch.compute.operator.topn.KeyExtractor;
import org.elasticsearch.compute.operator.topn.TopNEncoder;

abstract class KeyExtractorForBytesRef
implements KeyExtractor {
    private final TopNEncoder encoder;
    protected final BytesRef scratch = new BytesRef();
    private final byte nul;
    private final byte nonNul;

    static KeyExtractorForBytesRef extractorFor(TopNEncoder encoder, boolean ascending, byte nul, byte nonNul, BytesRefBlock block) {
        BytesRefVector v = block.asVector();
        if (v != null) {
            return new ForVector(encoder, nul, nonNul, v);
        }
        if (ascending) {
            return block.mvSortedAscending() ? new MinForAscending(encoder, nul, nonNul, block) : new MinForUnordered(encoder, nul, nonNul, block);
        }
        return block.mvSortedAscending() ? new MaxForAscending(encoder, nul, nonNul, block) : new MaxForUnordered(encoder, nul, nonNul, block);
    }

    KeyExtractorForBytesRef(TopNEncoder encoder, byte nul, byte nonNul) {
        this.encoder = encoder;
        this.nul = nul;
        this.nonNul = nonNul;
    }

    protected final int nonNul(BreakingBytesRefBuilder key, BytesRef value) {
        key.append(this.nonNul);
        return this.encoder.encodeBytesRef(value, key) + 1;
    }

    protected final int nul(BreakingBytesRefBuilder key) {
        key.append(this.nul);
        return 1;
    }

    static class ForVector
    extends KeyExtractorForBytesRef {
        private final BytesRefVector vector;

        ForVector(TopNEncoder encoder, byte nul, byte nonNul, BytesRefVector vector) {
            super(encoder, nul, nonNul);
            this.vector = vector;
        }

        @Override
        public int writeKey(BreakingBytesRefBuilder key, int position) {
            return this.nonNul(key, this.vector.getBytesRef(position, this.scratch));
        }
    }

    static class MinForAscending
    extends KeyExtractorForBytesRef {
        private final BytesRefBlock block;

        MinForAscending(TopNEncoder encoder, byte nul, byte nonNul, BytesRefBlock block) {
            super(encoder, nul, nonNul);
            this.block = block;
        }

        @Override
        public int writeKey(BreakingBytesRefBuilder key, int position) {
            if (this.block.isNull(position)) {
                return this.nul(key);
            }
            return this.nonNul(key, this.block.getBytesRef(this.block.getFirstValueIndex(position), this.scratch));
        }
    }

    static class MinForUnordered
    extends KeyExtractorForBytesRef {
        private final BytesRefBlock block;
        private final BytesRef minScratch = new BytesRef();

        MinForUnordered(TopNEncoder encoder, byte nul, byte nonNul, BytesRefBlock block) {
            super(encoder, nul, nonNul);
            this.block = block;
        }

        @Override
        public int writeKey(BreakingBytesRefBuilder key, int position) {
            int size = this.block.getValueCount(position);
            if (size == 0) {
                return this.nul(key);
            }
            int start = this.block.getFirstValueIndex(position);
            int end = start + size;
            BytesRef min = this.block.getBytesRef(start, this.minScratch);
            for (int i = start; i < end; ++i) {
                BytesRef v = this.block.getBytesRef(i, this.scratch);
                if (v.compareTo(min) >= 0) continue;
                min.bytes = v.bytes;
                min.offset = v.offset;
                min.length = v.length;
            }
            return this.nonNul(key, min);
        }
    }

    static class MaxForAscending
    extends KeyExtractorForBytesRef {
        private final BytesRefBlock block;

        MaxForAscending(TopNEncoder encoder, byte nul, byte nonNul, BytesRefBlock block) {
            super(encoder, nul, nonNul);
            this.block = block;
        }

        @Override
        public int writeKey(BreakingBytesRefBuilder key, int position) {
            if (this.block.isNull(position)) {
                return this.nul(key);
            }
            return this.nonNul(key, this.block.getBytesRef(this.block.getFirstValueIndex(position) + this.block.getValueCount(position) - 1, this.scratch));
        }
    }

    static class MaxForUnordered
    extends KeyExtractorForBytesRef {
        private final BytesRefBlock block;
        private final BytesRef maxScratch = new BytesRef();

        MaxForUnordered(TopNEncoder encoder, byte nul, byte nonNul, BytesRefBlock block) {
            super(encoder, nul, nonNul);
            this.block = block;
        }

        @Override
        public int writeKey(BreakingBytesRefBuilder key, int position) {
            int size = this.block.getValueCount(position);
            if (size == 0) {
                return this.nul(key);
            }
            int start = this.block.getFirstValueIndex(position);
            int end = start + size;
            BytesRef max = this.block.getBytesRef(start, this.maxScratch);
            for (int i = start; i < end; ++i) {
                BytesRef v = this.block.getBytesRef(i, this.scratch);
                if (v.compareTo(max) <= 0) continue;
                max.bytes = v.bytes;
                max.offset = v.offset;
                max.length = v.length;
            }
            return this.nonNul(key, max);
        }
    }
}

