/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.operator.exchange;

import java.io.IOException;
import java.util.Map;
import java.util.concurrent.Executor;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.ElasticsearchTimeoutException;
import org.elasticsearch.ResourceNotFoundException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionListenerResponseHandler;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.common.component.AbstractLifecycleComponent;
import org.elasticsearch.common.component.Lifecycle;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.concurrent.AbstractAsyncTask;
import org.elasticsearch.common.util.concurrent.ConcurrentCollections;
import org.elasticsearch.compute.OwningChannelActionListener;
import org.elasticsearch.compute.data.BlockFactory;
import org.elasticsearch.compute.data.BlockStreamInput;
import org.elasticsearch.compute.operator.exchange.ExchangeRequest;
import org.elasticsearch.compute.operator.exchange.ExchangeResponse;
import org.elasticsearch.compute.operator.exchange.ExchangeSinkHandler;
import org.elasticsearch.compute.operator.exchange.ExchangeSourceHandler;
import org.elasticsearch.compute.operator.exchange.RemoteSink;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.tasks.CancellableTask;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.tasks.TaskCancelledException;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportChannel;
import org.elasticsearch.transport.TransportRequest;
import org.elasticsearch.transport.TransportRequestHandler;
import org.elasticsearch.transport.TransportRequestOptions;
import org.elasticsearch.transport.TransportResponse;
import org.elasticsearch.transport.TransportResponseHandler;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.transport.Transports;

public final class ExchangeService
extends AbstractLifecycleComponent {
    public static final String EXCHANGE_ACTION_NAME = "internal:data/read/esql/exchange";
    private static final String OPEN_EXCHANGE_ACTION_NAME = "internal:data/read/esql/open_exchange";
    public static final String INACTIVE_SINKS_INTERVAL_SETTING = "esql.exchange.sink_inactive_interval";
    private static final Logger LOGGER = LogManager.getLogger(ExchangeService.class);
    private final ThreadPool threadPool;
    private final Executor executor;
    private final BlockFactory blockFactory;
    private final Map<String, ExchangeSinkHandler> sinks = ConcurrentCollections.newConcurrentMap();
    private final Map<String, ExchangeSourceHandler> sources = ConcurrentCollections.newConcurrentMap();
    private final InactiveSinksReaper inactiveSinksReaper;

    public ExchangeService(Settings settings, ThreadPool threadPool, String executorName, BlockFactory blockFactory) {
        this.threadPool = threadPool;
        this.executor = threadPool.executor(executorName);
        this.blockFactory = blockFactory;
        TimeValue inactiveInterval = settings.getAsTime(INACTIVE_SINKS_INTERVAL_SETTING, TimeValue.timeValueMinutes((long)5L));
        this.inactiveSinksReaper = new InactiveSinksReaper(LOGGER, threadPool, this.executor, inactiveInterval);
    }

    public void registerTransportHandler(TransportService transportService) {
        transportService.registerRequestHandler(EXCHANGE_ACTION_NAME, this.executor, ExchangeRequest::new, (TransportRequestHandler)new ExchangeTransportAction());
        transportService.registerRequestHandler(OPEN_EXCHANGE_ACTION_NAME, this.executor, OpenExchangeRequest::new, (TransportRequestHandler)new OpenExchangeRequestHandler());
    }

    ExchangeSinkHandler createSinkHandler(String exchangeId, int maxBufferSize) {
        ExchangeSinkHandler sinkHandler = new ExchangeSinkHandler(maxBufferSize, () -> ((ThreadPool)this.threadPool).relativeTimeInMillis());
        if (this.sinks.putIfAbsent(exchangeId, sinkHandler) != null) {
            throw new IllegalStateException("sink exchanger for id [" + exchangeId + "] already exists");
        }
        return sinkHandler;
    }

    public ExchangeSinkHandler getSinkHandler(String exchangeId) {
        ExchangeSinkHandler sinkHandler = this.sinks.get(exchangeId);
        if (sinkHandler == null) {
            throw new ResourceNotFoundException("sink exchanger for id [{}] doesn't exist", new Object[]{exchangeId});
        }
        return sinkHandler;
    }

    public void finishSinkHandler(String exchangeId, Exception failure) {
        ExchangeSinkHandler sinkHandler = this.sinks.remove(exchangeId);
        if (sinkHandler != null) {
            if (failure != null) {
                sinkHandler.onFailure(failure);
            }
            assert (sinkHandler.isFinished()) : "Exchange sink " + exchangeId + " wasn't finished yet";
        }
    }

    public ExchangeSourceHandler createSourceHandler(String exchangeId, int maxBufferSize, String fetchExecutor) {
        ExchangeSourceHandler sourceHandler = new ExchangeSourceHandler(maxBufferSize, this.threadPool.executor(fetchExecutor));
        if (this.sources.putIfAbsent(exchangeId, sourceHandler) != null) {
            throw new IllegalStateException("source exchanger for id [" + exchangeId + "] already exists");
        }
        sourceHandler.addCompletionListener((ActionListener<Void>)ActionListener.releasing(() -> this.sources.remove(exchangeId)));
        return sourceHandler;
    }

    public static void openExchange(TransportService transportService, DiscoveryNode targetNode, String sessionId, int exchangeBuffer, Executor responseExecutor, ActionListener<Void> listener) {
        transportService.sendRequest(targetNode, OPEN_EXCHANGE_ACTION_NAME, (TransportRequest)new OpenExchangeRequest(sessionId, exchangeBuffer), (TransportResponseHandler)new ActionListenerResponseHandler(listener.map(unused -> null), in -> TransportResponse.Empty.INSTANCE, responseExecutor));
    }

    public RemoteSink newRemoteSink(Task parentTask, String exchangeId, TransportService transportService, DiscoveryNode remoteNode) {
        return new TransportRemoteSink(transportService, this.blockFactory, remoteNode, parentTask, exchangeId, this.executor);
    }

    public boolean isEmpty() {
        return this.sources.isEmpty() && this.sinks.isEmpty();
    }

    protected void doStart() {
    }

    protected void doStop() {
        this.inactiveSinksReaper.close();
    }

    protected void doClose() {
        this.doStop();
    }

    public String toString() {
        return "ExchangeService{sinks=" + this.sinks.keySet() + ", sources=" + this.sources.keySet() + "}";
    }

    private final class InactiveSinksReaper
    extends AbstractAsyncTask {
        InactiveSinksReaper(Logger logger, ThreadPool threadPool, Executor executor, TimeValue interval) {
            super(logger, threadPool, executor, interval, true);
            this.rescheduleIfNecessary();
        }

        protected boolean mustReschedule() {
            Lifecycle.State state = ExchangeService.this.lifecycleState();
            return state != Lifecycle.State.STOPPED && state != Lifecycle.State.CLOSED;
        }

        protected void runInternal() {
            assert (Transports.assertNotTransportThread((String)"reaping inactive exchanges can be expensive"));
            assert (ThreadPool.assertNotScheduleThread((String)"reaping inactive exchanges can be expensive"));
            TimeValue maxInterval = this.getInterval();
            long nowInMillis = ExchangeService.this.threadPool.relativeTimeInMillis();
            for (Map.Entry<String, ExchangeSinkHandler> e : ExchangeService.this.sinks.entrySet()) {
                long elapsed;
                ExchangeSinkHandler sink = e.getValue();
                if (sink.hasData() && sink.hasListeners() || (elapsed = nowInMillis - sink.lastUpdatedTimeInMillis()) <= maxInterval.millis()) continue;
                ExchangeService.this.finishSinkHandler(e.getKey(), (Exception)new ElasticsearchTimeoutException("Exchange sink {} has been inactive for {}", new Object[]{e.getKey(), TimeValue.timeValueMillis((long)elapsed)}));
            }
        }
    }

    private class ExchangeTransportAction
    implements TransportRequestHandler<ExchangeRequest> {
        private ExchangeTransportAction() {
        }

        public void messageReceived(ExchangeRequest request, TransportChannel channel, Task task) {
            String exchangeId = request.exchangeId();
            OwningChannelActionListener<ExchangeResponse> listener = new OwningChannelActionListener<ExchangeResponse>(channel);
            ExchangeSinkHandler sinkHandler = ExchangeService.this.sinks.get(exchangeId);
            if (sinkHandler == null) {
                listener.onResponse((Object)new ExchangeResponse(null, true));
            } else {
                if (!sinkHandler.hasData()) {
                    ((CancellableTask)task).addListener(() -> sinkHandler.onFailure((Exception)new TaskCancelledException("task cancelled")));
                }
                sinkHandler.fetchPageAsync(request.sourcesFinished(), listener);
            }
        }
    }

    private class OpenExchangeRequestHandler
    implements TransportRequestHandler<OpenExchangeRequest> {
        private OpenExchangeRequestHandler() {
        }

        public void messageReceived(OpenExchangeRequest request, TransportChannel channel, Task task) throws Exception {
            ExchangeService.this.createSinkHandler(request.sessionId, request.exchangeBuffer);
            channel.sendResponse((TransportResponse)new TransportResponse.Empty());
        }
    }

    private static class OpenExchangeRequest
    extends TransportRequest {
        private final String sessionId;
        private final int exchangeBuffer;

        OpenExchangeRequest(String sessionId, int exchangeBuffer) {
            this.sessionId = sessionId;
            this.exchangeBuffer = exchangeBuffer;
        }

        OpenExchangeRequest(StreamInput in) throws IOException {
            super(in);
            this.sessionId = in.readString();
            this.exchangeBuffer = in.readVInt();
        }

        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeString(this.sessionId);
            out.writeVInt(this.exchangeBuffer);
        }
    }

    record TransportRemoteSink(TransportService transportService, BlockFactory blockFactory, DiscoveryNode node, Task parentTask, String exchangeId, Executor responseExecutor) implements RemoteSink
    {
        @Override
        public void fetchPageAsync(boolean allSourcesFinished, ActionListener<ExchangeResponse> listener) {
            this.transportService.sendChildRequest(this.node, ExchangeService.EXCHANGE_ACTION_NAME, (TransportRequest)new ExchangeRequest(this.exchangeId, allSourcesFinished), this.parentTask, TransportRequestOptions.EMPTY, (TransportResponseHandler)new ActionListenerResponseHandler(listener, in -> new ExchangeResponse(new BlockStreamInput(in, this.blockFactory)), this.responseExecutor));
        }
    }
}

