/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.lucene;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.elasticsearch.common.logging.HeaderWarning;
import org.elasticsearch.index.mapper.BlockLoader;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.query.SearchExecutionContext;
import org.elasticsearch.search.internal.SearchContext;
import org.elasticsearch.search.lookup.SearchLookup;

public final class BlockReaderFactories {
    private BlockReaderFactories() {
    }

    public static List<BlockLoader> loaders(List<SearchContext> searchContexts, String fieldName, boolean asUnsupportedSource) {
        ArrayList<BlockLoader> loaders = new ArrayList<BlockLoader>(searchContexts.size());
        for (SearchContext searchContext : searchContexts) {
            final SearchExecutionContext ctx = searchContext.getSearchExecutionContext();
            if (asUnsupportedSource) {
                loaders.add(BlockLoader.CONSTANT_NULLS);
                continue;
            }
            MappedFieldType fieldType = ctx.getFieldType(fieldName);
            if (fieldType == null) {
                loaders.add(BlockLoader.CONSTANT_NULLS);
                continue;
            }
            BlockLoader loader = fieldType.blockLoader(new MappedFieldType.BlockLoaderContext(){

                public String indexName() {
                    return ctx.getFullyQualifiedIndex().getName();
                }

                public SearchLookup lookup() {
                    return ctx.lookup();
                }

                public Set<String> sourcePaths(String name) {
                    return ctx.sourcePath(name);
                }

                public String parentField(String field) {
                    return ctx.parentPath(field);
                }
            });
            if (loader == null) {
                HeaderWarning.addWarning((String)"Field [{}] cannot be retrieved, it is unsupported or not indexed; returning null", (Object[])new Object[]{fieldName});
                loaders.add(BlockLoader.CONSTANT_NULLS);
                continue;
            }
            loaders.add(loader);
        }
        return loaders;
    }
}

