/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.data;

import java.io.IOException;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.BlockFactory;
import org.elasticsearch.compute.data.BlockStreamInput;
import org.elasticsearch.compute.data.BytesRefVector;
import org.elasticsearch.index.mapper.BlockLoader;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public interface BytesRefBlock
extends Block {
    public static final BytesRef NULL_VALUE = new BytesRef();
    public static final NamedWriteableRegistry.Entry ENTRY = new NamedWriteableRegistry.Entry(Block.class, "BytesRefBlock", BytesRefBlock::readFrom);

    public BytesRef getBytesRef(int var1, BytesRef var2);

    @Override
    public BytesRefVector asVector();

    @Override
    public BytesRefBlock filter(int ... var1);

    default public String getWriteableName() {
        return "BytesRefBlock";
    }

    private static BytesRefBlock readFrom(StreamInput in) throws IOException {
        return BytesRefBlock.readFrom((BlockStreamInput)in);
    }

    private static BytesRefBlock readFrom(BlockStreamInput in) throws IOException {
        boolean isVector = in.readBoolean();
        if (isVector) {
            return BytesRefVector.readFrom(in.blockFactory(), (StreamInput)in).asBlock();
        }
        int positions = in.readVInt();
        try (Builder builder = in.blockFactory().newBytesRefBlockBuilder(positions);){
            for (int i = 0; i < positions; ++i) {
                if (in.readBoolean()) {
                    builder.appendNull();
                    continue;
                }
                int valueCount = in.readVInt();
                builder.beginPositionEntry();
                for (int valueIndex = 0; valueIndex < valueCount; ++valueIndex) {
                    builder.appendBytesRef(in.readBytesRef());
                }
                builder.endPositionEntry();
            }
            BytesRefBlock bytesRefBlock = builder.build();
            return bytesRefBlock;
        }
    }

    default public void writeTo(StreamOutput out) throws IOException {
        BytesRefVector vector = this.asVector();
        out.writeBoolean(vector != null);
        if (vector != null) {
            vector.writeTo(out);
        } else {
            int positions = this.getPositionCount();
            out.writeVInt(positions);
            for (int pos = 0; pos < positions; ++pos) {
                if (this.isNull(pos)) {
                    out.writeBoolean(true);
                    continue;
                }
                out.writeBoolean(false);
                int valueCount = this.getValueCount(pos);
                out.writeVInt(valueCount);
                for (int valueIndex = 0; valueIndex < valueCount; ++valueIndex) {
                    out.writeBytesRef(this.getBytesRef(this.getFirstValueIndex(pos) + valueIndex, new BytesRef()));
                }
            }
        }
    }

    public boolean equals(Object var1);

    public int hashCode();

    public static boolean equals(BytesRefBlock block1, BytesRefBlock block2) {
        if (block1 == block2) {
            return true;
        }
        int positions = block1.getPositionCount();
        if (positions != block2.getPositionCount()) {
            return false;
        }
        for (int pos = 0; pos < positions; ++pos) {
            if (block1.isNull(pos) || block2.isNull(pos)) {
                if (block1.isNull(pos) == block2.isNull(pos)) continue;
                return false;
            }
            int valueCount = block1.getValueCount(pos);
            if (valueCount != block2.getValueCount(pos)) {
                return false;
            }
            int b1ValueIdx = block1.getFirstValueIndex(pos);
            int b2ValueIdx = block2.getFirstValueIndex(pos);
            for (int valueIndex = 0; valueIndex < valueCount; ++valueIndex) {
                if (block1.getBytesRef(b1ValueIdx + valueIndex, new BytesRef()).equals((Object)block2.getBytesRef(b2ValueIdx + valueIndex, new BytesRef()))) continue;
                return false;
            }
        }
        return true;
    }

    public static int hash(BytesRefBlock block) {
        int positions = block.getPositionCount();
        int result = 1;
        for (int pos = 0; pos < positions; ++pos) {
            if (block.isNull(pos)) {
                result = 31 * result - 1;
                continue;
            }
            int valueCount = block.getValueCount(pos);
            result = 31 * result + valueCount;
            int firstValueIdx = block.getFirstValueIndex(pos);
            for (int valueIndex = 0; valueIndex < valueCount; ++valueIndex) {
                result = 31 * result + block.getBytesRef(firstValueIdx + valueIndex, new BytesRef()).hashCode();
            }
        }
        return result;
    }

    @Deprecated
    public static Builder newBlockBuilder(int estimatedSize) {
        return BytesRefBlock.newBlockBuilder(estimatedSize, BlockFactory.getNonBreakingInstance());
    }

    @Deprecated
    public static Builder newBlockBuilder(int estimatedSize, BlockFactory blockFactory) {
        return blockFactory.newBytesRefBlockBuilder(estimatedSize);
    }

    @Deprecated
    public static BytesRefBlock newConstantBlockWith(BytesRef value, int positions) {
        return BytesRefBlock.newConstantBlockWith(value, positions, BlockFactory.getNonBreakingInstance());
    }

    @Deprecated
    public static BytesRefBlock newConstantBlockWith(BytesRef value, int positions, BlockFactory blockFactory) {
        return blockFactory.newConstantBytesRefBlockWith(value, positions);
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static interface Builder
    extends Block.Builder,
    BlockLoader.BytesRefBuilder {
        public Builder appendBytesRef(BytesRef var1);

        public Builder copyFrom(BytesRefBlock var1, int var2, int var3);

        @Override
        public Builder appendNull();

        @Override
        public Builder beginPositionEntry();

        @Override
        public Builder endPositionEntry();

        @Override
        public Builder copyFrom(Block var1, int var2, int var3);

        @Override
        public Builder mvOrdering(Block.MvOrdering var1);

        @Override
        public Builder appendAllValuesToCurrentPosition(Block var1);

        public Builder appendAllValuesToCurrentPosition(BytesRefBlock var1);

        @Override
        public BytesRefBlock build();
    }
}

