/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.data;

import java.util.Arrays;
import org.apache.lucene.util.RamUsageEstimator;
import org.elasticsearch.compute.data.AbstractVector;
import org.elasticsearch.compute.data.BlockFactory;
import org.elasticsearch.compute.data.BooleanBlock;
import org.elasticsearch.compute.data.BooleanVector;
import org.elasticsearch.compute.data.BooleanVectorBlock;
import org.elasticsearch.compute.data.ElementType;

public final class BooleanArrayVector
extends AbstractVector
implements BooleanVector {
    static final long BASE_RAM_BYTES_USED = RamUsageEstimator.shallowSizeOfInstance(BooleanArrayVector.class);
    private final boolean[] values;
    private final BooleanBlock block;

    public BooleanArrayVector(boolean[] values, int positionCount) {
        this(values, positionCount, BlockFactory.getNonBreakingInstance());
    }

    public BooleanArrayVector(boolean[] values, int positionCount, BlockFactory blockFactory) {
        super(positionCount, blockFactory);
        this.values = values;
        this.block = new BooleanVectorBlock(this);
    }

    @Override
    public BooleanBlock asBlock() {
        return this.block;
    }

    @Override
    public boolean getBoolean(int position) {
        return this.values[position];
    }

    @Override
    public ElementType elementType() {
        return ElementType.BOOLEAN;
    }

    @Override
    public boolean isConstant() {
        return false;
    }

    @Override
    public BooleanVector filter(int ... positions) {
        try (BooleanVector.Builder builder = this.blockFactory().newBooleanVectorBuilder(positions.length);){
            for (int pos : positions) {
                builder.appendBoolean(this.values[pos]);
            }
            BooleanVector booleanVector = builder.build();
            return booleanVector;
        }
    }

    public static long ramBytesEstimated(boolean[] values) {
        return BASE_RAM_BYTES_USED + RamUsageEstimator.sizeOf((boolean[])values);
    }

    public long ramBytesUsed() {
        return BooleanArrayVector.ramBytesEstimated(this.values);
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof BooleanVector) {
            BooleanVector that = (BooleanVector)obj;
            return BooleanVector.equals(this, that);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return BooleanVector.hash(this);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[positions=" + this.getPositionCount() + ", values=" + Arrays.toString(this.values) + "]";
    }
}

