/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.server.cli;

import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.concurrent.EsExecutors;

final class SystemJvmOptions {
    SystemJvmOptions() {
    }

    static List<String> systemJvmOptions(Settings nodeSettings) {
        return Stream.of("-Des.networkaddress.cache.ttl=60", "-Des.networkaddress.cache.negative.ttl=10", "-Djava.security.manager=allow", "-XX:+AlwaysPreTouch", "-Xss1m", "-Djava.awt.headless=true", "-Dfile.encoding=UTF-8", "-Djna.nosys=true", "-XX:-OmitStackTraceInFastThrow", "-Dio.netty.noUnsafe=true", "-Dio.netty.noKeySetOptimization=true", "-Dio.netty.recycler.maxCapacityPerThread=0", "-Dlog4j.shutdownHookEnabled=false", "-Dlog4j2.disable.jmx=true", "-Dlog4j2.formatMsgNoLookups=true", "-Djava.locale.providers=SPI,COMPAT", "--add-opens=java.base/java.io=org.elasticsearch.preallocate", SystemJvmOptions.maybeOverrideDockerCgroup(), SystemJvmOptions.maybeSetActiveProcessorCount(nodeSettings)).filter(e -> !e.isEmpty()).collect(Collectors.toList());
    }

    private static String maybeOverrideDockerCgroup() {
        if ("docker".equals(System.getProperty("es.distribution.type"))) {
            return "-Des.cgroups.hierarchy.override=/";
        }
        return "";
    }

    private static String maybeSetActiveProcessorCount(Settings nodeSettings) {
        if (EsExecutors.NODE_PROCESSORS_SETTING.exists(nodeSettings)) {
            int allocated = EsExecutors.allocatedProcessors((Settings)nodeSettings);
            return "-XX:ActiveProcessorCount=" + allocated;
        }
        return "";
    }
}

