/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.operator.topn;

import org.elasticsearch.compute.data.BooleanBlock;
import org.elasticsearch.compute.data.BooleanVector;
import org.elasticsearch.compute.operator.BreakingBytesRefBuilder;
import org.elasticsearch.compute.operator.topn.KeyExtractor;
import org.elasticsearch.compute.operator.topn.TopNEncoder;

abstract class KeyExtractorForBoolean
implements KeyExtractor {
    private final byte nul;
    private final byte nonNul;

    static KeyExtractorForBoolean extractorFor(TopNEncoder encoder, boolean ascending, byte nul, byte nonNul, BooleanBlock block) {
        BooleanVector v = block.asVector();
        if (v != null) {
            return new ForVector(encoder, nul, nonNul, v);
        }
        if (ascending) {
            return block.mvSortedAscending() ? new MinForAscending(encoder, nul, nonNul, block) : new MinForUnordered(encoder, nul, nonNul, block);
        }
        return block.mvSortedAscending() ? new MaxForAscending(encoder, nul, nonNul, block) : new MaxForUnordered(encoder, nul, nonNul, block);
    }

    KeyExtractorForBoolean(TopNEncoder encoder, byte nul, byte nonNul) {
        assert (encoder == TopNEncoder.DEFAULT_SORTABLE);
        this.nul = nul;
        this.nonNul = nonNul;
    }

    protected final int nonNul(BreakingBytesRefBuilder key, boolean value) {
        key.append(this.nonNul);
        TopNEncoder.DEFAULT_SORTABLE.encodeBoolean(value, key);
        return 2;
    }

    protected final int nul(BreakingBytesRefBuilder key) {
        key.append(this.nul);
        return 1;
    }

    static class ForVector
    extends KeyExtractorForBoolean {
        private final BooleanVector vector;

        ForVector(TopNEncoder encoder, byte nul, byte nonNul, BooleanVector vector) {
            super(encoder, nul, nonNul);
            this.vector = vector;
        }

        @Override
        public int writeKey(BreakingBytesRefBuilder key, int position) {
            return this.nonNul(key, this.vector.getBoolean(position));
        }
    }

    static class MinForAscending
    extends KeyExtractorForBoolean {
        private final BooleanBlock block;

        MinForAscending(TopNEncoder encoder, byte nul, byte nonNul, BooleanBlock block) {
            super(encoder, nul, nonNul);
            this.block = block;
        }

        @Override
        public int writeKey(BreakingBytesRefBuilder key, int position) {
            if (this.block.isNull(position)) {
                return this.nul(key);
            }
            return this.nonNul(key, this.block.getBoolean(this.block.getFirstValueIndex(position)));
        }
    }

    static class MinForUnordered
    extends KeyExtractorForBoolean {
        private final BooleanBlock block;

        MinForUnordered(TopNEncoder encoder, byte nul, byte nonNul, BooleanBlock block) {
            super(encoder, nul, nonNul);
            this.block = block;
        }

        @Override
        public int writeKey(BreakingBytesRefBuilder key, int position) {
            int size = this.block.getValueCount(position);
            if (size == 0) {
                return this.nul(key);
            }
            int start = this.block.getFirstValueIndex(position);
            int end = start + size;
            for (int i = start; i < end; ++i) {
                if (this.block.getBoolean(i)) continue;
                return this.nonNul(key, false);
            }
            return this.nonNul(key, true);
        }
    }

    static class MaxForAscending
    extends KeyExtractorForBoolean {
        private final BooleanBlock block;

        MaxForAscending(TopNEncoder encoder, byte nul, byte nonNul, BooleanBlock block) {
            super(encoder, nul, nonNul);
            this.block = block;
        }

        @Override
        public int writeKey(BreakingBytesRefBuilder key, int position) {
            if (this.block.isNull(position)) {
                return this.nul(key);
            }
            return this.nonNul(key, this.block.getBoolean(this.block.getFirstValueIndex(position) + this.block.getValueCount(position) - 1));
        }
    }

    static class MaxForUnordered
    extends KeyExtractorForBoolean {
        private final BooleanBlock block;

        MaxForUnordered(TopNEncoder encoder, byte nul, byte nonNul, BooleanBlock block) {
            super(encoder, nul, nonNul);
            this.block = block;
        }

        @Override
        public int writeKey(BreakingBytesRefBuilder key, int position) {
            int size = this.block.getValueCount(position);
            if (size == 0) {
                return this.nul(key);
            }
            int start = this.block.getFirstValueIndex(position);
            int end = start + size;
            for (int i = start; i < end; ++i) {
                if (!this.block.getBoolean(i)) continue;
                return this.nonNul(key, true);
            }
            return this.nonNul(key, false);
        }
    }
}

