/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.operator.exchange;

import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.SubscribableListener;
import org.elasticsearch.common.util.concurrent.AbstractRunnable;
import org.elasticsearch.compute.data.Page;
import org.elasticsearch.compute.operator.exchange.ExchangeBuffer;
import org.elasticsearch.compute.operator.exchange.ExchangeResponse;
import org.elasticsearch.compute.operator.exchange.ExchangeSource;
import org.elasticsearch.compute.operator.exchange.RemoteSink;
import org.elasticsearch.core.AbstractRefCounted;
import org.elasticsearch.tasks.TaskCancelledException;

public final class ExchangeSourceHandler
extends AbstractRefCounted {
    private final ExchangeBuffer buffer;
    private final Executor fetchExecutor;
    private final PendingInstances outstandingSinks = new PendingInstances();
    private final PendingInstances outstandingSources = new PendingInstances();
    private final AtomicReference<Exception> failure = new AtomicReference();
    private final SubscribableListener<Void> completionFuture = new SubscribableListener();

    public ExchangeSourceHandler(int maxBufferSize, Executor fetchExecutor) {
        this.buffer = new ExchangeBuffer(maxBufferSize);
        this.fetchExecutor = fetchExecutor;
    }

    public ExchangeSource createExchangeSource() {
        return new LocalExchangeSource();
    }

    public void addRemoteSink(RemoteSink remoteSink, int instances) {
        for (int i = 0; i < instances; ++i) {
            final RemoteSinkFetcher fetcher = new RemoteSinkFetcher(remoteSink);
            this.fetchExecutor.execute((Runnable)new AbstractRunnable(){

                public void onFailure(Exception e) {
                    fetcher.onSinkFailed(e);
                }

                protected void doRun() {
                    fetcher.fetchPage();
                }
            });
        }
    }

    protected void closeInternal() {
        Exception error = this.failure.get();
        if (error != null) {
            this.completionFuture.onFailure(error);
        } else {
            this.completionFuture.onResponse(null);
        }
    }

    public void addCompletionListener(ActionListener<Void> listener) {
        this.completionFuture.addListener(listener);
    }

    private final class PendingInstances {
        private final AtomicInteger instances = new AtomicInteger();

        private PendingInstances() {
        }

        void trackNewInstance() {
            ExchangeSourceHandler.this.incRef();
            this.instances.incrementAndGet();
        }

        boolean finishInstance() {
            ExchangeSourceHandler.this.decRef();
            return this.instances.decrementAndGet() == 0;
        }
    }

    private class LocalExchangeSource
    implements ExchangeSource {
        private boolean finished;

        LocalExchangeSource() {
            ExchangeSourceHandler.this.outstandingSources.trackNewInstance();
        }

        private void checkFailure() {
            Exception e = ExchangeSourceHandler.this.failure.get();
            if (e != null) {
                throw ExceptionsHelper.convertToElastic((Exception)e);
            }
        }

        @Override
        public Page pollPage() {
            this.checkFailure();
            return ExchangeSourceHandler.this.buffer.pollPage();
        }

        @Override
        public boolean isFinished() {
            this.checkFailure();
            return this.finished || ExchangeSourceHandler.this.buffer.isFinished();
        }

        @Override
        public SubscribableListener<Void> waitForReading() {
            return ExchangeSourceHandler.this.buffer.waitForReading();
        }

        @Override
        public void finish() {
            if (!this.finished) {
                this.finished = true;
                if (ExchangeSourceHandler.this.outstandingSources.finishInstance()) {
                    ExchangeSourceHandler.this.buffer.finish(true);
                }
            }
        }

        @Override
        public int bufferSize() {
            return ExchangeSourceHandler.this.buffer.size();
        }
    }

    private final class RemoteSinkFetcher {
        private volatile boolean finished = false;
        private final RemoteSink remoteSink;

        RemoteSinkFetcher(RemoteSink remoteSink) {
            ExchangeSourceHandler.this.outstandingSinks.trackNewInstance();
            this.remoteSink = remoteSink;
        }

        void fetchPage() {
            LoopControl loopControl = new LoopControl();
            while (loopControl.isRunning()) {
                loopControl.exiting();
                boolean toFinishSinks = ExchangeSourceHandler.this.buffer.noMoreInputs() || ExchangeSourceHandler.this.failure.get() != null;
                this.remoteSink.fetchPageAsync(toFinishSinks, (ActionListener<ExchangeResponse>)ActionListener.wrap(resp -> {
                    Page page = resp.takePage();
                    if (page != null) {
                        ExchangeSourceHandler.this.buffer.addPage(page);
                    }
                    if (resp.finished()) {
                        this.onSinkComplete();
                    } else {
                        SubscribableListener<Void> future = ExchangeSourceHandler.this.buffer.waitForWriting();
                        if (future.isDone()) {
                            if (!loopControl.tryResume()) {
                                this.fetchPage();
                            }
                        } else {
                            future.addListener(ActionListener.wrap(unused -> {
                                if (!loopControl.tryResume()) {
                                    this.fetchPage();
                                }
                            }, this::onSinkFailed));
                        }
                    }
                }, this::onSinkFailed));
            }
            loopControl.exited();
        }

        void onSinkFailed(Exception e) {
            ExchangeSourceHandler.this.failure.getAndUpdate(first -> {
                if (first == null) {
                    return e;
                }
                if (ExceptionsHelper.unwrap((Throwable)e, (Class[])new Class[]{TaskCancelledException.class}) != null) {
                    return first;
                }
                if (ExceptionsHelper.unwrap((Throwable)first, (Class[])new Class[]{TaskCancelledException.class}) != null) {
                    return e;
                }
                if (ExceptionsHelper.unwrapCause((Throwable)first) != ExceptionsHelper.unwrapCause((Throwable)e)) {
                    first.addSuppressed(e);
                }
                return first;
            });
            this.onSinkComplete();
        }

        void onSinkComplete() {
            if (!this.finished) {
                this.finished = true;
                if (ExchangeSourceHandler.this.outstandingSinks.finishInstance()) {
                    ExchangeSourceHandler.this.buffer.finish(false);
                }
            }
        }
    }

    private static class LoopControl {
        private final Thread startedThread;
        private Status status = Status.RUNNING;

        LoopControl() {
            this.startedThread = Thread.currentThread();
        }

        boolean isRunning() {
            return this.status == Status.RUNNING;
        }

        boolean tryResume() {
            if (this.startedThread == Thread.currentThread() && this.status != Status.EXITED) {
                this.status = Status.RUNNING;
                return true;
            }
            return false;
        }

        void exiting() {
            this.status = Status.EXITING;
        }

        void exited() {
            this.status = Status.EXITED;
        }

        static enum Status {
            RUNNING,
            EXITING,
            EXITED;

        }
    }
}

