/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.operator.exchange;

import java.io.IOException;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Supplier;
import org.elasticsearch.action.support.SubscribableListener;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.compute.data.Page;
import org.elasticsearch.compute.operator.DriverContext;
import org.elasticsearch.compute.operator.Operator;
import org.elasticsearch.compute.operator.SinkOperator;
import org.elasticsearch.compute.operator.exchange.ExchangeSink;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;

public class ExchangeSinkOperator
extends SinkOperator {
    private final ExchangeSink sink;
    private final Function<Page, Page> transformer;
    private int pagesAccepted;

    public ExchangeSinkOperator(ExchangeSink sink, Function<Page, Page> transformer) {
        this.sink = sink;
        this.transformer = transformer;
    }

    @Override
    public boolean isFinished() {
        return this.sink.isFinished();
    }

    @Override
    public void finish() {
        this.sink.finish();
    }

    @Override
    public SubscribableListener<Void> isBlocked() {
        return this.sink.waitForWriting();
    }

    @Override
    public boolean needsInput() {
        return !this.isFinished() && this.isBlocked().isDone();
    }

    @Override
    protected void doAddInput(Page page) {
        ++this.pagesAccepted;
        this.sink.addPage(this.transformer.apply(page));
    }

    @Override
    public void close() {
        this.finish();
    }

    public String toString() {
        return "ExchangeSinkOperator";
    }

    @Override
    public Status status() {
        return new Status(this.pagesAccepted);
    }

    public static class Status
    implements Operator.Status {
        public static final NamedWriteableRegistry.Entry ENTRY = new NamedWriteableRegistry.Entry(Operator.Status.class, "exchange_sink", Status::new);
        private final int pagesAccepted;

        Status(int pagesAccepted) {
            this.pagesAccepted = pagesAccepted;
        }

        Status(StreamInput in) throws IOException {
            this.pagesAccepted = in.readVInt();
        }

        public void writeTo(StreamOutput out) throws IOException {
            out.writeVInt(this.pagesAccepted);
        }

        public String getWriteableName() {
            return Status.ENTRY.name;
        }

        public int pagesAccepted() {
            return this.pagesAccepted;
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.field("pages_accepted", this.pagesAccepted);
            return builder.endObject();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Status status = (Status)o;
            return this.pagesAccepted == status.pagesAccepted;
        }

        public int hashCode() {
            return Objects.hash(this.pagesAccepted);
        }

        public String toString() {
            return Strings.toString((ToXContent)this);
        }
    }

    public record ExchangeSinkOperatorFactory(Supplier<ExchangeSink> exchangeSinks, Function<Page, Page> transformer) implements SinkOperator.SinkOperatorFactory
    {
        @Override
        public SinkOperator get(DriverContext driverContext) {
            return new ExchangeSinkOperator(this.exchangeSinks.get(), this.transformer);
        }

        @Override
        public String describe() {
            return "ExchangeSinkOperator";
        }
    }
}

