/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.operator;

import java.util.Arrays;
import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.RamUsageEstimator;
import org.elasticsearch.common.util.BytesRefHash;
import org.elasticsearch.compute.aggregation.blockhash.BlockHash;
import org.elasticsearch.compute.data.BlockFactory;
import org.elasticsearch.compute.data.BytesRefBlock;
import org.elasticsearch.compute.data.IntBlock;
import org.elasticsearch.compute.operator.BatchEncoder;
import org.elasticsearch.compute.operator.MultivalueDedupe;

public class MultivalueDedupeBytesRef {
    private static final int ALWAYS_COPY_MISSING = 20;
    private final BytesRefBlock block;
    private BytesRef[] work = new BytesRef[ArrayUtil.oversize((int)2, (int)RamUsageEstimator.NUM_BYTES_OBJECT_REF)];
    private int w;

    public MultivalueDedupeBytesRef(BytesRefBlock block) {
        this.block = block;
        this.fillWork(0, this.work.length);
    }

    public BytesRefBlock dedupeToBlockAdaptive(BlockFactory blockFactory) {
        if (this.block.mvDeduplicated()) {
            this.block.incRef();
            return this.block;
        }
        try (BytesRefBlock.Builder builder = BytesRefBlock.newBlockBuilder(this.block.getPositionCount(), blockFactory);){
            block9: for (int p = 0; p < this.block.getPositionCount(); ++p) {
                int count = this.block.getValueCount(p);
                int first = this.block.getFirstValueIndex(p);
                switch (count) {
                    case 0: {
                        builder.appendNull();
                        continue block9;
                    }
                    case 1: {
                        builder.appendBytesRef(this.block.getBytesRef(first, this.work[0]));
                        continue block9;
                    }
                    default: {
                        if (count < 20) {
                            this.copyMissing(first, count);
                            this.writeUniquedWork(builder);
                            continue block9;
                        }
                        this.copyAndSort(first, count);
                        this.writeSortedWork(builder);
                    }
                }
            }
            BytesRefBlock bytesRefBlock = builder.build();
            return bytesRefBlock;
        }
    }

    public BytesRefBlock dedupeToBlockUsingCopyAndSort(BlockFactory blockFactory) {
        if (this.block.mvDeduplicated()) {
            this.block.incRef();
            return this.block;
        }
        try (BytesRefBlock.Builder builder = BytesRefBlock.newBlockBuilder(this.block.getPositionCount(), blockFactory);){
            block9: for (int p = 0; p < this.block.getPositionCount(); ++p) {
                int count = this.block.getValueCount(p);
                int first = this.block.getFirstValueIndex(p);
                switch (count) {
                    case 0: {
                        builder.appendNull();
                        continue block9;
                    }
                    case 1: {
                        builder.appendBytesRef(this.block.getBytesRef(first, this.work[0]));
                        continue block9;
                    }
                    default: {
                        this.copyAndSort(first, count);
                        this.writeSortedWork(builder);
                    }
                }
            }
            BytesRefBlock bytesRefBlock = builder.build();
            return bytesRefBlock;
        }
    }

    public BytesRefBlock dedupeToBlockUsingCopyMissing(BlockFactory blockFactory) {
        if (this.block.mvDeduplicated()) {
            this.block.incRef();
            return this.block;
        }
        try (BytesRefBlock.Builder builder = BytesRefBlock.newBlockBuilder(this.block.getPositionCount(), blockFactory);){
            block9: for (int p = 0; p < this.block.getPositionCount(); ++p) {
                int count = this.block.getValueCount(p);
                int first = this.block.getFirstValueIndex(p);
                switch (count) {
                    case 0: {
                        builder.appendNull();
                        continue block9;
                    }
                    case 1: {
                        builder.appendBytesRef(this.block.getBytesRef(first, this.work[0]));
                        continue block9;
                    }
                    default: {
                        this.copyMissing(first, count);
                        this.writeUniquedWork(builder);
                    }
                }
            }
            BytesRefBlock bytesRefBlock = builder.build();
            return bytesRefBlock;
        }
    }

    public MultivalueDedupe.HashResult hash(BlockFactory blockFactory, BytesRefHash hash) {
        try (IntBlock.Builder builder = blockFactory.newIntBlockBuilder(this.block.getPositionCount());){
            boolean sawNull = false;
            block9: for (int p = 0; p < this.block.getPositionCount(); ++p) {
                int count = this.block.getValueCount(p);
                int first = this.block.getFirstValueIndex(p);
                switch (count) {
                    case 0: {
                        sawNull = true;
                        builder.appendInt(0);
                        continue block9;
                    }
                    case 1: {
                        BytesRef v = this.block.getBytesRef(first, this.work[0]);
                        this.hash(builder, hash, v);
                        continue block9;
                    }
                    default: {
                        if (count < 20) {
                            this.copyMissing(first, count);
                            this.hashUniquedWork(hash, builder);
                            continue block9;
                        }
                        this.copyAndSort(first, count);
                        this.hashSortedWork(hash, builder);
                    }
                }
            }
            MultivalueDedupe.HashResult hashResult = new MultivalueDedupe.HashResult(builder.build(), sawNull);
            return hashResult;
        }
    }

    public BatchEncoder batchEncoder(int batchSize) {
        return new BatchEncoder.BytesRefs(batchSize){

            @Override
            protected void readNextBatch() {
                int position = this.firstPosition();
                if (MultivalueDedupeBytesRef.this.w > 0) {
                    this.ensureCapacity(this.workSize(), MultivalueDedupeBytesRef.this.w);
                    this.startPosition();
                    MultivalueDedupeBytesRef.this.encodeUniquedWork(this);
                    this.endPosition();
                    ++position;
                }
                while (position < MultivalueDedupeBytesRef.this.block.getPositionCount()) {
                    int count = MultivalueDedupeBytesRef.this.block.getValueCount(position);
                    int first = MultivalueDedupeBytesRef.this.block.getFirstValueIndex(position);
                    switch (count) {
                        case 0: {
                            this.encodeNull();
                            break;
                        }
                        case 1: {
                            BytesRef v = MultivalueDedupeBytesRef.this.block.getBytesRef(first, MultivalueDedupeBytesRef.this.work[0]);
                            if (this.hasCapacity(v.length, 1)) {
                                this.startPosition();
                                this.encode(v);
                                this.endPosition();
                                break;
                            }
                            MultivalueDedupeBytesRef.this.work[0] = v;
                            MultivalueDedupeBytesRef.this.w = 1;
                            return;
                        }
                        default: {
                            if (count < 20) {
                                MultivalueDedupeBytesRef.this.copyMissing(first, count);
                            } else {
                                MultivalueDedupeBytesRef.this.copyAndSort(first, count);
                                MultivalueDedupeBytesRef.this.convertSortedWorkToUnique();
                            }
                            if (this.hasCapacity(this.workSize(), MultivalueDedupeBytesRef.this.w)) {
                                this.startPosition();
                                MultivalueDedupeBytesRef.this.encodeUniquedWork(this);
                                this.endPosition();
                                break;
                            }
                            return;
                        }
                    }
                    ++position;
                }
            }

            private int workSize() {
                int size = 0;
                for (int i = 0; i < MultivalueDedupeBytesRef.this.w; ++i) {
                    size += MultivalueDedupeBytesRef.this.work[i].length;
                }
                return size;
            }
        };
    }

    private void copyAndSort(int first, int count) {
        this.grow(count);
        int end = first + count;
        this.w = 0;
        for (int i = first; i < end; ++i) {
            this.work[this.w] = this.block.getBytesRef(i, this.work[this.w]);
            ++this.w;
        }
        Arrays.sort(this.work, 0, this.w);
    }

    private void copyMissing(int first, int count) {
        this.grow(count);
        int end = first + count;
        this.work[0] = this.block.getBytesRef(first, this.work[0]);
        this.w = 1;
        block0: for (int i = first + 1; i < end; ++i) {
            BytesRef v = this.block.getBytesRef(i, this.work[this.w]);
            for (int j = 0; j < this.w; ++j) {
                if (v.equals((Object)this.work[j])) continue block0;
            }
            this.work[this.w++] = v;
        }
    }

    private void writeUniquedWork(BytesRefBlock.Builder builder) {
        if (this.w == 1) {
            builder.appendBytesRef(this.work[0]);
            return;
        }
        builder.beginPositionEntry();
        for (int i = 0; i < this.w; ++i) {
            builder.appendBytesRef(this.work[i]);
        }
        builder.endPositionEntry();
    }

    private void writeSortedWork(BytesRefBlock.Builder builder) {
        if (this.w == 1) {
            builder.appendBytesRef(this.work[0]);
            return;
        }
        builder.beginPositionEntry();
        BytesRef prev = this.work[0];
        builder.appendBytesRef(prev);
        for (int i = 1; i < this.w; ++i) {
            if (prev.equals((Object)this.work[i])) continue;
            prev = this.work[i];
            builder.appendBytesRef(prev);
        }
        builder.endPositionEntry();
    }

    private void hashUniquedWork(BytesRefHash hash, IntBlock.Builder builder) {
        if (this.w == 1) {
            this.hash(builder, hash, this.work[0]);
            return;
        }
        builder.beginPositionEntry();
        for (int i = 0; i < this.w; ++i) {
            this.hash(builder, hash, this.work[i]);
        }
        builder.endPositionEntry();
    }

    private void hashSortedWork(BytesRefHash hash, IntBlock.Builder builder) {
        if (this.w == 1) {
            this.hash(builder, hash, this.work[0]);
            return;
        }
        builder.beginPositionEntry();
        BytesRef prev = this.work[0];
        this.hash(builder, hash, prev);
        for (int i = 1; i < this.w; ++i) {
            if (prev.equals((Object)this.work[i])) continue;
            prev = this.work[i];
            this.hash(builder, hash, prev);
        }
        builder.endPositionEntry();
    }

    private void encodeUniquedWork(BatchEncoder.BytesRefs encoder) {
        for (int i = 0; i < this.w; ++i) {
            encoder.encode(this.work[i]);
        }
    }

    private void convertSortedWorkToUnique() {
        BytesRef prev = this.work[0];
        int end = this.w;
        this.w = 1;
        for (int i = 1; i < end; ++i) {
            if (prev.equals((Object)this.work[i])) continue;
            prev = this.work[i];
            this.work[this.w].bytes = prev.bytes;
            this.work[this.w].offset = prev.offset;
            this.work[this.w].length = prev.length;
            ++this.w;
        }
    }

    private void grow(int size) {
        int prev = this.work.length;
        this.work = (BytesRef[])ArrayUtil.grow((Object[])this.work, (int)size);
        this.fillWork(prev, this.work.length);
    }

    private void fillWork(int from, int to) {
        for (int i = from; i < to; ++i) {
            this.work[i] = new BytesRef();
        }
    }

    private void hash(IntBlock.Builder builder, BytesRefHash hash, BytesRef v) {
        builder.appendInt(Math.toIntExact(BlockHash.hashOrdToGroupNullReserved(hash.add(v))));
    }
}

