/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.operator;

import java.io.IOException;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.VersionId;
import org.elasticsearch.common.io.stream.NamedWriteable;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.compute.operator.Operator;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.index.mapper.DateFieldMapper;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentFragment;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;

public class DriverStatus
implements Task.Status {
    public static final NamedWriteableRegistry.Entry ENTRY = new NamedWriteableRegistry.Entry(Task.Status.class, "driver", DriverStatus::new);
    private final String sessionId;
    private final long lastUpdated;
    private final Status status;
    private final List<OperatorStatus> completedOperators;
    private final List<OperatorStatus> activeOperators;

    DriverStatus(String sessionId, long lastUpdated, Status status, List<OperatorStatus> completedOperators, List<OperatorStatus> activeOperators) {
        this.sessionId = sessionId;
        this.lastUpdated = lastUpdated;
        this.status = status;
        this.completedOperators = completedOperators;
        this.activeOperators = activeOperators;
    }

    public DriverStatus(StreamInput in) throws IOException {
        this.sessionId = in.readString();
        this.lastUpdated = in.readLong();
        this.status = Status.valueOf(in.readString());
        this.completedOperators = in.getTransportVersion().onOrAfter((VersionId)TransportVersions.ESQL_PROFILE) ? in.readCollectionAsImmutableList(OperatorStatus::new) : List.of();
        this.activeOperators = in.readCollectionAsImmutableList(OperatorStatus::new);
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.sessionId);
        out.writeLong(this.lastUpdated);
        out.writeString(this.status.toString());
        if (out.getTransportVersion().onOrAfter((VersionId)TransportVersions.ESQL_PROFILE)) {
            out.writeCollection(this.completedOperators);
        }
        out.writeCollection(this.activeOperators);
    }

    public String getWriteableName() {
        return DriverStatus.ENTRY.name;
    }

    public String sessionId() {
        return this.sessionId;
    }

    public long lastUpdated() {
        return this.lastUpdated;
    }

    public Status status() {
        return this.status;
    }

    public List<OperatorStatus> completedOperators() {
        return this.completedOperators;
    }

    public List<OperatorStatus> activeOperators() {
        return this.activeOperators;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field("sessionId", this.sessionId);
        builder.field("last_updated", DateFieldMapper.DEFAULT_DATE_TIME_FORMATTER.formatMillis(this.lastUpdated));
        builder.field("status", this.status.toString().toLowerCase(Locale.ROOT));
        builder.startArray("completed_operators");
        for (OperatorStatus completed : this.completedOperators) {
            builder.value((ToXContent)completed);
        }
        builder.endArray();
        builder.startArray("active_operators");
        for (OperatorStatus active : this.activeOperators) {
            builder.value((ToXContent)active);
        }
        builder.endArray();
        return builder.endObject();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DriverStatus that = (DriverStatus)o;
        return this.sessionId.equals(that.sessionId) && this.lastUpdated == that.lastUpdated && this.status == that.status && this.completedOperators.equals(that.completedOperators) && this.activeOperators.equals(that.activeOperators);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.sessionId, this.lastUpdated, this.status, this.completedOperators, this.activeOperators});
    }

    public String toString() {
        return Strings.toString((ToXContent)this);
    }

    public static enum Status implements ToXContentFragment
    {
        QUEUED,
        STARTING,
        RUNNING,
        ASYNC,
        WAITING,
        DONE;


        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            return builder.value(this.toString().toLowerCase(Locale.ROOT));
        }
    }

    public static class OperatorStatus
    implements Writeable,
    ToXContentObject {
        private final String operator;
        @Nullable
        private final Operator.Status status;

        public OperatorStatus(String operator, Operator.Status status) {
            this.operator = operator;
            this.status = status;
        }

        OperatorStatus(StreamInput in) throws IOException {
            this.operator = in.readString();
            this.status = (Operator.Status)in.readOptionalNamedWriteable(Operator.Status.class);
        }

        public void writeTo(StreamOutput out) throws IOException {
            out.writeString(this.operator);
            out.writeOptionalNamedWriteable((NamedWriteable)this.status);
        }

        public String operator() {
            return this.operator;
        }

        public Operator.Status status() {
            return this.status;
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.field("operator", this.operator);
            if (this.status != null) {
                builder.field("status", (ToXContent)this.status);
            }
            return builder.endObject();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            OperatorStatus that = (OperatorStatus)o;
            return this.operator.equals(that.operator) && Objects.equals(this.status, that.status);
        }

        public int hashCode() {
            return Objects.hash(this.operator, this.status);
        }

        public String toString() {
            return Strings.toString((ToXContent)this);
        }
    }
}

