/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.operator;

import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.elasticsearch.compute.Describable;
import org.elasticsearch.compute.aggregation.Aggregator;
import org.elasticsearch.compute.aggregation.AggregatorMode;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.Page;
import org.elasticsearch.compute.operator.DriverContext;
import org.elasticsearch.compute.operator.Operator;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;

public class AggregationOperator
implements Operator {
    private boolean finished;
    private Page output;
    private final List<Aggregator> aggregators;
    private final DriverContext driverContext;

    public AggregationOperator(List<Aggregator> aggregators, DriverContext driverContext) {
        Objects.requireNonNull(aggregators);
        AggregationOperator.checkNonEmpty(aggregators);
        this.aggregators = aggregators;
        this.driverContext = driverContext;
    }

    @Override
    public boolean needsInput() {
        return !this.finished;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addInput(Page page) {
        AggregationOperator.checkState(this.needsInput(), "Operator is already finishing");
        Objects.requireNonNull(page, "page is null");
        try {
            for (Aggregator aggregator : this.aggregators) {
                aggregator.processPage(page);
            }
        }
        finally {
            page.releaseBlocks();
        }
    }

    @Override
    public Page getOutput() {
        Page p = this.output;
        this.output = null;
        return p;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void finish() {
        if (this.finished) {
            return;
        }
        this.finished = true;
        Releasable[] blocks = null;
        boolean success = false;
        try {
            int[] aggBlockCounts = this.aggregators.stream().mapToInt(Aggregator::evaluateBlockCount).toArray();
            blocks = new Block[Arrays.stream(aggBlockCounts).sum()];
            int offset = 0;
            for (int i = 0; i < this.aggregators.size(); ++i) {
                Aggregator aggregator = this.aggregators.get(i);
                aggregator.evaluate((Block[])blocks, offset, this.driverContext);
                offset += aggBlockCounts[i];
            }
            this.output = new Page((Block[])blocks);
            success = true;
            if (success || blocks == null) return;
        }
        catch (Throwable throwable) {
            if (success || blocks == null) throw throwable;
            Releasables.closeExpectNoException(blocks);
            throw throwable;
        }
        Releasables.closeExpectNoException((Releasable[])blocks);
    }

    @Override
    public boolean isFinished() {
        return this.finished && this.output == null;
    }

    @Override
    public void close() {
        Releasables.closeExpectNoException((Releasable[])new Releasable[]{() -> {
            if (this.output != null) {
                Releasables.closeExpectNoException(() -> this.output.releaseBlocks());
            }
        }, Releasables.wrap(this.aggregators)});
    }

    private static void checkState(boolean condition, String msg) {
        if (!condition) {
            throw new IllegalArgumentException(msg);
        }
    }

    private static void checkNonEmpty(List<?> list) {
        if (list.size() < 1) {
            throw new IllegalArgumentException("empty list");
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName()).append("[");
        sb.append("aggregators=").append(this.aggregators).append("]");
        return sb.toString();
    }

    public record AggregationOperatorFactory(List<Aggregator.Factory> aggregators, AggregatorMode mode) implements Operator.OperatorFactory
    {
        @Override
        public Operator get(DriverContext driverContext) {
            return new AggregationOperator(this.aggregators.stream().map(x -> (Aggregator)x.apply(driverContext)).toList(), driverContext);
        }

        @Override
        public String toString() {
            return this.describe();
        }

        @Override
        public String describe() {
            return "AggregationOperator[mode = " + this.mode + ", aggs = " + this.aggregators.stream().map(Describable::describe).collect(Collectors.joining(", ")) + "]";
        }
    }
}

