/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.aggregation.blockhash;

import java.io.IOException;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.common.io.stream.BytesStreamOutput;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.common.util.BitArray;
import org.elasticsearch.common.util.BytesRefArray;
import org.elasticsearch.common.util.BytesRefHash;
import org.elasticsearch.compute.aggregation.GroupingAggregatorFunction;
import org.elasticsearch.compute.aggregation.SeenGroupIds;
import org.elasticsearch.compute.aggregation.blockhash.BlockHash;
import org.elasticsearch.compute.data.BytesRefBlock;
import org.elasticsearch.compute.data.BytesRefVector;
import org.elasticsearch.compute.data.IntBlock;
import org.elasticsearch.compute.data.IntVector;
import org.elasticsearch.compute.data.Page;
import org.elasticsearch.compute.operator.DriverContext;
import org.elasticsearch.compute.operator.MultivalueDedupe;
import org.elasticsearch.compute.operator.MultivalueDedupeBytesRef;

final class BytesRefBlockHash
extends BlockHash {
    private final BytesRef bytes = new BytesRef();
    private final int channel;
    private final BytesRefHash bytesRefHash;
    private boolean seenNull;

    BytesRefBlockHash(int channel, DriverContext driverContext) {
        super(driverContext);
        this.channel = channel;
        this.bytesRefHash = new BytesRefHash(1L, this.bigArrays);
    }

    @Override
    public void add(Page page, GroupingAggregatorFunction.AddInput addInput) {
        Object block = page.getBlock(this.channel);
        if (block.areAllValuesNull()) {
            this.seenNull = true;
            try (IntVector groupIds = this.blockFactory.newConstantIntVector(0, block.getPositionCount());){
                addInput.add(0, groupIds);
            }
        }
        BytesRefBlock bytesBlock = (BytesRefBlock)block;
        BytesRefVector bytesVector = bytesBlock.asVector();
        if (bytesVector == null) {
            try (IntBlock groupIds = this.add(bytesBlock);){
                addInput.add(0, groupIds);
            }
        }
        try (IntVector groupIds = this.add(bytesVector);){
            addInput.add(0, groupIds);
        }
    }

    private IntVector add(BytesRefVector vector) {
        int positions = vector.getPositionCount();
        try (IntVector.FixedBuilder builder = this.blockFactory.newIntVectorFixedBuilder(positions);){
            for (int i = 0; i < positions; ++i) {
                builder.appendInt(Math.toIntExact(BytesRefBlockHash.hashOrdToGroupNullReserved(this.bytesRefHash.add(vector.getBytesRef(i, this.bytes)))));
            }
            IntVector intVector = builder.build();
            return intVector;
        }
    }

    private IntBlock add(BytesRefBlock block) {
        MultivalueDedupe.HashResult result = new MultivalueDedupeBytesRef(block).hash(this.blockFactory, this.bytesRefHash);
        this.seenNull |= result.sawNull();
        return result.ords();
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public BytesRefBlock[] getKeys() {
        if (this.seenNull) {
            try (BytesRefBlock.Builder builder = this.blockFactory.newBytesRefBlockBuilder(Math.toIntExact(this.bytesRefHash.size() + 1L));){
                builder.appendNull();
                BytesRef spare = new BytesRef();
                for (long i = 0L; i < this.bytesRefHash.size(); ++i) {
                    builder.appendBytesRef(this.bytesRefHash.get(i, spare));
                }
                BytesRefBlock[] i = new BytesRefBlock[]{builder.build()};
                return i;
            }
        }
        int size = Math.toIntExact(this.bytesRefHash.size());
        try (BytesStreamOutput out = new BytesStreamOutput();){
            BytesRefBlock[] bytesRefBlockArray;
            block21: {
                this.bytesRefHash.getBytesRefs().writeTo((StreamOutput)out);
                StreamInput in = out.bytes().streamInput();
                try {
                    bytesRefBlockArray = new BytesRefBlock[]{this.blockFactory.newBytesRefArrayVector(new BytesRefArray(in, BigArrays.NON_RECYCLING_INSTANCE), size).asBlock()};
                    if (in == null) break block21;
                }
                catch (Throwable throwable) {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                in.close();
            }
            return bytesRefBlockArray;
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public IntVector nonEmpty() {
        return IntVector.range(this.seenNull ? 0 : 1, Math.toIntExact(this.bytesRefHash.size() + 1L), this.blockFactory);
    }

    @Override
    public BitArray seenGroupIds(BigArrays bigArrays) {
        return new SeenGroupIds.Range(this.seenNull ? 0 : 1, Math.toIntExact(this.bytesRefHash.size() + 1L)).seenGroupIds(bigArrays);
    }

    public void close() {
        this.bytesRefHash.close();
    }

    public String toString() {
        return "BytesRefBlockHash{channel=" + this.channel + ", entries=" + this.bytesRefHash.size() + ", size=" + ByteSizeValue.ofBytes((long)this.bytesRefHash.ramBytesUsed()) + ", seenNull=" + this.seenNull + "}";
    }
}

