/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.aggregation;

import java.util.List;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.compute.aggregation.AggregatorFunctionSupplier;
import org.elasticsearch.compute.aggregation.SumIntAggregatorFunction;
import org.elasticsearch.compute.aggregation.SumIntGroupingAggregatorFunction;
import org.elasticsearch.compute.operator.DriverContext;

public final class SumIntAggregatorFunctionSupplier
implements AggregatorFunctionSupplier {
    private final BigArrays bigArrays;
    private final List<Integer> channels;

    public SumIntAggregatorFunctionSupplier(BigArrays bigArrays, List<Integer> channels) {
        this.bigArrays = bigArrays;
        this.channels = channels;
    }

    @Override
    public SumIntAggregatorFunction aggregator(DriverContext driverContext) {
        return SumIntAggregatorFunction.create(driverContext, this.channels);
    }

    @Override
    public SumIntGroupingAggregatorFunction groupingAggregator(DriverContext driverContext) {
        return SumIntGroupingAggregatorFunction.create(this.channels, driverContext);
    }

    @Override
    public String describe() {
        return "sum of ints";
    }
}

