/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.aggregation;

import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.common.util.DoubleArray;
import org.elasticsearch.compute.aggregation.AbstractArrayState;
import org.elasticsearch.compute.aggregation.GroupingAggregatorState;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.BooleanBlock;
import org.elasticsearch.compute.data.DoubleBlock;
import org.elasticsearch.compute.data.DoubleVector;
import org.elasticsearch.compute.data.IntVector;
import org.elasticsearch.compute.operator.DriverContext;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;

final class DoubleArrayState
extends AbstractArrayState
implements GroupingAggregatorState {
    private final double init;
    private DoubleArray values;

    DoubleArrayState(BigArrays bigArrays, double init) {
        super(bigArrays);
        this.values = bigArrays.newDoubleArray(1L, false);
        this.values.set(0L, init);
        this.init = init;
    }

    double get(int groupId) {
        return this.values.get((long)groupId);
    }

    double getOrDefault(int groupId) {
        return (long)groupId < this.values.size() ? this.values.get((long)groupId) : this.init;
    }

    void set(int groupId, double value) {
        this.ensureCapacity(groupId);
        this.values.set((long)groupId, value);
        this.trackGroupId(groupId);
    }

    Block toValuesBlock(IntVector selected, DriverContext driverContext) {
        if (!this.trackingGroupIds()) {
            try (DoubleVector.Builder builder = DoubleVector.newVectorBuilder(selected.getPositionCount(), driverContext.blockFactory());){
                for (int i = 0; i < selected.getPositionCount(); ++i) {
                    builder.appendDouble(this.values.get((long)selected.getInt(i)));
                }
                DoubleBlock i = builder.build().asBlock();
                return i;
            }
        }
        try (DoubleBlock.Builder builder = DoubleBlock.newBlockBuilder(selected.getPositionCount(), driverContext.blockFactory());){
            for (int i = 0; i < selected.getPositionCount(); ++i) {
                int group = selected.getInt(i);
                if (this.hasValue(group)) {
                    builder.appendDouble(this.values.get((long)group));
                    continue;
                }
                builder.appendNull();
            }
            DoubleBlock doubleBlock = builder.build();
            return doubleBlock;
        }
    }

    private void ensureCapacity(int groupId) {
        if ((long)groupId >= this.values.size()) {
            long prevSize = this.values.size();
            this.values = this.bigArrays.grow(this.values, (long)(groupId + 1));
            this.values.fill(prevSize, this.values.size(), this.init);
        }
    }

    @Override
    public void toIntermediate(Block[] blocks, int offset, IntVector selected, DriverContext driverContext) {
        assert (blocks.length >= offset + 2);
        try (DoubleBlock.Builder valuesBuilder = DoubleBlock.newBlockBuilder(selected.getPositionCount(), driverContext.blockFactory());
             BooleanBlock.Builder hasValueBuilder = BooleanBlock.newBlockBuilder(selected.getPositionCount(), driverContext.blockFactory());){
            for (int i = 0; i < selected.getPositionCount(); ++i) {
                int group = selected.getInt(i);
                if ((long)group < this.values.size()) {
                    valuesBuilder.appendDouble(this.values.get((long)group));
                } else {
                    valuesBuilder.appendDouble(0.0);
                }
                hasValueBuilder.appendBoolean(this.hasValue(group));
            }
            blocks[offset + 0] = valuesBuilder.build();
            blocks[offset + 1] = hasValueBuilder.build();
        }
    }

    @Override
    public void close() {
        Releasables.close((Releasable[])new Releasable[]{this.values, () -> super.close()});
    }
}

