/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ilm.history;

import java.util.List;
import java.util.Map;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.cluster.metadata.ComposableIndexTemplate;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.xcontent.NamedXContentRegistry;
import org.elasticsearch.xpack.core.ilm.LifecyclePolicy;
import org.elasticsearch.xpack.core.ilm.LifecycleSettings;
import org.elasticsearch.xpack.core.template.IndexTemplateConfig;
import org.elasticsearch.xpack.core.template.IndexTemplateRegistry;
import org.elasticsearch.xpack.core.template.LifecyclePolicyConfig;

public class ILMHistoryTemplateRegistry
extends IndexTemplateRegistry {
    public static final int INDEX_TEMPLATE_VERSION = 5;
    public static final String ILM_TEMPLATE_VERSION_VARIABLE = "xpack.ilm_history.template.version";
    public static final String ILM_TEMPLATE_NAME = "ilm-history";
    public static final String ILM_POLICY_NAME = "ilm-history-ilm-policy";
    private final boolean ilmHistoryEnabled;
    private static final Map<String, ComposableIndexTemplate> COMPOSABLE_INDEX_TEMPLATE_CONFIGS = ILMHistoryTemplateRegistry.parseComposableTemplates((IndexTemplateConfig[])new IndexTemplateConfig[]{new IndexTemplateConfig("ilm-history", "/ilm-history.json", 5, "xpack.ilm_history.template.version")});
    private static final LifecyclePolicyConfig LIFECYCLE_POLICY_CONFIG = new LifecyclePolicyConfig("ilm-history-ilm-policy", "/ilm-history-ilm-policy.json");

    protected boolean requiresMasterNode() {
        return true;
    }

    public ILMHistoryTemplateRegistry(Settings nodeSettings, ClusterService clusterService, ThreadPool threadPool, Client client, NamedXContentRegistry xContentRegistry) {
        super(nodeSettings, clusterService, threadPool, client, xContentRegistry);
        this.ilmHistoryEnabled = (Boolean)LifecycleSettings.LIFECYCLE_HISTORY_INDEX_ENABLED_SETTING.get(nodeSettings);
    }

    protected Map<String, ComposableIndexTemplate> getComposableTemplateConfigs() {
        if (this.ilmHistoryEnabled) {
            return COMPOSABLE_INDEX_TEMPLATE_CONFIGS;
        }
        return Map.of();
    }

    protected List<LifecyclePolicyConfig> getLifecycleConfigs() {
        return List.of(LIFECYCLE_POLICY_CONFIG);
    }

    protected List<LifecyclePolicy> getLifecyclePolicies() {
        if (this.ilmHistoryEnabled) {
            return this.lifecyclePolicies;
        }
        return List.of();
    }

    protected String getOrigin() {
        return "index_lifecycle";
    }
}

