/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.analytics.ttest;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.common.io.stream.NamedWriteable;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.search.DocValueFormat;
import org.elasticsearch.search.aggregations.Aggregation;
import org.elasticsearch.search.aggregations.AggregationReduceContext;
import org.elasticsearch.search.aggregations.InternalAggregation;
import org.elasticsearch.search.aggregations.metrics.InternalNumericMetricsAggregation;
import org.elasticsearch.search.aggregations.support.SamplingContext;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xpack.analytics.ttest.TTest;
import org.elasticsearch.xpack.analytics.ttest.TTestState;

public class InternalTTest
extends InternalNumericMetricsAggregation.SingleValue
implements TTest {
    protected final TTestState state;

    InternalTTest(String name, TTestState state, DocValueFormat formatter, Map<String, Object> metadata) {
        super(name, formatter, metadata);
        this.state = state;
    }

    public InternalTTest(StreamInput in) throws IOException {
        super(in);
        this.state = (TTestState)in.readNamedWriteable(TTestState.class);
    }

    protected void doWriteTo(StreamOutput out) throws IOException {
        out.writeNamedWriteable((NamedWriteable)this.format);
        out.writeNamedWriteable((NamedWriteable)this.state);
    }

    public String getWriteableName() {
        return "t_test";
    }

    DocValueFormat format() {
        return this.format;
    }

    public InternalTTest reduce(List<InternalAggregation> aggregations, AggregationReduceContext reduceContext) {
        TTestState reduced = this.state.reduce(aggregations.stream().map(a -> ((InternalTTest)a).state));
        return new InternalTTest(this.name, reduced, this.format, this.getMetadata());
    }

    public InternalAggregation finalizeSampling(SamplingContext samplingContext) {
        return this;
    }

    public XContentBuilder doXContentBody(XContentBuilder builder, ToXContent.Params params) throws IOException {
        double value = this.state.getValue();
        boolean hasValue = !Double.isNaN(value);
        builder.field(Aggregation.CommonFields.VALUE.getPreferredName(), hasValue ? Double.valueOf(value) : null);
        if (hasValue && this.format != DocValueFormat.RAW) {
            builder.field(Aggregation.CommonFields.VALUE_AS_STRING.getPreferredName(), this.format.format(value).toString());
        }
        return builder;
    }

    public int hashCode() {
        return Objects.hash(super.hashCode(), this.state);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        if (!super.equals(obj)) {
            return false;
        }
        InternalTTest that = (InternalTTest)obj;
        return Objects.equals(this.state, that.state);
    }

    public double value() {
        return this.state.getValue();
    }

    @Override
    public double getValue() {
        return this.state.getValue();
    }
}

