/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.telemetry.apm;

import io.opentelemetry.api.metrics.Meter;
import java.security.AccessController;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.telemetry.metric.Instrument;

public abstract class AbstractInstrument<T>
implements Instrument {
    private static final int MAX_NAME_LENGTH = 255;
    private final AtomicReference<T> delegate;
    private final String name;
    private final String description;
    private final String unit;

    public AbstractInstrument(Meter meter, String name, String description, String unit) {
        this.name = Objects.requireNonNull(name);
        if (name.length() > 255) {
            throw new IllegalArgumentException("Instrument name [" + name + "] with length [" + name.length() + "] exceeds maximum length [255]");
        }
        this.description = Objects.requireNonNull(description);
        this.unit = Objects.requireNonNull(unit);
        this.delegate = new AtomicReference<T>(this.doBuildInstrument(meter));
    }

    private T doBuildInstrument(Meter meter) {
        return (T)AccessController.doPrivileged(() -> this.buildInstrument(meter));
    }

    public String getName() {
        return this.name;
    }

    public String getUnit() {
        return this.unit.toString();
    }

    protected T getInstrument() {
        return this.delegate.get();
    }

    protected String getDescription() {
        return this.description;
    }

    void setProvider(@Nullable Meter meter) {
        this.delegate.set(this.doBuildInstrument(Objects.requireNonNull(meter)));
    }

    protected abstract T buildInstrument(Meter var1);
}

