/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.telemetry.apm;

import io.opentelemetry.api.metrics.Meter;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Supplier;
import org.elasticsearch.common.util.concurrent.ConcurrentCollections;
import org.elasticsearch.common.util.concurrent.ReleasableLock;
import org.elasticsearch.telemetry.apm.AbstractInstrument;
import org.elasticsearch.telemetry.apm.internal.metrics.DoubleAsyncCounterAdapter;
import org.elasticsearch.telemetry.apm.internal.metrics.DoubleCounterAdapter;
import org.elasticsearch.telemetry.apm.internal.metrics.DoubleGaugeAdapter;
import org.elasticsearch.telemetry.apm.internal.metrics.DoubleHistogramAdapter;
import org.elasticsearch.telemetry.apm.internal.metrics.DoubleUpDownCounterAdapter;
import org.elasticsearch.telemetry.apm.internal.metrics.LongAsyncCounterAdapter;
import org.elasticsearch.telemetry.apm.internal.metrics.LongCounterAdapter;
import org.elasticsearch.telemetry.apm.internal.metrics.LongGaugeAdapter;
import org.elasticsearch.telemetry.apm.internal.metrics.LongHistogramAdapter;
import org.elasticsearch.telemetry.apm.internal.metrics.LongUpDownCounterAdapter;
import org.elasticsearch.telemetry.metric.DoubleAsyncCounter;
import org.elasticsearch.telemetry.metric.DoubleCounter;
import org.elasticsearch.telemetry.metric.DoubleGauge;
import org.elasticsearch.telemetry.metric.DoubleHistogram;
import org.elasticsearch.telemetry.metric.DoubleUpDownCounter;
import org.elasticsearch.telemetry.metric.DoubleWithAttributes;
import org.elasticsearch.telemetry.metric.LongAsyncCounter;
import org.elasticsearch.telemetry.metric.LongCounter;
import org.elasticsearch.telemetry.metric.LongGauge;
import org.elasticsearch.telemetry.metric.LongHistogram;
import org.elasticsearch.telemetry.metric.LongUpDownCounter;
import org.elasticsearch.telemetry.metric.LongWithAttributes;
import org.elasticsearch.telemetry.metric.MeterRegistry;

public class APMMeterRegistry
implements MeterRegistry {
    private final Registrar<DoubleCounterAdapter> doubleCounters = new Registrar();
    private final Registrar<DoubleUpDownCounterAdapter> doubleUpDownCounters = new Registrar();
    private final Registrar<DoubleGaugeAdapter> doubleGauges = new Registrar();
    private final Registrar<DoubleHistogramAdapter> doubleHistograms = new Registrar();
    private final Registrar<LongCounterAdapter> longCounters = new Registrar();
    private final Registrar<LongAsyncCounterAdapter> longAsynchronousCounters = new Registrar();
    private final Registrar<DoubleAsyncCounterAdapter> doubleAsynchronousCounters = new Registrar();
    private final Registrar<LongUpDownCounterAdapter> longUpDownCounters = new Registrar();
    private final Registrar<LongGaugeAdapter> longGauges = new Registrar();
    private final Registrar<LongHistogramAdapter> longHistograms = new Registrar();
    private Meter meter;
    private final List<Registrar<?>> registrars = List.of(this.doubleCounters, this.doubleUpDownCounters, this.doubleGauges, this.doubleHistograms, this.longCounters, this.longUpDownCounters, this.longGauges, this.longHistograms);
    protected final ReleasableLock registerLock = new ReleasableLock((Lock)new ReentrantLock());

    public APMMeterRegistry(Meter meter) {
        this.meter = meter;
    }

    public DoubleCounter registerDoubleCounter(String name, String description, String unit) {
        try (ReleasableLock lock = this.registerLock.acquire();){
            DoubleCounter doubleCounter = this.doubleCounters.register(new DoubleCounterAdapter(this.meter, name, description, unit));
            return doubleCounter;
        }
    }

    public DoubleCounter getDoubleCounter(String name) {
        return this.doubleCounters.get(name);
    }

    public DoubleUpDownCounter registerDoubleUpDownCounter(String name, String description, String unit) {
        try (ReleasableLock lock = this.registerLock.acquire();){
            DoubleUpDownCounter doubleUpDownCounter = this.doubleUpDownCounters.register(new DoubleUpDownCounterAdapter(this.meter, name, description, unit));
            return doubleUpDownCounter;
        }
    }

    public DoubleUpDownCounter getDoubleUpDownCounter(String name) {
        return this.doubleUpDownCounters.get(name);
    }

    public DoubleGauge registerDoubleGauge(String name, String description, String unit, Supplier<DoubleWithAttributes> observer) {
        try (ReleasableLock lock = this.registerLock.acquire();){
            DoubleGauge doubleGauge = this.doubleGauges.register(new DoubleGaugeAdapter(this.meter, name, description, unit, observer));
            return doubleGauge;
        }
    }

    public DoubleGauge getDoubleGauge(String name) {
        return this.doubleGauges.get(name);
    }

    public DoubleHistogram registerDoubleHistogram(String name, String description, String unit) {
        try (ReleasableLock lock = this.registerLock.acquire();){
            DoubleHistogram doubleHistogram = this.doubleHistograms.register(new DoubleHistogramAdapter(this.meter, name, description, unit));
            return doubleHistogram;
        }
    }

    public DoubleHistogram getDoubleHistogram(String name) {
        return this.doubleHistograms.get(name);
    }

    public LongCounter registerLongCounter(String name, String description, String unit) {
        try (ReleasableLock lock = this.registerLock.acquire();){
            LongCounter longCounter = this.longCounters.register(new LongCounterAdapter(this.meter, name, description, unit));
            return longCounter;
        }
    }

    public LongAsyncCounter registerLongAsyncCounter(String name, String description, String unit, Supplier<LongWithAttributes> observer) {
        try (ReleasableLock lock = this.registerLock.acquire();){
            LongAsyncCounter longAsyncCounter = this.longAsynchronousCounters.register(new LongAsyncCounterAdapter(this.meter, name, description, unit, observer));
            return longAsyncCounter;
        }
    }

    public LongAsyncCounter getLongAsyncCounter(String name) {
        return this.longAsynchronousCounters.get(name);
    }

    public DoubleAsyncCounter registerDoubleAsyncCounter(String name, String description, String unit, Supplier<DoubleWithAttributes> observer) {
        try (ReleasableLock lock = this.registerLock.acquire();){
            DoubleAsyncCounter doubleAsyncCounter = this.doubleAsynchronousCounters.register(new DoubleAsyncCounterAdapter(this.meter, name, description, unit, observer));
            return doubleAsyncCounter;
        }
    }

    public DoubleAsyncCounter getDoubleAsyncCounter(String name) {
        return this.doubleAsynchronousCounters.get(name);
    }

    public LongCounter getLongCounter(String name) {
        return this.longCounters.get(name);
    }

    public LongUpDownCounter registerLongUpDownCounter(String name, String description, String unit) {
        try (ReleasableLock lock = this.registerLock.acquire();){
            LongUpDownCounter longUpDownCounter = this.longUpDownCounters.register(new LongUpDownCounterAdapter(this.meter, name, description, unit));
            return longUpDownCounter;
        }
    }

    public LongUpDownCounter getLongUpDownCounter(String name) {
        return this.longUpDownCounters.get(name);
    }

    public LongGauge registerLongGauge(String name, String description, String unit, Supplier<LongWithAttributes> observer) {
        try (ReleasableLock lock = this.registerLock.acquire();){
            LongGauge longGauge = this.longGauges.register(new LongGaugeAdapter(this.meter, name, description, unit, observer));
            return longGauge;
        }
    }

    public LongGauge getLongGauge(String name) {
        return this.longGauges.get(name);
    }

    public LongHistogram registerLongHistogram(String name, String description, String unit) {
        try (ReleasableLock lock = this.registerLock.acquire();){
            LongHistogram longHistogram = this.longHistograms.register(new LongHistogramAdapter(this.meter, name, description, unit));
            return longHistogram;
        }
    }

    public LongHistogram getLongHistogram(String name) {
        return this.longHistograms.get(name);
    }

    public void setProvider(Meter meter) {
        try (ReleasableLock lock = this.registerLock.acquire();){
            this.meter = meter;
            for (Registrar<?> registrar : this.registrars) {
                registrar.setProvider(this.meter);
            }
        }
    }

    Meter getMeter() {
        return this.meter;
    }

    private static class Registrar<T extends AbstractInstrument<?>> {
        private final Map<String, T> registered = ConcurrentCollections.newConcurrentMap();

        private Registrar() {
        }

        T register(T instrument) {
            this.registered.compute(((AbstractInstrument)instrument).getName(), (k, v) -> {
                if (v != null) {
                    throw new IllegalStateException(instrument.getClass().getSimpleName() + "[" + instrument.getName() + "] already registered");
                }
                return instrument;
            });
            return instrument;
        }

        T get(String name) {
            return (T)((AbstractInstrument)this.registered.get(name));
        }

        void setProvider(Meter meter) {
            this.registered.forEach((k, v) -> v.setProvider(meter));
        }
    }
}

