/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.transform.transforms.pivot;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ValidateActions;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.xcontent.LoggingDeprecationHandler;
import org.elasticsearch.search.aggregations.AggregationBuilder;
import org.elasticsearch.search.aggregations.AggregatorFactories;
import org.elasticsearch.search.aggregations.PipelineAggregationBuilder;
import org.elasticsearch.xcontent.DeprecationHandler;
import org.elasticsearch.xcontent.NamedXContentRegistry;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentFactory;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xcontent.XContentType;
import org.elasticsearch.xpack.core.deprecation.DeprecationIssue;
import org.elasticsearch.xpack.core.deprecation.LoggingDeprecationAccumulationHandler;

public class AggregationConfig
implements Writeable,
ToXContentObject {
    private static final Logger logger = LogManager.getLogger(AggregationConfig.class);
    private final Map<String, Object> source;
    private final AggregatorFactories.Builder aggregations;

    public AggregationConfig(Map<String, Object> source, AggregatorFactories.Builder aggregations) {
        this.source = source;
        this.aggregations = aggregations;
    }

    public AggregationConfig(StreamInput in) throws IOException {
        this.source = in.readMap();
        this.aggregations = (AggregatorFactories.Builder)in.readOptionalWriteable(AggregatorFactories.Builder::new);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        return builder.map(this.source);
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeGenericMap(this.source);
        out.writeOptionalWriteable((Writeable)this.aggregations);
    }

    public Collection<AggregationBuilder> getAggregatorFactories() {
        return this.aggregations.getAggregatorFactories();
    }

    public Collection<PipelineAggregationBuilder> getPipelineAggregatorFactories() {
        return this.aggregations.getPipelineAggregatorFactories();
    }

    public Collection<String> getUsedNames() {
        if (this.aggregations == null) {
            return Collections.emptyList();
        }
        ArrayList<String> usedNames = new ArrayList<String>();
        this.getAggregatorFactories().forEach(agg -> AggregationConfig.addAggNames("", agg, (Collection<String>)usedNames));
        this.getPipelineAggregatorFactories().forEach(agg -> AggregationConfig.addAggNames("", agg, (Collection<String>)usedNames));
        return usedNames;
    }

    private static void addAggNames(String namePrefix, AggregationBuilder aggregationBuilder, Collection<String> names) {
        if (aggregationBuilder.getSubAggregations().isEmpty() && aggregationBuilder.getPipelineAggregations().isEmpty()) {
            names.add(namePrefix + aggregationBuilder.getName());
            return;
        }
        String newNamePrefix = namePrefix + aggregationBuilder.getName() + ".";
        aggregationBuilder.getSubAggregations().forEach(agg -> AggregationConfig.addAggNames(newNamePrefix, agg, names));
        aggregationBuilder.getPipelineAggregations().forEach(agg -> AggregationConfig.addAggNames(newNamePrefix, agg, names));
    }

    private static void addAggNames(String namePrefix, PipelineAggregationBuilder pipelineAggregationBuilder, Collection<String> names) {
        names.add(namePrefix + pipelineAggregationBuilder.getName());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static AggregationConfig fromXContent(XContentParser parser, boolean lenient) throws IOException {
        NamedXContentRegistry registry = parser.getXContentRegistry();
        Map source = parser.mapOrdered();
        AggregatorFactories.Builder aggregations = null;
        if (source.isEmpty()) {
            if (!lenient) throw new IllegalArgumentException("Pivot transform configuration must specify at least 1 aggregation");
            logger.warn("Pivot transform configuration must specify at least 1 aggregation");
            return new AggregationConfig(source, aggregations);
        }
        try {
            aggregations = AggregationConfig.aggregationsFromXContent(source, registry, (DeprecationHandler)LoggingDeprecationHandler.INSTANCE);
            return new AggregationConfig(source, aggregations);
        }
        catch (Exception e) {
            if (!lenient) throw e;
            logger.warn("Failed to parse aggregation for pivot transform", (Throwable)e);
            return new AggregationConfig(source, aggregations);
        }
    }

    private static AggregatorFactories.Builder aggregationsFromXContent(Map<String, Object> source, NamedXContentRegistry namedXContentRegistry, DeprecationHandler deprecationHandler) throws IOException {
        AggregatorFactories.Builder aggregations = null;
        XContentBuilder xContentBuilder = XContentFactory.jsonBuilder().map(source);
        XContentParser sourceParser = XContentType.JSON.xContent().createParser(namedXContentRegistry, deprecationHandler, (InputStream)BytesReference.bytes((XContentBuilder)xContentBuilder).streamInput());
        sourceParser.nextToken();
        aggregations = AggregatorFactories.parseAggregators((XContentParser)sourceParser);
        return aggregations;
    }

    public int hashCode() {
        return Objects.hash(this.source, this.aggregations);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        AggregationConfig that = (AggregationConfig)other;
        return Objects.equals(this.source, that.source) && Objects.equals(this.aggregations, that.aggregations);
    }

    public ActionRequestValidationException validate(ActionRequestValidationException validationException) {
        if (this.aggregations == null) {
            validationException = ValidateActions.addValidationError((String)"pivot.aggregations must not be null", (ActionRequestValidationException)validationException);
        }
        return validationException;
    }

    public void checkForDeprecations(String id, NamedXContentRegistry namedXContentRegistry, Consumer<DeprecationIssue> onDeprecation) {
        LoggingDeprecationAccumulationHandler deprecationLogger = new LoggingDeprecationAccumulationHandler();
        try {
            AggregationConfig.aggregationsFromXContent(this.source, namedXContentRegistry, deprecationLogger);
        }
        catch (IOException e) {
            onDeprecation.accept(new DeprecationIssue(DeprecationIssue.Level.CRITICAL, "Transform [" + id + "]: Failed to parse aggregation for pivot transform", "https://ela.st/es-deprecation-8-transform-aggregation-options", e.getMessage(), false, null));
        }
        deprecationLogger.getDeprecations().forEach(deprecationMessage -> onDeprecation.accept(new DeprecationIssue(DeprecationIssue.Level.CRITICAL, "Transform [" + id + "] uses deprecated aggregation options", "https://ela.st/es-deprecation-8-transform-aggregation-options", (String)deprecationMessage, false, null)));
    }
}

