/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.security.action.apikey;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ValidateActions;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.xpack.core.security.action.apikey.ApiKey;
import org.elasticsearch.xpack.core.security.action.apikey.BaseSingleUpdateApiKeyRequest;
import org.elasticsearch.xpack.core.security.action.apikey.CrossClusterApiKeyRoleDescriptorBuilder;

public final class UpdateCrossClusterApiKeyRequest
extends BaseSingleUpdateApiKeyRequest {
    public UpdateCrossClusterApiKeyRequest(String id, @Nullable CrossClusterApiKeyRoleDescriptorBuilder roleDescriptorBuilder, @Nullable Map<String, Object> metadata) {
        super(roleDescriptorBuilder == null ? null : List.of(roleDescriptorBuilder.build()), metadata, id);
    }

    public UpdateCrossClusterApiKeyRequest(StreamInput in) throws IOException {
        super(in);
    }

    @Override
    public ApiKey.Type getType() {
        return ApiKey.Type.CROSS_CLUSTER;
    }

    @Override
    public ActionRequestValidationException validate() {
        ActionRequestValidationException validationException = super.validate();
        if (this.roleDescriptors == null && this.metadata == null) {
            validationException = ValidateActions.addValidationError((String)"must update either [access] or [metadata] for cross-cluster API keys", (ActionRequestValidationException)validationException);
        }
        return validationException;
    }
}

