/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.security.action.apikey;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;

public final class InvalidateApiKeyResponse
extends ActionResponse
implements ToXContentObject,
Writeable {
    private final List<String> invalidatedApiKeys;
    private final List<String> previouslyInvalidatedApiKeys;
    private final List<ElasticsearchException> errors;
    static final ConstructingObjectParser<InvalidateApiKeyResponse, Void> PARSER = new ConstructingObjectParser("invalidate_api_key_response", args -> new InvalidateApiKeyResponse((List)args[0], (List)args[1], (List)args[3]));

    public InvalidateApiKeyResponse(StreamInput in) throws IOException {
        super(in);
        this.invalidatedApiKeys = in.readCollectionAsList(StreamInput::readString);
        this.previouslyInvalidatedApiKeys = in.readCollectionAsList(StreamInput::readString);
        this.errors = in.readCollectionAsList(StreamInput::readException);
    }

    public InvalidateApiKeyResponse(List<String> invalidatedApiKeys, List<String> previouslyInvalidatedApiKeys, @Nullable List<ElasticsearchException> errors) {
        this.invalidatedApiKeys = Objects.requireNonNull(invalidatedApiKeys, "invalidated_api_keys must be provided");
        this.previouslyInvalidatedApiKeys = Objects.requireNonNull(previouslyInvalidatedApiKeys, "previously_invalidated_api_keys must be provided");
        this.errors = null != errors ? errors : Collections.emptyList();
    }

    public static InvalidateApiKeyResponse emptyResponse() {
        return new InvalidateApiKeyResponse(Collections.emptyList(), Collections.emptyList(), Collections.emptyList());
    }

    public List<String> getInvalidatedApiKeys() {
        return this.invalidatedApiKeys;
    }

    public List<String> getPreviouslyInvalidatedApiKeys() {
        return this.previouslyInvalidatedApiKeys;
    }

    public List<ElasticsearchException> getErrors() {
        return this.errors;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject().array("invalidated_api_keys", this.invalidatedApiKeys.toArray(Strings.EMPTY_ARRAY)).array("previously_invalidated_api_keys", this.previouslyInvalidatedApiKeys.toArray(Strings.EMPTY_ARRAY)).field("error_count", this.errors.size());
        if (!this.errors.isEmpty()) {
            builder.field("error_details");
            builder.startArray();
            for (ElasticsearchException e : this.errors) {
                builder.startObject();
                ElasticsearchException.generateThrowableXContent((XContentBuilder)builder, (ToXContent.Params)params, (Throwable)e);
                builder.endObject();
            }
            builder.endArray();
        }
        return builder.endObject();
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeStringCollection(this.invalidatedApiKeys);
        out.writeStringCollection(this.previouslyInvalidatedApiKeys);
        out.writeCollection(this.errors, StreamOutput::writeException);
    }

    public static InvalidateApiKeyResponse fromXContent(XContentParser parser) throws IOException {
        return (InvalidateApiKeyResponse)((Object)PARSER.parse(parser, null));
    }

    public String toString() {
        return "InvalidateApiKeyResponse [invalidatedApiKeys=" + this.invalidatedApiKeys + ", previouslyInvalidatedApiKeys=" + this.previouslyInvalidatedApiKeys + ", errors=" + this.errors + "]";
    }

    static {
        PARSER.declareStringArray(ConstructingObjectParser.constructorArg(), new ParseField("invalidated_api_keys", new String[0]));
        PARSER.declareStringArray(ConstructingObjectParser.constructorArg(), new ParseField("previously_invalidated_api_keys", new String[0]));
        PARSER.declareInt(ConstructingObjectParser.constructorArg(), new ParseField("error_count", new String[0]));
        PARSER.declareObjectArray(ConstructingObjectParser.optionalConstructorArg(), (p, c) -> ElasticsearchException.fromXContent((XContentParser)p), new ParseField("error_details", new String[0]));
    }
}

