/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ml.inference.trainedmodel;

import java.io.IOException;
import java.util.Objects;
import java.util.Optional;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.common.io.stream.NamedWriteable;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xpack.core.ml.MlConfigVersion;
import org.elasticsearch.xpack.core.ml.inference.persistence.InferenceIndexConstants;
import org.elasticsearch.xpack.core.ml.inference.trainedmodel.NlpConfig;
import org.elasticsearch.xpack.core.ml.inference.trainedmodel.TargetType;
import org.elasticsearch.xpack.core.ml.inference.trainedmodel.Tokenization;
import org.elasticsearch.xpack.core.ml.inference.trainedmodel.VocabularyConfig;
import org.elasticsearch.xpack.core.ml.utils.ExceptionsHelper;
import org.elasticsearch.xpack.core.ml.utils.NamedXContentObjectHelper;

public class QuestionAnsweringConfig
implements NlpConfig {
    public static final String NAME = "question_answering";
    public static final ParseField MAX_ANSWER_LENGTH = new ParseField("max_answer_length", new String[0]);
    public static final ParseField QUESTION = new ParseField("question", new String[0]);
    public static final int DEFAULT_MAX_ANSWER_LENGTH = 15;
    public static final int DEFAULT_NUM_TOP_CLASSES = 0;
    private static final ConstructingObjectParser<QuestionAnsweringConfig, Void> STRICT_PARSER = QuestionAnsweringConfig.createParser(false);
    private static final ConstructingObjectParser<QuestionAnsweringConfig, Void> LENIENT_PARSER = QuestionAnsweringConfig.createParser(true);
    private final int numTopClasses;
    private final int maxAnswerLength;
    private final VocabularyConfig vocabularyConfig;
    private final Tokenization tokenization;
    private final String resultsField;
    private final String question;

    public static QuestionAnsweringConfig fromXContentStrict(XContentParser parser) {
        return (QuestionAnsweringConfig)STRICT_PARSER.apply(parser, null);
    }

    public static QuestionAnsweringConfig fromXContentLenient(XContentParser parser) {
        return (QuestionAnsweringConfig)LENIENT_PARSER.apply(parser, null);
    }

    private static ConstructingObjectParser<QuestionAnsweringConfig, Void> createParser(boolean ignoreUnknownFields) {
        ConstructingObjectParser parser = new ConstructingObjectParser(NAME, ignoreUnknownFields, a -> new QuestionAnsweringConfig((Integer)a[0], (Integer)a[1], (VocabularyConfig)a[2], (Tokenization)a[3], (String)a[4]));
        parser.declareInt(ConstructingObjectParser.optionalConstructorArg(), NUM_TOP_CLASSES);
        parser.declareInt(ConstructingObjectParser.optionalConstructorArg(), MAX_ANSWER_LENGTH);
        parser.declareObject(ConstructingObjectParser.optionalConstructorArg(), (p, c) -> {
            if (!ignoreUnknownFields) {
                throw ExceptionsHelper.badRequestException("illegal setting [{}] on inference model creation", VOCABULARY.getPreferredName());
            }
            return VocabularyConfig.fromXContentLenient(p);
        }, VOCABULARY);
        parser.declareNamedObject(ConstructingObjectParser.optionalConstructorArg(), (p, c, n) -> (Tokenization)p.namedObject(Tokenization.class, n, (Object)ignoreUnknownFields), TOKENIZATION);
        parser.declareString(ConstructingObjectParser.optionalConstructorArg(), RESULTS_FIELD);
        return parser;
    }

    public QuestionAnsweringConfig(@Nullable Integer numTopClasses, @Nullable Integer maxAnswerLength, @Nullable VocabularyConfig vocabularyConfig, @Nullable Tokenization tokenization, @Nullable String resultsField) {
        this.numTopClasses = Optional.ofNullable(numTopClasses).orElse(0);
        this.maxAnswerLength = Optional.ofNullable(maxAnswerLength).orElse(15);
        if (this.numTopClasses < 0) {
            throw ExceptionsHelper.badRequestException("[{}] must be greater than or equal to [0]; provided [{}]", NUM_TOP_CLASSES.getPreferredName(), this.numTopClasses);
        }
        if (this.maxAnswerLength <= 0) {
            throw ExceptionsHelper.badRequestException("[{}] must be greater than [0]; provided [{}]", MAX_ANSWER_LENGTH.getPreferredName(), this.maxAnswerLength);
        }
        this.vocabularyConfig = Optional.ofNullable(vocabularyConfig).orElse(new VocabularyConfig(InferenceIndexConstants.nativeDefinitionStore()));
        this.tokenization = tokenization == null ? Tokenization.createDefault() : tokenization;
        this.resultsField = resultsField;
        this.question = null;
    }

    public QuestionAnsweringConfig(String question, int numTopClasses, int maxAnswerLength, VocabularyConfig vocabularyConfig, Tokenization tokenization, String resultsField) {
        this.question = ExceptionsHelper.requireNonNull(question, QUESTION);
        this.numTopClasses = numTopClasses;
        this.maxAnswerLength = maxAnswerLength;
        if (this.numTopClasses < 0) {
            throw ExceptionsHelper.badRequestException("[{}] must be greater than or equal to [0]; provided [{}]", NUM_TOP_CLASSES.getPreferredName(), this.numTopClasses);
        }
        if (this.maxAnswerLength <= 0) {
            throw ExceptionsHelper.badRequestException("[{}] must be greater than [0]; provided [{}]", MAX_ANSWER_LENGTH.getPreferredName(), this.maxAnswerLength);
        }
        this.vocabularyConfig = ExceptionsHelper.requireNonNull(vocabularyConfig, VOCABULARY);
        this.tokenization = ExceptionsHelper.requireNonNull(tokenization, TOKENIZATION);
        this.resultsField = resultsField;
    }

    public QuestionAnsweringConfig(StreamInput in) throws IOException {
        this.numTopClasses = in.readVInt();
        this.maxAnswerLength = in.readVInt();
        this.vocabularyConfig = new VocabularyConfig(in);
        this.tokenization = (Tokenization)in.readNamedWriteable(Tokenization.class);
        this.resultsField = in.readOptionalString();
        this.question = in.readOptionalString();
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeVInt(this.numTopClasses);
        out.writeVInt(this.maxAnswerLength);
        this.vocabularyConfig.writeTo(out);
        out.writeNamedWriteable((NamedWriteable)this.tokenization);
        out.writeOptionalString(this.resultsField);
        out.writeOptionalString(this.question);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(NUM_TOP_CLASSES.getPreferredName(), this.numTopClasses);
        builder.field(MAX_ANSWER_LENGTH.getPreferredName(), this.maxAnswerLength);
        builder.field(VOCABULARY.getPreferredName(), (ToXContent)this.vocabularyConfig, params);
        NamedXContentObjectHelper.writeNamedObject(builder, params, TOKENIZATION.getPreferredName(), this.tokenization);
        if (this.resultsField != null) {
            builder.field(RESULTS_FIELD.getPreferredName(), this.resultsField);
        }
        if (this.question != null) {
            builder.field(QUESTION.getPreferredName(), this.question);
        }
        builder.endObject();
        return builder;
    }

    public String getWriteableName() {
        return NAME;
    }

    @Override
    public boolean isTargetTypeSupported(TargetType targetType) {
        return false;
    }

    @Override
    public MlConfigVersion getMinimalSupportedMlConfigVersion() {
        return MlConfigVersion.V_8_3_0;
    }

    @Override
    public TransportVersion getMinimalSupportedTransportVersion() {
        return TransportVersions.V_8_3_0;
    }

    @Override
    public String getName() {
        return NAME;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        QuestionAnsweringConfig that = (QuestionAnsweringConfig)o;
        return Objects.equals(this.vocabularyConfig, that.vocabularyConfig) && Objects.equals(this.tokenization, that.tokenization) && Objects.equals(this.numTopClasses, that.numTopClasses) && Objects.equals(this.maxAnswerLength, that.maxAnswerLength) && Objects.equals(this.question, that.question) && Objects.equals(this.resultsField, that.resultsField);
    }

    public int hashCode() {
        return Objects.hash(this.vocabularyConfig, this.tokenization, this.maxAnswerLength, this.numTopClasses, this.resultsField, this.question);
    }

    @Override
    public VocabularyConfig getVocabularyConfig() {
        return this.vocabularyConfig;
    }

    @Override
    public Tokenization getTokenization() {
        return this.tokenization;
    }

    public int getNumTopClasses() {
        return this.numTopClasses;
    }

    public int getMaxAnswerLength() {
        return this.maxAnswerLength;
    }

    public String getQuestion() {
        return this.question;
    }

    @Override
    public String getResultsField() {
        return this.resultsField;
    }

    @Override
    public boolean isAllocateOnly() {
        return true;
    }
}

