/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ml.action;

import java.io.IOException;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.ValidateActions;
import org.elasticsearch.action.support.master.AcknowledgedRequest;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.common.VersionId;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.xcontent.ObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xpack.core.ml.inference.TrainedModelConfig;
import org.elasticsearch.xpack.core.ml.utils.ExceptionsHelper;

public class PutTrainedModelVocabularyAction
extends ActionType<AcknowledgedResponse> {
    public static final PutTrainedModelVocabularyAction INSTANCE = new PutTrainedModelVocabularyAction();
    public static final String NAME = "cluster:admin/xpack/ml/trained_models/vocabulary/put";

    private PutTrainedModelVocabularyAction() {
        super(NAME, AcknowledgedResponse::readFrom);
    }

    public static class Request
    extends AcknowledgedRequest<Request> {
        public static final ParseField VOCABULARY = new ParseField("vocabulary", new String[0]);
        public static final ParseField MERGES = new ParseField("merges", new String[0]);
        public static final ParseField SCORES = new ParseField("scores", new String[0]);
        private static final ObjectParser<Builder, Void> PARSER = new ObjectParser("put_trained_model_vocabulary", Builder::new);
        private final String modelId;
        private final List<String> vocabulary;
        private final List<String> merges;
        private final List<Double> scores;
        private final boolean allowOverwriting;

        public static Request parseRequest(String modelId, XContentParser parser) {
            return ((Builder)PARSER.apply(parser, null)).build(modelId, false);
        }

        public Request(String modelId, List<String> vocabulary, @Nullable List<String> merges, @Nullable List<Double> scores, boolean allowOverwriting) {
            this.modelId = ExceptionsHelper.requireNonNull(modelId, TrainedModelConfig.MODEL_ID);
            this.vocabulary = ExceptionsHelper.requireNonNull(vocabulary, VOCABULARY);
            this.merges = Optional.ofNullable(merges).orElse(List.of());
            this.scores = Optional.ofNullable(scores).orElse(List.of());
            this.allowOverwriting = allowOverwriting;
        }

        public Request(StreamInput in) throws IOException {
            super(in);
            this.modelId = in.readString();
            this.vocabulary = in.readStringCollectionAsList();
            this.merges = in.getTransportVersion().onOrAfter((VersionId)TransportVersions.V_8_2_0) ? in.readStringCollectionAsList() : List.of();
            this.scores = in.getTransportVersion().onOrAfter((VersionId)TransportVersions.V_8_500_020) ? in.readCollectionAsList(StreamInput::readDouble) : List.of();
            this.allowOverwriting = in.getTransportVersion().onOrAfter((VersionId)TransportVersions.V_8_500_043) ? in.readBoolean() : false;
        }

        public ActionRequestValidationException validate() {
            ActionRequestValidationException validationException = null;
            if (this.vocabulary.isEmpty()) {
                validationException = ValidateActions.addValidationError((String)"[vocabulary] must not be empty", validationException);
            } else if (!this.scores.isEmpty() && this.scores.size() != this.vocabulary.size()) {
                validationException = ValidateActions.addValidationError((String)"[scores] must have same length as [vocabulary]", (ActionRequestValidationException)validationException);
            }
            return validationException;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
                return false;
            }
            Request request = (Request)((Object)o);
            return Objects.equals(this.modelId, request.modelId) && Objects.equals(this.vocabulary, request.vocabulary) && Objects.equals(this.scores, request.scores) && Objects.equals(this.merges, request.merges) && this.allowOverwriting == request.allowOverwriting;
        }

        public int hashCode() {
            return Objects.hash(this.modelId, this.vocabulary, this.merges, this.scores, this.allowOverwriting);
        }

        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeString(this.modelId);
            out.writeStringCollection(this.vocabulary);
            if (out.getTransportVersion().onOrAfter((VersionId)TransportVersions.V_8_2_0)) {
                out.writeStringCollection(this.merges);
            }
            if (out.getTransportVersion().onOrAfter((VersionId)TransportVersions.V_8_500_020)) {
                out.writeCollection(this.scores, StreamOutput::writeDouble);
            }
            if (out.getTransportVersion().onOrAfter((VersionId)TransportVersions.V_8_500_043)) {
                out.writeBoolean(this.allowOverwriting);
            }
        }

        public String getModelId() {
            return this.modelId;
        }

        public List<String> getVocabulary() {
            return this.vocabulary;
        }

        public List<String> getMerges() {
            return this.merges;
        }

        public List<Double> getScores() {
            return this.scores;
        }

        public boolean isOverwritingAllowed() {
            return this.allowOverwriting;
        }

        static {
            PARSER.declareStringArray(Builder::setVocabulary, VOCABULARY);
            PARSER.declareStringArray(Builder::setMerges, MERGES);
            PARSER.declareDoubleArray(Builder::setScores, SCORES);
        }

        public static class Builder {
            private List<String> vocabulary;
            private List<String> merges;
            private List<Double> scores;

            public Builder setVocabulary(List<String> vocabulary) {
                this.vocabulary = vocabulary;
                return this;
            }

            public Builder setMerges(List<String> merges) {
                this.merges = merges;
                return this;
            }

            public Builder setScores(List<Double> scores) {
                this.scores = scores;
                return this;
            }

            public Request build(String modelId, boolean allowOverwriting) {
                return new Request(modelId, this.vocabulary, this.merges, this.scores, allowOverwriting);
            }
        }
    }
}

