/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.inference.nlp;

import java.io.IOException;
import java.util.List;
import java.util.Objects;
import org.elasticsearch.common.ValidationException;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.inference.InferenceResults;
import org.elasticsearch.xpack.core.ml.inference.trainedmodel.NlpConfig;
import org.elasticsearch.xpack.core.ml.inference.trainedmodel.Tokenization;
import org.elasticsearch.xpack.ml.inference.nlp.TaskType;
import org.elasticsearch.xpack.ml.inference.nlp.Vocabulary;
import org.elasticsearch.xpack.ml.inference.nlp.tokenizers.NlpTokenizer;
import org.elasticsearch.xpack.ml.inference.nlp.tokenizers.TokenizationResult;
import org.elasticsearch.xpack.ml.inference.pytorch.results.PyTorchInferenceResult;

public class NlpTask {
    private final NlpConfig config;
    private final NlpTokenizer tokenizer;

    public NlpTask(NlpConfig config, Vocabulary vocabulary) throws IOException {
        this.config = config;
        this.tokenizer = NlpTokenizer.build(vocabulary, config.getTokenization());
    }

    public Processor createProcessor() throws ValidationException {
        return TaskType.fromString(this.config.getName()).createProcessor(this.tokenizer, this.config);
    }

    public static abstract class Processor
    implements Releasable {
        protected final NlpTokenizer tokenizer;

        public Processor(NlpTokenizer tokenizer) {
            this.tokenizer = tokenizer;
        }

        public void close() {
            this.tokenizer.close();
        }

        public abstract void validateInputs(List<String> var1);

        public abstract RequestBuilder getRequestBuilder(NlpConfig var1);

        public abstract ResultProcessor getResultProcessor(NlpConfig var1);
    }

    public record Request(TokenizationResult tokenization, BytesReference processInput) {
        public Request(TokenizationResult tokenization, BytesReference processInput) {
            this.tokenization = Objects.requireNonNull(tokenization);
            this.processInput = Objects.requireNonNull(processInput);
        }
    }

    public static interface ResultProcessor {
        public InferenceResults processResult(TokenizationResult var1, PyTorchInferenceResult var2);
    }

    public static interface RequestBuilder {
        public Request buildRequest(List<String> var1, String var2, Tokenization.Truncate var3, int var4) throws IOException;
    }
}

