/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.datafeed.extractor.aggregation;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Optional;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.ActionRequestBuilder;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.search.aggregations.Aggregation;
import org.elasticsearch.search.aggregations.Aggregations;
import org.elasticsearch.search.aggregations.AggregatorFactories;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.xpack.core.ClientHelper;
import org.elasticsearch.xpack.core.ml.datafeed.SearchInterval;
import org.elasticsearch.xpack.core.ml.datafeed.extractor.DataExtractor;
import org.elasticsearch.xpack.core.ml.datafeed.extractor.ExtractorUtils;
import org.elasticsearch.xpack.ml.datafeed.DatafeedTimingStatsReporter;
import org.elasticsearch.xpack.ml.datafeed.extractor.aggregation.AggregationDataExtractorContext;
import org.elasticsearch.xpack.ml.datafeed.extractor.aggregation.AggregationToJsonProcessor;

abstract class AbstractAggregationDataExtractor<T extends ActionRequestBuilder<SearchRequest, SearchResponse>>
implements DataExtractor {
    private static final Logger LOGGER = LogManager.getLogger(AbstractAggregationDataExtractor.class);
    protected final Client client;
    protected final AggregationDataExtractorContext context;
    private final DatafeedTimingStatsReporter timingStatsReporter;
    private boolean hasNext;
    private volatile boolean isCancelled;
    private AggregationToJsonProcessor aggregationToJsonProcessor;
    private final ByteArrayOutputStream outputStream;

    AbstractAggregationDataExtractor(Client client, AggregationDataExtractorContext dataExtractorContext, DatafeedTimingStatsReporter timingStatsReporter) {
        this.client = Objects.requireNonNull(client);
        this.context = Objects.requireNonNull(dataExtractorContext);
        this.timingStatsReporter = Objects.requireNonNull(timingStatsReporter);
        this.hasNext = true;
        this.isCancelled = false;
        this.outputStream = new ByteArrayOutputStream();
    }

    public boolean hasNext() {
        return this.hasNext;
    }

    public boolean isCancelled() {
        return this.isCancelled;
    }

    public void cancel() {
        LOGGER.debug("[{}] Data extractor received cancel request", (Object)this.context.jobId);
        this.isCancelled = true;
        this.hasNext = false;
    }

    public void destroy() {
        this.cancel();
    }

    public long getEndTime() {
        return this.context.end;
    }

    public DataExtractor.Result next() throws IOException {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        SearchInterval searchInterval = new SearchInterval(this.context.start, this.context.end);
        if (this.aggregationToJsonProcessor == null) {
            Aggregations aggs = this.search();
            if (aggs == null) {
                this.hasNext = false;
                return new DataExtractor.Result(searchInterval, Optional.empty());
            }
            this.initAggregationProcessor(aggs);
        }
        this.outputStream.reset();
        this.aggregationToJsonProcessor.writeAllDocsCancellable(_timestamp -> this.isCancelled, this.outputStream);
        this.hasNext = false;
        return new DataExtractor.Result(searchInterval, this.aggregationToJsonProcessor.getKeyValueCount() > 0L ? Optional.of(new ByteArrayInputStream(this.outputStream.toByteArray())) : Optional.empty());
    }

    private Aggregations search() {
        LOGGER.debug("[{}] Executing aggregated search", (Object)this.context.jobId);
        T searchRequest = this.buildSearchRequest(this.buildBaseSearchSource());
        assert (!((SearchRequest)searchRequest.request()).allowPartialSearchResults().booleanValue());
        SearchResponse searchResponse = this.executeSearchRequest(searchRequest);
        this.checkForSkippedClusters(searchResponse);
        LOGGER.debug("[{}] Search response was obtained", (Object)this.context.jobId);
        this.timingStatsReporter.reportSearchDuration(searchResponse.getTook());
        return AbstractAggregationDataExtractor.validateAggs(searchResponse.getAggregations());
    }

    private void initAggregationProcessor(Aggregations aggs) throws IOException {
        this.aggregationToJsonProcessor = new AggregationToJsonProcessor(this.context.timeField, this.context.fields, this.context.includeDocCount, this.context.start, null);
        this.aggregationToJsonProcessor.process(aggs);
    }

    protected SearchResponse executeSearchRequest(T searchRequestBuilder) {
        return (SearchResponse)ClientHelper.executeWithHeaders(this.context.headers, (String)"ml", (Client)this.client, () -> searchRequestBuilder.get());
    }

    private SearchSourceBuilder buildBaseSearchSource() {
        long histogramSearchStartTime = Math.max(0L, this.context.start - ExtractorUtils.getHistogramIntervalMillis((AggregatorFactories.Builder)this.context.aggs));
        SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder().size(0).query(ExtractorUtils.wrapInTimeRangeQuery((QueryBuilder)this.context.query, (String)this.context.timeField, (long)histogramSearchStartTime, (long)this.context.end));
        if (!this.context.runtimeMappings.isEmpty()) {
            searchSourceBuilder.runtimeMappings(this.context.runtimeMappings);
        }
        this.context.aggs.getAggregatorFactories().forEach(arg_0 -> ((SearchSourceBuilder)searchSourceBuilder).aggregation(arg_0));
        this.context.aggs.getPipelineAggregatorFactories().forEach(arg_0 -> ((SearchSourceBuilder)searchSourceBuilder).aggregation(arg_0));
        return searchSourceBuilder;
    }

    protected abstract T buildSearchRequest(SearchSourceBuilder var1);

    private static Aggregations validateAggs(@Nullable Aggregations aggs) {
        if (aggs == null) {
            return null;
        }
        List aggsAsList = aggs.asList();
        if (aggsAsList.isEmpty()) {
            return null;
        }
        if (aggsAsList.size() > 1) {
            throw new IllegalArgumentException("Multiple top level aggregations not supported; found: " + aggsAsList.stream().map(Aggregation::getName).toList());
        }
        return aggs;
    }

    public AggregationDataExtractorContext getContext() {
        return this.context;
    }
}

