/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.aggs.categorization;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class CategorizationPartOfSpeechDictionary {
    static final String DICTIONARY_FILE_PATH = "/org/elasticsearch/xpack/ml/aggs/categorization/ml-en.dict";
    static final String PART_OF_SPEECH_SEPARATOR = "@";
    private static CategorizationPartOfSpeechDictionary instance;
    private static final Object INIT_LOCK;
    private final Map<String, PartOfSpeech> partOfSpeechDictionary = new HashMap<String, PartOfSpeech>();
    private final int maxDictionaryWordLength;

    CategorizationPartOfSpeechDictionary(InputStream is) throws IOException {
        String line;
        int maxLength = 0;
        BufferedReader reader = new BufferedReader(new InputStreamReader(is, StandardCharsets.UTF_8));
        while ((line = reader.readLine()) != null) {
            if ((line = line.trim()).isEmpty()) continue;
            String[] split = line.split(PART_OF_SPEECH_SEPARATOR);
            if (split.length != 2) {
                throw new IllegalArgumentException("Unexpected format in line [" + line + "]: expected one [@] separator");
            }
            if (split[0].isEmpty()) {
                throw new IllegalArgumentException("Unexpected format in line [" + line + "]: nothing preceding [@] separator");
            }
            if (split[1].isEmpty()) {
                throw new IllegalArgumentException("Unexpected format in line [" + line + "]: nothing following [@] separator");
            }
            String lowerCaseWord = split[0].toLowerCase(Locale.ROOT);
            this.partOfSpeechDictionary.put(lowerCaseWord, PartOfSpeech.fromCode(split[1].charAt(0)));
            maxLength = Math.max(maxLength, lowerCaseWord.length());
        }
        this.maxDictionaryWordLength = maxLength;
    }

    public PartOfSpeech getPartOfSpeech(String word) {
        if (word.length() > this.maxDictionaryWordLength) {
            return PartOfSpeech.NOT_IN_DICTIONARY;
        }
        return this.partOfSpeechDictionary.getOrDefault(word.toLowerCase(Locale.ROOT), PartOfSpeech.NOT_IN_DICTIONARY);
    }

    public boolean isInDictionary(String word) {
        return this.getPartOfSpeech(word) != PartOfSpeech.NOT_IN_DICTIONARY;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CategorizationPartOfSpeechDictionary getInstance() throws IOException {
        if (instance != null) {
            return instance;
        }
        Object object = INIT_LOCK;
        synchronized (object) {
            if (instance == null) {
                try (InputStream is = CategorizationPartOfSpeechDictionary.class.getResourceAsStream(DICTIONARY_FILE_PATH);){
                    instance = new CategorizationPartOfSpeechDictionary(is);
                }
            }
            return instance;
        }
    }

    static {
        INIT_LOCK = new Object();
    }

    public static enum PartOfSpeech {
        NOT_IN_DICTIONARY('\u0000'),
        UNKNOWN('?'),
        NOUN('N'),
        PLURAL('p'),
        VERB('V'),
        ADJECTIVE('A'),
        ADVERB('v'),
        CONJUNCTION('C'),
        PREPOSITION('P'),
        INTERJECTION('!'),
        PRONOUN('r'),
        DEFINITE_ARTICLE('D'),
        INDEFINITE_ARTICLE('I');

        private final char code;
        private static final Map<Character, PartOfSpeech> CODE_MAPPING;

        private PartOfSpeech(char code) {
            this.code = code;
        }

        char getCode() {
            return this.code;
        }

        static PartOfSpeech fromCode(char partOfSpeechCode) {
            PartOfSpeech pos = CODE_MAPPING.get(Character.valueOf(partOfSpeechCode));
            if (pos == null) {
                throw new IllegalArgumentException("Unknown part-of-speech code [" + partOfSpeechCode + "]");
            }
            return pos;
        }

        static {
            CODE_MAPPING = Stream.concat(Map.of(Character.valueOf('h'), NOUN, Character.valueOf('o'), NOUN, Character.valueOf('t'), VERB, Character.valueOf('i'), VERB).entrySet().stream(), Stream.of(PartOfSpeech.values()).collect(Collectors.toMap(PartOfSpeech::getCode, Function.identity())).entrySet().stream()).collect(Collectors.toUnmodifiableMap(Map.Entry::getKey, Map.Entry::getValue));
        }
    }
}

