/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.action;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.ElasticsearchStatusException;
import org.elasticsearch.ResourceAlreadyExistsException;
import org.elasticsearch.ResourceNotFoundException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.action.support.master.TransportMasterNodeAction;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.client.internal.OriginSettingClient;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.document.DocumentField;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.core.Strings;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.core.Tuple;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.license.LicenseUtils;
import org.elasticsearch.license.XPackLicenseState;
import org.elasticsearch.persistent.PersistentTasksCustomMetadata;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.sort.FieldSortBuilder;
import org.elasticsearch.search.sort.SortBuilder;
import org.elasticsearch.search.sort.SortBuilders;
import org.elasticsearch.search.sort.SortOrder;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.tasks.TaskInfo;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xcontent.NamedXContentRegistry;
import org.elasticsearch.xpack.core.ml.MachineLearningField;
import org.elasticsearch.xpack.core.ml.action.CreateTrainedModelAssignmentAction;
import org.elasticsearch.xpack.core.ml.action.GetTrainedModelsAction;
import org.elasticsearch.xpack.core.ml.action.StartTrainedModelDeploymentAction;
import org.elasticsearch.xpack.core.ml.inference.TrainedModelConfig;
import org.elasticsearch.xpack.core.ml.inference.TrainedModelType;
import org.elasticsearch.xpack.core.ml.inference.assignment.AllocationStatus;
import org.elasticsearch.xpack.core.ml.inference.assignment.RoutingInfo;
import org.elasticsearch.xpack.core.ml.inference.assignment.RoutingState;
import org.elasticsearch.xpack.core.ml.inference.assignment.TrainedModelAssignment;
import org.elasticsearch.xpack.core.ml.inference.persistence.InferenceIndexConstants;
import org.elasticsearch.xpack.core.ml.inference.trainedmodel.IndexLocation;
import org.elasticsearch.xpack.core.ml.job.messages.Messages;
import org.elasticsearch.xpack.core.ml.utils.ExceptionsHelper;
import org.elasticsearch.xpack.core.ml.utils.TransportVersionUtils;
import org.elasticsearch.xpack.ml.inference.assignment.TrainedModelAssignmentMetadata;
import org.elasticsearch.xpack.ml.inference.assignment.TrainedModelAssignmentService;
import org.elasticsearch.xpack.ml.inference.persistence.TrainedModelDefinitionDoc;
import org.elasticsearch.xpack.ml.notifications.InferenceAuditor;
import org.elasticsearch.xpack.ml.process.MlMemoryTracker;
import org.elasticsearch.xpack.ml.utils.TaskRetriever;

public class TransportStartTrainedModelDeploymentAction
extends TransportMasterNodeAction<StartTrainedModelDeploymentAction.Request, CreateTrainedModelAssignmentAction.Response> {
    private static final Logger logger = LogManager.getLogger(TransportStartTrainedModelDeploymentAction.class);
    private final XPackLicenseState licenseState;
    private final OriginSettingClient client;
    private final TrainedModelAssignmentService trainedModelAssignmentService;
    private final MlMemoryTracker memoryTracker;
    private final InferenceAuditor auditor;

    @Inject
    public TransportStartTrainedModelDeploymentAction(TransportService transportService, Client client, ClusterService clusterService, ThreadPool threadPool, ActionFilters actionFilters, XPackLicenseState licenseState, IndexNameExpressionResolver indexNameExpressionResolver, TrainedModelAssignmentService trainedModelAssignmentService, NamedXContentRegistry xContentRegistry, MlMemoryTracker memoryTracker, InferenceAuditor auditor) {
        super("cluster:admin/xpack/ml/trained_models/deployment/start", transportService, clusterService, threadPool, actionFilters, StartTrainedModelDeploymentAction.Request::new, indexNameExpressionResolver, CreateTrainedModelAssignmentAction.Response::new, (Executor)EsExecutors.DIRECT_EXECUTOR_SERVICE);
        this.licenseState = Objects.requireNonNull(licenseState);
        this.client = new OriginSettingClient(Objects.requireNonNull(client), "ml");
        this.memoryTracker = Objects.requireNonNull(memoryTracker);
        this.trainedModelAssignmentService = Objects.requireNonNull(trainedModelAssignmentService);
        this.auditor = Objects.requireNonNull(auditor);
    }

    protected void masterOperation(Task task, StartTrainedModelDeploymentAction.Request request, ClusterState state, ActionListener<CreateTrainedModelAssignmentAction.Response> listener) throws Exception {
        logger.debug(() -> "[" + request.getDeploymentId() + "] received deploy request for model [" + request.getModelId() + "]");
        if (!MachineLearningField.ML_API_FEATURE.check(this.licenseState)) {
            listener.onFailure((Exception)LicenseUtils.newComplianceException((String)"ml"));
            return;
        }
        if (!TransportVersionUtils.isMinTransportVersionSameAsCurrent((ClusterState)state)) {
            listener.onFailure((Exception)((Object)new ElasticsearchStatusException("Cannot start model deployment [{}] while cluster upgrade is in progress.", RestStatus.FORBIDDEN, new Object[]{request.getDeploymentId()})));
            return;
        }
        TrainedModelAssignmentMetadata assignments = TrainedModelAssignmentMetadata.fromState(state);
        if (assignments.allAssignments().size() >= 100) {
            listener.onFailure((Exception)((Object)new ElasticsearchStatusException("Could not start model deployment because existing deployments reached the limit of [{}]", RestStatus.TOO_MANY_REQUESTS, new Object[]{100})));
            return;
        }
        if (assignments.getDeploymentAssignment(request.getDeploymentId()) != null) {
            listener.onFailure((Exception)((Object)new ElasticsearchStatusException("Could not start model deployment because an existing deployment with the same id [{}] exist", RestStatus.BAD_REQUEST, new Object[]{request.getDeploymentId()})));
            return;
        }
        AtomicLong perDeploymentMemoryBytes = new AtomicLong();
        AtomicLong perAllocationMemoryBytes = new AtomicLong();
        ActionListener waitForDeploymentToStart = ActionListener.wrap(modelAssignment -> this.waitForDeploymentState(request.getDeploymentId(), request.getTimeout(), request.getWaitForState(), listener), e -> {
            logger.warn(() -> "[" + request.getDeploymentId() + "] creating new assignment for model [" + request.getModelId() + "] failed", e);
            if (ExceptionsHelper.unwrapCause((Throwable)e) instanceof ResourceAlreadyExistsException) {
                e = new ElasticsearchStatusException("Cannot start deployment [{}] because it has already been started", RestStatus.CONFLICT, e, new Object[]{request.getDeploymentId()});
            }
            listener.onFailure((Exception)e);
        });
        ActionListener modelSizeListener = ActionListener.wrap(modelIdAndSizeInBytes -> {
            StartTrainedModelDeploymentAction.TaskParams taskParams = new StartTrainedModelDeploymentAction.TaskParams((String)modelIdAndSizeInBytes.v1(), request.getDeploymentId(), ((Long)modelIdAndSizeInBytes.v2()).longValue(), request.getNumberOfAllocations(), request.getThreadsPerAllocation(), request.getQueueCapacity(), Optional.ofNullable(request.getCacheSize()).orElse(ByteSizeValue.ofBytes((long)((Long)modelIdAndSizeInBytes.v2()))), request.getPriority(), perDeploymentMemoryBytes.get(), perAllocationMemoryBytes.get());
            PersistentTasksCustomMetadata persistentTasks = (PersistentTasksCustomMetadata)this.clusterService.state().getMetadata().custom("persistent_tasks");
            this.memoryTracker.refresh(persistentTasks, (ActionListener<Void>)ActionListener.wrap(aVoid -> this.trainedModelAssignmentService.createNewModelAssignment(taskParams, (ActionListener<CreateTrainedModelAssignmentAction.Response>)waitForDeploymentToStart), arg_0 -> ((ActionListener)listener).onFailure(arg_0)));
        }, arg_0 -> listener.onFailure(arg_0));
        ActionListener getModelListener = ActionListener.wrap(getModelResponse -> {
            if (getModelResponse.getResources().results().size() > 1) {
                listener.onFailure((Exception)((Object)ExceptionsHelper.badRequestException((String)"cannot deploy more than one models at the same time; [{}] matches [{}] models]", (Object[])new Object[]{request.getModelId(), getModelResponse.getResources().results().size()})));
                return;
            }
            TrainedModelConfig trainedModelConfig = (TrainedModelConfig)getModelResponse.getResources().results().get(0);
            if (trainedModelConfig.getModelType() != TrainedModelType.PYTORCH) {
                listener.onFailure((Exception)((Object)ExceptionsHelper.badRequestException((String)"model [{}] of type [{}] cannot be deployed. Only PyTorch models can be deployed", (Object[])new Object[]{trainedModelConfig.getModelId(), trainedModelConfig.getModelType()})));
                return;
            }
            perDeploymentMemoryBytes.set(trainedModelConfig.getPerDeploymentMemoryBytes());
            perAllocationMemoryBytes.set(trainedModelConfig.getPerAllocationMemoryBytes());
            if (trainedModelConfig.getLocation() == null) {
                listener.onFailure((Exception)((Object)ExceptionsHelper.serverError((String)"model [{}] does not have location", (Object[])new Object[]{trainedModelConfig.getModelId()})));
                return;
            }
            if (!request.getModelId().equals(request.getDeploymentId())) {
                GetTrainedModelsAction.Request getModelWithDeploymentId = new GetTrainedModelsAction.Request(request.getDeploymentId());
                this.client.execute((ActionType)GetTrainedModelsAction.INSTANCE, (ActionRequest)getModelWithDeploymentId, ActionListener.wrap(response -> listener.onFailure((Exception)((Object)ExceptionsHelper.badRequestException((String)"Deployment id [{}] is the same as an another model which is not the model being deployed. Deployment id can be the same as the model being deployed but cannot match a different model", (Object[])new Object[]{request.getDeploymentId(), request.getModelId()}))), error -> {
                    if (ExceptionsHelper.unwrapCause((Throwable)error) instanceof ResourceNotFoundException) {
                        TransportStartTrainedModelDeploymentAction.checkFullModelDefinitionIsPresent(this.client, trainedModelConfig, true, request.getTimeout(), (ActionListener<Tuple<String, Long>>)modelSizeListener);
                    } else {
                        listener.onFailure(error);
                    }
                }));
            } else {
                TransportStartTrainedModelDeploymentAction.checkFullModelDefinitionIsPresent(this.client, trainedModelConfig, true, request.getTimeout(), (ActionListener<Tuple<String, Long>>)modelSizeListener);
            }
        }, arg_0 -> listener.onFailure(arg_0));
        GetTrainedModelsAction.Request getModelRequest = new GetTrainedModelsAction.Request(request.getModelId());
        this.client.execute((ActionType)GetTrainedModelsAction.INSTANCE, (ActionRequest)getModelRequest, getModelListener);
    }

    private void waitForDeploymentState(final String deploymentId, TimeValue timeout, AllocationStatus.State state, final ActionListener<CreateTrainedModelAssignmentAction.Response> listener) {
        final DeploymentStartedPredicate predicate = new DeploymentStartedPredicate(deploymentId, state);
        this.trainedModelAssignmentService.waitForAssignmentCondition(deploymentId, predicate, timeout, new TrainedModelAssignmentService.WaitForAssignmentListener(){

            public void onResponse(TrainedModelAssignment assignment) {
                if (predicate.exception != null) {
                    TransportStartTrainedModelDeploymentAction.this.deleteFailedDeployment(deploymentId, predicate.exception, (ActionListener<CreateTrainedModelAssignmentAction.Response>)listener);
                } else {
                    TransportStartTrainedModelDeploymentAction.this.auditor.info(assignment.getDeploymentId(), "Started deployment");
                    listener.onResponse((Object)new CreateTrainedModelAssignmentAction.Response(assignment));
                }
            }

            public void onFailure(Exception e) {
                listener.onFailure(e);
            }
        });
    }

    private void deleteFailedDeployment(String deploymentId, Exception exception, ActionListener<CreateTrainedModelAssignmentAction.Response> listener) {
        logger.trace(() -> Strings.format((String)"[%s] Deleting failed deployment", (Object[])new Object[]{deploymentId}), (Throwable)exception);
        this.trainedModelAssignmentService.deleteModelAssignment(deploymentId, (ActionListener<AcknowledgedResponse>)ActionListener.wrap(pTask -> listener.onFailure(exception), e -> {
            logger.error(() -> Strings.format((String)"[%s] Failed to delete model allocation that had failed with the reason [%s]", (Object[])new Object[]{deploymentId, exception.getMessage()}), (Throwable)e);
            listener.onFailure(exception);
        }));
    }

    static void checkFullModelDefinitionIsPresent(OriginSettingClient mlOriginClient, TrainedModelConfig config, boolean errorIfDefinitionIsMissing, TimeValue timeout, ActionListener<Tuple<String, Long>> listener) {
        if (!(config.getLocation() instanceof IndexLocation)) {
            listener.onResponse(null);
            return;
        }
        String modelId = config.getModelId();
        String index = ((IndexLocation)config.getLocation()).getIndexName();
        ActionListener<SearchResponse> step3SearchResultsVerificationListener = TransportStartTrainedModelDeploymentAction.step3VerifyModelPartsArePresent(errorIfDefinitionIsMissing, listener, modelId);
        ActionListener<Runnable> step2DocsSearchListener = TransportStartTrainedModelDeploymentAction.step2SearchForModelParts(mlOriginClient, listener, index, modelId, step3SearchResultsVerificationListener);
        TransportStartTrainedModelDeploymentAction.step1CheckForDownloadTask(mlOriginClient, errorIfDefinitionIsMissing, timeout, listener, modelId, step2DocsSearchListener);
    }

    private static ActionListener<SearchResponse> step3VerifyModelPartsArePresent(boolean errorIfDefinitionIsMissing, ActionListener<Tuple<String, Long>> listener, String modelId) {
        return ActionListener.wrap(response -> {
            Object patt20294$temp;
            SearchHit[] hits = response.getHits().getHits();
            if (hits.length == 0) {
                TransportStartTrainedModelDeploymentAction.failOrRespondWith0(() -> new ResourceNotFoundException(Messages.getMessage((String)"Could not find trained model definition [{0}]", (Object[])new Object[]{modelId}), new Object[0]), errorIfDefinitionIsMissing, modelId, listener);
                return;
            }
            DocumentField firstTotalLengthField = hits[0].field(TrainedModelDefinitionDoc.TOTAL_DEFINITION_LENGTH.getPreferredName());
            if (firstTotalLengthField == null || !((patt20294$temp = firstTotalLengthField.getValue()) instanceof Long)) {
                TransportStartTrainedModelDeploymentAction.failOrRespondWith0(() -> TransportStartTrainedModelDeploymentAction.missingFieldsError(modelId, hits[0].getId(), List.of(TrainedModelDefinitionDoc.TOTAL_DEFINITION_LENGTH.getPreferredName())), errorIfDefinitionIsMissing, modelId, listener);
                return;
            }
            Long firstTotalDefinitionLength = (Long)patt20294$temp;
            long firstTotalLength = firstTotalDefinitionLength;
            HashSet<String> missingFields = new HashSet<String>();
            long summedLengths = 0L;
            for (SearchHit hit : hits) {
                Object patt21714$temp;
                Object patt21248$temp;
                long totalLength = -1L;
                DocumentField totalLengthField = hit.field(TrainedModelDefinitionDoc.TOTAL_DEFINITION_LENGTH.getPreferredName());
                if (totalLengthField != null && (patt21248$temp = totalLengthField.getValue()) instanceof Long) {
                    Long totalDefinitionLength = (Long)patt21248$temp;
                    totalLength = totalDefinitionLength;
                } else {
                    missingFields.add(TrainedModelDefinitionDoc.TOTAL_DEFINITION_LENGTH.getPreferredName());
                }
                DocumentField definitionLengthField = hit.field(TrainedModelDefinitionDoc.DEFINITION_LENGTH.getPreferredName());
                if (definitionLengthField != null && (patt21714$temp = definitionLengthField.getValue()) instanceof Long) {
                    Long definitionLength = (Long)patt21714$temp;
                    summedLengths += definitionLength.longValue();
                } else {
                    missingFields.add(TrainedModelDefinitionDoc.DEFINITION_LENGTH.getPreferredName());
                }
                if (!missingFields.isEmpty()) {
                    TransportStartTrainedModelDeploymentAction.failOrRespondWith0(() -> TransportStartTrainedModelDeploymentAction.missingFieldsError(modelId, hit.getId(), missingFields), errorIfDefinitionIsMissing, modelId, listener);
                    return;
                }
                if (totalLength == firstTotalLength) continue;
                long finalTotalLength = totalLength;
                TransportStartTrainedModelDeploymentAction.failOrRespondWith0(() -> ExceptionsHelper.badRequestException((String)"[{}] [total_definition_length] must be the same in all model definition parts. The value [{}] in model definition part [{}] does not match the value [{}] in part [{}]. Unable to deploy model, please delete and recreate the model definition", (Object[])new Object[]{modelId, finalTotalLength, TrainedModelDefinitionDoc.docNum(modelId, Objects.requireNonNull(hit.getId())), firstTotalLength, TrainedModelDefinitionDoc.docNum(modelId, Objects.requireNonNull(hits[0].getId()))}), errorIfDefinitionIsMissing, modelId, listener);
                return;
            }
            if (summedLengths != firstTotalLength) {
                TransportStartTrainedModelDeploymentAction.failOrRespondWith0(() -> ExceptionsHelper.badRequestException((String)Messages.getMessage((String)"Model definition truncated. Unable to deserialize trained model definition [{0}]", (Object[])new Object[]{modelId}), (Object[])new Object[0]), errorIfDefinitionIsMissing, modelId, listener);
                return;
            }
            listener.onResponse((Object)new Tuple((Object)modelId, (Object)summedLengths));
        }, e -> {
            if (ExceptionsHelper.unwrapCause((Throwable)e) instanceof ResourceNotFoundException) {
                TransportStartTrainedModelDeploymentAction.failOrRespondWith0(() -> {
                    ResourceNotFoundException ex = new ResourceNotFoundException(Messages.getMessage((String)"Could not find trained model definition [{0}]", (Object[])new Object[]{modelId}), new Object[0]);
                    ex.addSuppressed((Throwable)e);
                    return ex;
                }, errorIfDefinitionIsMissing, modelId, listener);
            } else {
                listener.onFailure(e);
            }
        });
    }

    private static ActionListener<Runnable> step2SearchForModelParts(OriginSettingClient mlOriginClient, ActionListener<Tuple<String, Long>> listener, String index, String modelId, ActionListener<SearchResponse> nextStepListener) {
        return ActionListener.wrap(r -> mlOriginClient.prepareSearch(new String[]{index}).setQuery((QueryBuilder)QueryBuilders.constantScoreQuery((QueryBuilder)QueryBuilders.boolQuery().filter((QueryBuilder)QueryBuilders.termQuery((String)TrainedModelConfig.MODEL_ID.getPreferredName(), (String)modelId)).filter((QueryBuilder)QueryBuilders.termQuery((String)InferenceIndexConstants.DOC_TYPE.getPreferredName(), (String)"trained_model_definition_doc")))).setFetchSource(false).addDocValueField(TrainedModelDefinitionDoc.DEFINITION_LENGTH.getPreferredName()).addDocValueField(TrainedModelDefinitionDoc.TOTAL_DEFINITION_LENGTH.getPreferredName()).setSize(10000).setTrackTotalHits(true).addSort((SortBuilder)((FieldSortBuilder)SortBuilders.fieldSort((String)TrainedModelDefinitionDoc.DOC_NUM.getPreferredName()).order(SortOrder.ASC)).unmappedType("long")).execute(nextStepListener), arg_0 -> listener.onFailure(arg_0));
    }

    private static void step1CheckForDownloadTask(OriginSettingClient mlOriginClient, boolean errorIfDefinitionIsMissing, TimeValue timeout, ActionListener<Tuple<String, Long>> failureListener, String modelId, ActionListener<Runnable> nextStepListener) {
        TaskRetriever.getDownloadTaskInfo((Client)mlOriginClient, modelId, timeout != null, timeout, () -> Messages.getMessage((String)"Model download task is currently running. Wait for trained model [{0}] download task to complete then try again", (Object[])new Object[]{modelId}), (ActionListener<TaskInfo>)ActionListener.wrap(taskInfo -> {
            if (taskInfo == null) {
                nextStepListener.onResponse(null);
            } else {
                TransportStartTrainedModelDeploymentAction.failOrRespondWith0(() -> new ElasticsearchStatusException(Messages.getMessage((String)"Model download task is currently running. Wait for trained model [{0}] download task to complete then try again", (Object[])new Object[]{modelId}), RestStatus.REQUEST_TIMEOUT, new Object[0]), errorIfDefinitionIsMissing, modelId, failureListener);
            }
        }, arg_0 -> failureListener.onFailure(arg_0)));
    }

    private static void failOrRespondWith0(Supplier<Exception> exceptionSupplier, boolean errorIfDefinitionIsMissing, String modelId, ActionListener<Tuple<String, Long>> listener) {
        if (errorIfDefinitionIsMissing) {
            listener.onFailure(exceptionSupplier.get());
        } else {
            listener.onResponse((Object)new Tuple((Object)modelId, (Object)0L));
        }
    }

    protected ClusterBlockException checkBlock(StartTrainedModelDeploymentAction.Request request, ClusterState state) {
        return state.blocks().globalBlockedException(ClusterBlockLevel.METADATA_WRITE);
    }

    private static ElasticsearchStatusException missingFieldsError(String modelId, String hitId, Collection<String> missingFields) {
        return ExceptionsHelper.badRequestException((String)"[{}] model definition [{}] is missing required fields {}. {}", (Object[])new Object[]{modelId, hitId, missingFields, "Unable to deploy model, please delete and recreate the model definition"});
    }

    static Set<String> nodesShuttingDown(ClusterState state) {
        return state.metadata().nodeShutdowns().getAllNodeIds();
    }

    private static class DeploymentStartedPredicate
    implements Predicate<ClusterState> {
        private volatile Exception exception;
        private final String deploymentId;
        private final AllocationStatus.State waitForState;

        DeploymentStartedPredicate(String deploymentId, AllocationStatus.State waitForState) {
            this.deploymentId = (String)ExceptionsHelper.requireNonNull((Object)deploymentId, (String)"deployment_id");
            this.waitForState = waitForState;
        }

        @Override
        public boolean test(ClusterState clusterState) {
            TrainedModelAssignment trainedModelAssignment = TrainedModelAssignmentMetadata.assignmentForDeploymentId(clusterState, this.deploymentId).orElse(null);
            if (trainedModelAssignment == null) {
                logger.trace(() -> Strings.format((String)"[%s] assignment was null while waiting for state [%s]", (Object[])new Object[]{this.deploymentId, this.waitForState}));
                return true;
            }
            Set nodeIdsAndRouting = trainedModelAssignment.getNodeRoutingTable().entrySet();
            HashMap<String, String> nodeFailuresAndReasons = new HashMap<String, String>();
            LinkedHashSet<String> nodesStillInitializing = new LinkedHashSet<String>();
            for (Map.Entry nodeIdAndRouting : nodeIdsAndRouting) {
                if (RoutingState.FAILED.equals((Object)((RoutingInfo)nodeIdAndRouting.getValue()).getState())) {
                    nodeFailuresAndReasons.put((String)nodeIdAndRouting.getKey(), ((RoutingInfo)nodeIdAndRouting.getValue()).getReason());
                }
                if (!RoutingState.STARTING.equals((Object)((RoutingInfo)nodeIdAndRouting.getValue()).getState())) continue;
                nodesStillInitializing.add((String)nodeIdAndRouting.getKey());
            }
            if (!nodeFailuresAndReasons.isEmpty()) {
                this.exception = new ElasticsearchStatusException("Could not start trained model deployment, the following nodes failed with errors [{}]", RestStatus.INTERNAL_SERVER_ERROR, new Object[]{nodeFailuresAndReasons});
                return true;
            }
            Set<String> nodesShuttingDown = TransportStartTrainedModelDeploymentAction.nodesShuttingDown(clusterState);
            List<DiscoveryNode> nodes = clusterState.nodes().stream().filter(d -> !nodesShuttingDown.contains(d.getId())).filter(StartTrainedModelDeploymentAction.TaskParams::mayAssignToNode).toList();
            AllocationStatus allocationStatus = trainedModelAssignment.calculateAllocationStatus().orElse(null);
            if (allocationStatus == null || allocationStatus.calculateState().compareTo((Enum)this.waitForState) >= 0) {
                return true;
            }
            if (nodesStillInitializing.isEmpty()) {
                return true;
            }
            logger.trace(() -> Strings.format((String)"[%s] tested with state [%s] and nodes %s still initializing", (Object[])new Object[]{this.deploymentId, trainedModelAssignment.getAssignmentState(), nodesStillInitializing}));
            return false;
        }
    }
}

