/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.action;

import java.util.Collections;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.FailedNodeException;
import org.elasticsearch.action.TaskOperationFailure;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.tasks.BaseTasksRequest;
import org.elasticsearch.action.support.tasks.TransportTasksAction;
import org.elasticsearch.cluster.node.DiscoveryNodes;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.persistent.PersistentTasksCustomMetadata;
import org.elasticsearch.tasks.CancellableTask;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.core.ml.MlTasks;
import org.elasticsearch.xpack.core.ml.action.KillProcessAction;
import org.elasticsearch.xpack.ml.job.task.JobTask;
import org.elasticsearch.xpack.ml.notifications.AnomalyDetectionAuditor;

public class TransportKillProcessAction
extends TransportTasksAction<JobTask, KillProcessAction.Request, KillProcessAction.Response, KillProcessAction.Response> {
    private static final Logger logger = LogManager.getLogger(TransportKillProcessAction.class);
    private final AnomalyDetectionAuditor auditor;

    @Inject
    public TransportKillProcessAction(TransportService transportService, ClusterService clusterService, ActionFilters actionFilters, AnomalyDetectionAuditor auditor) {
        super("cluster:internal/xpack/ml/job/kill/process", clusterService, transportService, actionFilters, KillProcessAction.Request::new, KillProcessAction.Response::new, KillProcessAction.Response::new, (Executor)transportService.getThreadPool().executor("ml_utility"));
        this.auditor = auditor;
    }

    protected KillProcessAction.Response newResponse(KillProcessAction.Request request, List<KillProcessAction.Response> tasks, List<TaskOperationFailure> taskOperationFailures, List<FailedNodeException> failedNodeExceptions) {
        ExceptionsHelper.rethrowAndSuppress(taskOperationFailures.stream().map(org.elasticsearch.xpack.core.ml.utils.ExceptionsHelper::taskOperationFailureToStatusException).collect(Collectors.toList()));
        ExceptionsHelper.rethrowAndSuppress(failedNodeExceptions);
        return new KillProcessAction.Response(true);
    }

    protected void taskOperation(CancellableTask actionTask, KillProcessAction.Request request, JobTask jobTask, ActionListener<KillProcessAction.Response> listener) {
        logger.info("[{}] Killing job", (Object)jobTask.getJobId());
        this.auditor.info(jobTask.getJobId(), "Killing job");
        try {
            jobTask.killJob("kill process (api)");
            listener.onResponse((Object)new KillProcessAction.Response(true));
        }
        catch (Exception e) {
            listener.onFailure(e);
        }
    }

    protected void doExecute(Task task, KillProcessAction.Request request, ActionListener<KillProcessAction.Response> listener) {
        PersistentTasksCustomMetadata.PersistentTask jobTask;
        DiscoveryNodes nodes = this.clusterService.state().nodes();
        PersistentTasksCustomMetadata tasks = (PersistentTasksCustomMetadata)this.clusterService.state().getMetadata().custom("persistent_tasks");
        List<Object> jobTasks = Strings.isAllOrWildcard((String)request.getJobId()) ? MlTasks.openJobTasks((PersistentTasksCustomMetadata)tasks).stream().filter(t -> t.getExecutorNode() != null).collect(Collectors.toList()) : ((jobTask = MlTasks.getJobTask((String)request.getJobId(), (PersistentTasksCustomMetadata)tasks)) == null || jobTask.getExecutorNode() == null ? Collections.emptyList() : Collections.singletonList(jobTask));
        if (jobTasks.isEmpty()) {
            logger.debug("[{}] Cannot kill the process because job(s) are not open", (Object)request.getJobId());
            listener.onResponse((Object)new KillProcessAction.Response(false));
            return;
        }
        if (jobTasks.stream().allMatch(t -> nodes.get(t.getExecutorNode()) == null)) {
            listener.onFailure((Exception)((Object)org.elasticsearch.xpack.core.ml.utils.ExceptionsHelper.conflictStatusException((String)"Cannot kill process for job {} asexecutor node {} cannot be found", (Object[])new Object[]{request.getJobId(), ((PersistentTasksCustomMetadata.PersistentTask)jobTasks.get(0)).getExecutorNode()})));
            return;
        }
        request.setNodes((String[])jobTasks.stream().filter(t -> t.getExecutorNode() != null && nodes.get(t.getExecutorNode()) != null).map(PersistentTasksCustomMetadata.PersistentTask::getExecutorNode).toArray(String[]::new));
        super.doExecute(task, (BaseTasksRequest)request, listener);
    }
}

