/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.telemetry.apm.internal.metrics;

import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.common.AttributesBuilder;
import java.util.Map;

class OtelHelper {
    OtelHelper() {
    }

    static Attributes fromMap(Map<String, Object> attributes) {
        if (attributes == null || attributes.isEmpty()) {
            return Attributes.empty();
        }
        AttributesBuilder builder = Attributes.builder();
        attributes.forEach((k, v) -> {
            if (v instanceof String) {
                String value = (String)v;
                builder.put(k, value);
            } else if (v instanceof Long) {
                Long value = (Long)v;
                builder.put(k, value.longValue());
            } else if (v instanceof Integer) {
                Integer value = (Integer)v;
                builder.put(k, (long)value.intValue());
            } else if (v instanceof Byte) {
                Byte value = (Byte)v;
                builder.put(k, (long)value.byteValue());
            } else if (v instanceof Short) {
                Short value = (Short)v;
                builder.put(k, (long)value.shortValue());
            } else if (v instanceof Double) {
                Double value = (Double)v;
                builder.put(k, value.doubleValue());
            } else if (v instanceof Float) {
                Float value = (Float)v;
                builder.put(k, (double)value.floatValue());
            } else if (v instanceof Boolean) {
                Boolean value = (Boolean)v;
                builder.put(k, value.booleanValue());
            } else {
                throw new IllegalArgumentException("attributes do not support value type of [" + v.getClass().getCanonicalName() + "]");
            }
        });
        return builder.build();
    }
}

