/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.util;

import com.fasterxml.jackson.annotation.JsonValue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;

public abstract class ExpandableStringEnum<T extends ExpandableStringEnum<T>> {
    private static final Map<Class<?>, ConcurrentHashMap<String, ? extends ExpandableStringEnum<?>>> VALUES = new ConcurrentHashMap();
    private String name;
    private Class<T> clazz;

    @Deprecated
    public ExpandableStringEnum() {
    }

    protected static <T extends ExpandableStringEnum<T>> T fromString(String name, Class<T> clazz) {
        if (name == null) {
            return null;
        }
        ConcurrentHashMap clazzValues = VALUES.computeIfAbsent(clazz, key -> new ConcurrentHashMap());
        ExpandableStringEnum value = (ExpandableStringEnum)clazzValues.get(name);
        if (value != null) {
            return (T)value;
        }
        try {
            value = (ExpandableStringEnum)clazz.newInstance();
            return (T)value.nameAndAddValue(name, value, clazz);
        }
        catch (IllegalAccessException | InstantiationException ex) {
            return null;
        }
    }

    T nameAndAddValue(String name, T value, Class<T> clazz) {
        this.name = name;
        this.clazz = clazz;
        VALUES.get(clazz).put(name, (ExpandableStringEnum<?>)value);
        return (T)this;
    }

    protected static <T extends ExpandableStringEnum<T>> Collection<T> values(Class<T> clazz) {
        return new ArrayList(VALUES.getOrDefault(clazz, new ConcurrentHashMap()).values());
    }

    @JsonValue
    public String toString() {
        return this.name;
    }

    public int hashCode() {
        return Objects.hash(this.clazz, this.name);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.clazz == null || !this.clazz.isAssignableFrom(obj.getClass())) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (this.name == null) {
            return ((ExpandableStringEnum)obj).name == null;
        }
        return this.name.equals(((ExpandableStringEnum)obj).name);
    }
}

