/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.shutdown;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.master.TransportMasterNodeAction;
import org.elasticsearch.cluster.ClusterInfoService;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.metadata.LifecycleExecutionState;
import org.elasticsearch.cluster.metadata.NodesShutdownMetadata;
import org.elasticsearch.cluster.metadata.ShutdownPersistentTasksStatus;
import org.elasticsearch.cluster.metadata.ShutdownPluginsStatus;
import org.elasticsearch.cluster.metadata.ShutdownShardMigrationStatus;
import org.elasticsearch.cluster.metadata.SingleNodeShutdownMetadata;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.cluster.routing.ShardRoutingState;
import org.elasticsearch.cluster.routing.allocation.AllocationDecision;
import org.elasticsearch.cluster.routing.allocation.AllocationService;
import org.elasticsearch.cluster.routing.allocation.RoutingAllocation;
import org.elasticsearch.cluster.routing.allocation.ShardAllocationDecision;
import org.elasticsearch.cluster.routing.allocation.decider.AllocationDeciders;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.xcontent.ChunkedToXContent;
import org.elasticsearch.core.Strings;
import org.elasticsearch.core.Tuple;
import org.elasticsearch.shutdown.PluginShutdownService;
import org.elasticsearch.snapshots.SnapshotsInfoService;
import org.elasticsearch.tasks.CancellableTask;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.transport.Transports;
import org.elasticsearch.xpack.core.ilm.LifecycleOperationMetadata;
import org.elasticsearch.xpack.core.ilm.OperationMode;
import org.elasticsearch.xpack.shutdown.GetShutdownStatusAction;
import org.elasticsearch.xpack.shutdown.SingleNodeShutdownStatus;

public class TransportGetShutdownStatusAction
extends TransportMasterNodeAction<GetShutdownStatusAction.Request, GetShutdownStatusAction.Response> {
    private static final Logger logger = LogManager.getLogger(TransportGetShutdownStatusAction.class);
    private final AllocationDeciders allocationDeciders;
    private final AllocationService allocationService;
    private final ClusterInfoService clusterInfoService;
    private final SnapshotsInfoService snapshotsInfoService;
    private final PluginShutdownService pluginShutdownService;

    @Inject
    public TransportGetShutdownStatusAction(TransportService transportService, ClusterService clusterService, ThreadPool threadPool, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, AllocationService allocationService, AllocationDeciders allocationDeciders, ClusterInfoService clusterInfoService, SnapshotsInfoService snapshotsInfoService, PluginShutdownService pluginShutdownService) {
        super("cluster:admin/shutdown/get", transportService, clusterService, threadPool, actionFilters, GetShutdownStatusAction.Request::readFrom, indexNameExpressionResolver, GetShutdownStatusAction.Response::new, (Executor)threadPool.executor("management"));
        this.allocationService = allocationService;
        this.allocationDeciders = allocationDeciders;
        this.clusterInfoService = clusterInfoService;
        this.snapshotsInfoService = snapshotsInfoService;
        this.pluginShutdownService = pluginShutdownService;
    }

    protected void masterOperation(Task task, GetShutdownStatusAction.Request request, ClusterState state, ActionListener<GetShutdownStatusAction.Response> listener) {
        GetShutdownStatusAction.Response response;
        CancellableTask cancellableTask = (CancellableTask)task;
        NodesShutdownMetadata nodesShutdownMetadata = (NodesShutdownMetadata)state.metadata().custom("node_shutdown");
        if (nodesShutdownMetadata == null) {
            response = new GetShutdownStatusAction.Response(new ArrayList<SingleNodeShutdownStatus>());
        } else if (request.getNodeIds().length == 0) {
            List<SingleNodeShutdownStatus> shutdownStatuses = nodesShutdownMetadata.getAll().values().stream().map(ns -> new SingleNodeShutdownStatus((SingleNodeShutdownMetadata)ns, TransportGetShutdownStatusAction.shardMigrationStatus(cancellableTask, state, ns.getNodeId(), ns.getType(), ns.getNodeSeen(), this.clusterInfoService, this.snapshotsInfoService, this.allocationService, this.allocationDeciders), new ShutdownPersistentTasksStatus(), new ShutdownPluginsStatus(this.pluginShutdownService.readyToShutdown(ns.getNodeId(), ns.getType())))).collect(Collectors.toList());
            response = new GetShutdownStatusAction.Response(shutdownStatuses);
        } else {
            new ArrayList();
            List<SingleNodeShutdownStatus> shutdownStatuses = Arrays.stream(request.getNodeIds()).map(arg_0 -> ((NodesShutdownMetadata)nodesShutdownMetadata).get(arg_0)).filter(Objects::nonNull).map(ns -> new SingleNodeShutdownStatus((SingleNodeShutdownMetadata)ns, TransportGetShutdownStatusAction.shardMigrationStatus(cancellableTask, state, ns.getNodeId(), ns.getType(), ns.getNodeSeen(), this.clusterInfoService, this.snapshotsInfoService, this.allocationService, this.allocationDeciders), new ShutdownPersistentTasksStatus(), new ShutdownPluginsStatus(this.pluginShutdownService.readyToShutdown(ns.getNodeId(), ns.getType())))).collect(Collectors.toList());
            response = new GetShutdownStatusAction.Response(shutdownStatuses);
        }
        listener.onResponse((Object)response);
    }

    static ShutdownShardMigrationStatus shardMigrationStatus(CancellableTask cancellableTask, ClusterState currentState, String nodeId, SingleNodeShutdownMetadata.Type shutdownType, boolean nodeSeen, ClusterInfoService clusterInfoService, SnapshotsInfoService snapshotsInfoService, AllocationService allocationService, AllocationDeciders allocationDeciders) {
        assert (Transports.assertNotTransportThread((String)"doing O(#shards) work must be forked"));
        if (SingleNodeShutdownMetadata.Type.RESTART.equals((Object)shutdownType)) {
            return new ShutdownShardMigrationStatus(SingleNodeShutdownMetadata.Status.COMPLETE, 0L, "no shard relocation is necessary for a node restart", null);
        }
        if (currentState.nodes().get(nodeId) == null && !nodeSeen) {
            return new ShutdownShardMigrationStatus(SingleNodeShutdownMetadata.Status.NOT_STARTED, 0L, "node is not currently part of the cluster", null);
        }
        RoutingAllocation allocation = new RoutingAllocation(allocationDeciders, currentState, clusterInfoService.getClusterInfo(), snapshotsInfoService.snapshotShardSizes(), System.nanoTime());
        allocation.setDebugMode(RoutingAllocation.DebugMode.EXCLUDE_YES_DECISIONS);
        Set shuttingDownNodes = currentState.metadata().nodeShutdowns().getAll().keySet();
        List<ShardRouting> unassignedShards = currentState.getRoutingNodes().unassigned().stream().peek(s -> cancellableTask.ensureNotCancelled()).filter(s -> Objects.equals(s.unassignedInfo().getLastAllocatedNodeId(), nodeId)).filter(s -> s.primary() || !TransportGetShutdownStatusAction.hasShardCopyOnAnotherNode(currentState, s, shuttingDownNodes)).toList();
        if (!unassignedShards.isEmpty()) {
            ShardRouting shardRouting2 = unassignedShards.get(0);
            ShardAllocationDecision decision = allocationService.explainShardAllocation(shardRouting2, allocation);
            return new ShutdownShardMigrationStatus(SingleNodeShutdownMetadata.Status.STALLED, (long)unassignedShards.size(), Strings.format((String)"shard [%s] [%s] of index [%s] is unassigned, see [%s] for details or use the cluster allocation explain API", (Object[])new Object[]{shardRouting2.shardId().getId(), shardRouting2.primary() ? "primary" : "replica", shardRouting2.index().getName(), "node_allocation_decision"}), decision);
        }
        if (currentState.getRoutingNodes().node(nodeId) == null) {
            return new ShutdownShardMigrationStatus(SingleNodeShutdownMetadata.Status.COMPLETE, 0L, 0L, 0L);
        }
        int startedShards = currentState.getRoutingNodes().node(nodeId).numberOfShardsWithState(ShardRoutingState.STARTED);
        int relocatingShards = currentState.getRoutingNodes().node(nodeId).numberOfShardsWithState(ShardRoutingState.RELOCATING);
        int initializingShards = currentState.getRoutingNodes().node(nodeId).numberOfShardsWithState(ShardRoutingState.INITIALIZING);
        int totalRemainingShards = relocatingShards + startedShards + initializingShards;
        if (relocatingShards > 0 || totalRemainingShards == 0) {
            SingleNodeShutdownMetadata.Status shardStatus = totalRemainingShards == 0 ? SingleNodeShutdownMetadata.Status.COMPLETE : SingleNodeShutdownMetadata.Status.IN_PROGRESS;
            return new ShutdownShardMigrationStatus(shardStatus, (long)startedShards, (long)relocatingShards, (long)initializingShards);
        }
        if (initializingShards > 0 && relocatingShards == 0 && startedShards == 0) {
            return new ShutdownShardMigrationStatus(SingleNodeShutdownMetadata.Status.IN_PROGRESS, (long)startedShards, (long)relocatingShards, (long)initializingShards, "all remaining shards are currently INITIALIZING and must finish before they can be moved off this node");
        }
        AtomicInteger shardsToIgnoreForFinalStatus = new AtomicInteger(0);
        Optional<Tuple> unmovableShard = currentState.getRoutingNodes().node(nodeId).shardsWithState(ShardRoutingState.STARTED).peek(s -> cancellableTask.ensureNotCancelled()).map(shardRouting -> new Tuple(shardRouting, (Object)allocationService.explainShardAllocation(shardRouting, allocation))).filter(pair -> {
            assert (!((ShardAllocationDecision)pair.v2()).getMoveDecision().canRemain()) : "shard [" + pair + "] can remain on node [" + nodeId + "], but that node is shutting down";
            return !((ShardAllocationDecision)pair.v2()).getMoveDecision().canRemain();
        }).filter(pair -> !((ShardAllocationDecision)pair.v2()).getMoveDecision().getAllocationDecision().equals((Object)AllocationDecision.THROTTLED)).filter(pair -> !((ShardAllocationDecision)pair.v2()).getMoveDecision().getAllocationDecision().equals((Object)AllocationDecision.YES)).filter(pair -> {
            boolean hasShardCopyOnOtherNode = TransportGetShutdownStatusAction.hasShardCopyOnAnotherNode(currentState, (ShardRouting)pair.v1(), shuttingDownNodes);
            if (hasShardCopyOnOtherNode) {
                shardsToIgnoreForFinalStatus.incrementAndGet();
            }
            return !hasShardCopyOnOtherNode;
        }).filter(pair -> !TransportGetShutdownStatusAction.isIlmRestrictingShardMovement(currentState, (ShardRouting)pair.v1())).peek(pair -> logger.debug("node [{}] shutdown of type [{}] stalled: found shard [{}][{}] from index [{}] with negative decision: [{}]", (Object)nodeId, (Object)shutdownType, (Object)((ShardRouting)pair.v1()).getId(), (Object)(((ShardRouting)pair.v1()).primary() ? "primary" : "replica"), (Object)((ShardRouting)pair.v1()).shardId().getIndexName(), (Object)org.elasticsearch.common.Strings.toString((ChunkedToXContent)((ChunkedToXContent)pair.v2())))).findFirst();
        if (totalRemainingShards == shardsToIgnoreForFinalStatus.get() && unmovableShard.isEmpty()) {
            return new ShutdownShardMigrationStatus(SingleNodeShutdownMetadata.Status.COMPLETE, 0L, "[" + shardsToIgnoreForFinalStatus.get() + "] shards cannot be moved away from this node but have at least one copy on another node in the cluster", null);
        }
        if (unmovableShard.isPresent()) {
            ShardRouting shardRouting3 = (ShardRouting)unmovableShard.get().v1();
            ShardAllocationDecision decision = (ShardAllocationDecision)unmovableShard.get().v2();
            return new ShutdownShardMigrationStatus(SingleNodeShutdownMetadata.Status.STALLED, (long)totalRemainingShards, Strings.format((String)"shard [%s] [%s] of index [%s] cannot move, see [%s] for details or use the cluster allocation explain API", (Object[])new Object[]{shardRouting3.shardId().getId(), shardRouting3.primary() ? "primary" : "replica", shardRouting3.index().getName(), "node_allocation_decision"}), decision);
        }
        return new ShutdownShardMigrationStatus(SingleNodeShutdownMetadata.Status.IN_PROGRESS, (long)startedShards, (long)relocatingShards, (long)initializingShards);
    }

    private static boolean isIlmRestrictingShardMovement(ClusterState currentState, ShardRouting pair) {
        if (!OperationMode.STOPPED.equals((Object)LifecycleOperationMetadata.currentILMMode((ClusterState)currentState))) {
            boolean ilmWillMoveShardEventually;
            LifecycleExecutionState ilmState = currentState.metadata().index(pair.index()).getLifecycleExecutionState();
            boolean bl = ilmWillMoveShardEventually = ilmState != null && "shrink".equals(ilmState.action()) && !"ERROR".equals(ilmState.step());
            if (ilmWillMoveShardEventually) {
                logger.debug(Strings.format((String)"shard [%s] [%s] of index [%s] cannot move, but ILM is shrinking that index so assuming it will move", (Object[])new Object[]{pair.shardId().getId(), pair.primary() ? "primary" : "replica", pair.index().getName()}));
            }
            return ilmWillMoveShardEventually;
        }
        return false;
    }

    private static boolean hasShardCopyOnAnotherNode(ClusterState clusterState, ShardRouting shardRouting, Set<String> shuttingDownNodes) {
        return clusterState.routingTable().allShards(shardRouting.index().getName()).stream().filter(sr -> sr.id() == shardRouting.id()).filter(ShardRouting::started).anyMatch(routing -> !shuttingDownNodes.contains(routing.currentNodeId()));
    }

    protected ClusterBlockException checkBlock(GetShutdownStatusAction.Request request, ClusterState state) {
        return state.blocks().globalBlockedException(ClusterBlockLevel.METADATA_WRITE);
    }
}

