/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.downsample;

import java.io.IOException;
import java.util.Collection;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xpack.downsample.AbstractDownsampleFieldProducer;
import org.elasticsearch.xpack.downsample.DownsampleFieldSerializer;
import org.elasticsearch.xpack.downsample.LabelFieldProducer;
import org.elasticsearch.xpack.downsample.MetricFieldProducer;

public class AggregateMetricFieldSerializer
implements DownsampleFieldSerializer {
    private final Collection<AbstractDownsampleFieldProducer> producers;
    private final String name;

    public AggregateMetricFieldSerializer(String name, Collection<AbstractDownsampleFieldProducer> producers) {
        this.name = name;
        this.producers = producers;
    }

    @Override
    public void write(XContentBuilder builder) throws IOException {
        if (this.isEmpty()) {
            return;
        }
        builder.startObject(this.name);
        for (AbstractDownsampleFieldProducer fieldProducer : this.producers) {
            LabelFieldProducer labelFieldProducer;
            LabelFieldProducer.Label label;
            assert (this.name.equals(fieldProducer.name())) : "producer has a different name";
            if (fieldProducer.isEmpty()) continue;
            if (fieldProducer instanceof MetricFieldProducer) {
                MetricFieldProducer metricFieldProducer = (MetricFieldProducer)fieldProducer;
                for (MetricFieldProducer.Metric metric : metricFieldProducer.metrics()) {
                    if (metric.get() == null) continue;
                    builder.field(metric.name(), metric.get());
                }
                continue;
            }
            if (!(fieldProducer instanceof LabelFieldProducer) || (label = (labelFieldProducer = (LabelFieldProducer)fieldProducer).label()).get() == null) continue;
            builder.field(label.name(), label.get());
        }
        builder.endObject();
    }

    private boolean isEmpty() {
        for (AbstractDownsampleFieldProducer p : this.producers) {
            if (p.isEmpty()) continue;
            return false;
        }
        return true;
    }
}

