/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.transform.action;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Set;
import java.util.concurrent.Executor;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.HandledTransportAction;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.index.IndexService;
import org.elasticsearch.index.shard.IndexShard;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.indices.IndicesService;
import org.elasticsearch.tasks.CancellableTask;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.core.transform.action.GetCheckpointNodeAction;

public class TransportGetCheckpointNodeAction
extends HandledTransportAction<GetCheckpointNodeAction.Request, GetCheckpointNodeAction.Response> {
    private final IndicesService indicesService;

    @Inject
    public TransportGetCheckpointNodeAction(TransportService transportService, ActionFilters actionFilters, IndicesService indicesService) {
        super("indices:monitor/transform/checkpoint[n]", transportService, actionFilters, GetCheckpointNodeAction.Request::new, (Executor)EsExecutors.DIRECT_EXECUTOR_SERVICE);
        this.indicesService = indicesService;
    }

    protected void doExecute(Task task, GetCheckpointNodeAction.Request request, ActionListener<GetCheckpointNodeAction.Response> listener) {
        TransportGetCheckpointNodeAction.getGlobalCheckpoints(this.indicesService, task, request.getShards(), listener);
    }

    protected static void getGlobalCheckpoints(IndicesService indicesService, Task task, Set<ShardId> shards, ActionListener<GetCheckpointNodeAction.Response> listener) {
        HashMap<String, long[]> checkpointsByIndexOfThisNode = new HashMap<String, long[]>();
        for (ShardId shardId : shards) {
            if (task instanceof CancellableTask && ((CancellableTask)task).notifyIfCancelled(listener)) {
                return;
            }
            IndexService indexService = indicesService.indexServiceSafe(shardId.getIndex());
            IndexShard indexShard = indexService.getShard(shardId.id());
            checkpointsByIndexOfThisNode.computeIfAbsent(shardId.getIndexName(), k -> {
                long[] seqNumbers = new long[indexService.getIndexSettings().getNumberOfShards()];
                Arrays.fill(seqNumbers, -2L);
                return seqNumbers;
            });
            ((long[])checkpointsByIndexOfThisNode.get((Object)shardId.getIndexName()))[shardId.getId()] = indexShard.seqNoStats().getGlobalCheckpoint();
        }
        listener.onResponse((Object)new GetCheckpointNodeAction.Response(checkpointsByIndexOfThisNode));
    }
}

