/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.shutdown;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Executor;
import java.util.function.Predicate;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.action.support.master.AcknowledgedTransportMasterNodeAction;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateTaskExecutor;
import org.elasticsearch.cluster.ClusterStateTaskListener;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.cluster.metadata.NodesShutdownMetadata;
import org.elasticsearch.cluster.metadata.SingleNodeShutdownMetadata;
import org.elasticsearch.cluster.node.DiscoveryNodes;
import org.elasticsearch.cluster.routing.RerouteService;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.cluster.service.MasterService;
import org.elasticsearch.cluster.service.MasterServiceTaskQueue;
import org.elasticsearch.common.Priority;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.shutdown.PutShutdownNodeAction;

public class TransportPutShutdownNodeAction
extends AcknowledgedTransportMasterNodeAction<PutShutdownNodeAction.Request> {
    private static final Logger logger = LogManager.getLogger(TransportPutShutdownNodeAction.class);
    private final MasterServiceTaskQueue<PutShutdownNodeTask> taskQueue;
    private final PutShutdownNodeExecutor executor = new PutShutdownNodeExecutor();

    private static boolean putShutdownNodeState(Map<String, SingleNodeShutdownMetadata> shutdownMetadata, Predicate<String> nodeExists, PutShutdownNodeAction.Request request) {
        if (TransportPutShutdownNodeAction.isNoop(shutdownMetadata, request)) {
            return false;
        }
        boolean nodeSeen = nodeExists.test(request.getNodeId());
        SingleNodeShutdownMetadata newNodeMetadata = SingleNodeShutdownMetadata.builder().setNodeId(request.getNodeId()).setType(request.getType()).setReason(request.getReason()).setStartedAtMillis(System.currentTimeMillis()).setNodeSeen(nodeSeen).setAllocationDelay(request.getAllocationDelay()).setTargetNodeName(request.getTargetNodeName()).setGracePeriod(request.getGracePeriod()).build();
        SingleNodeShutdownMetadata existingRecord = shutdownMetadata.get(request.getNodeId());
        if (existingRecord != null) {
            logger.info("updating existing shutdown record {} with new record {}", (Object)existingRecord, (Object)newNodeMetadata);
        } else {
            logger.info("creating shutdown record {}", (Object)newNodeMetadata);
        }
        shutdownMetadata.put(request.getNodeId(), newNodeMetadata);
        return true;
    }

    private static void ackAndMaybeReroute(final PutShutdownNodeAction.Request request, ActionListener<AcknowledgedResponse> listener, RerouteService rerouteService) {
        boolean shouldReroute;
        switch (request.getType()) {
            case REMOVE: 
            case SIGTERM: 
            case REPLACE: {
                boolean bl = true;
                break;
            }
            default: {
                boolean bl = shouldReroute = false;
            }
        }
        if (shouldReroute) {
            rerouteService.reroute("node registered for removal from cluster", Priority.URGENT, (ActionListener)new ActionListener<Void>(){

                public void onResponse(Void ignored) {
                }

                public void onFailure(Exception e) {
                    logger.log(MasterService.isPublishFailureException((Exception)e) ? Level.DEBUG : Level.WARN, () -> "failed to reroute after registering node [" + request.getNodeId() + "] for shutdown", (Throwable)e);
                }
            });
        } else {
            logger.trace(() -> "not starting reroute after registering node [" + request.getNodeId() + "] for shutdown of type [" + request.getType() + "]");
        }
        listener.onResponse((Object)AcknowledgedResponse.TRUE);
    }

    @Inject
    public TransportPutShutdownNodeAction(TransportService transportService, ClusterService clusterService, ThreadPool threadPool, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver) {
        super("cluster:admin/shutdown/create", false, transportService, clusterService, threadPool, actionFilters, PutShutdownNodeAction.Request::new, indexNameExpressionResolver, (Executor)EsExecutors.DIRECT_EXECUTOR_SERVICE);
        this.taskQueue = clusterService.createTaskQueue("put-shutdown", Priority.URGENT, (ClusterStateTaskExecutor)new PutShutdownNodeExecutor());
    }

    protected void masterOperation(Task task, PutShutdownNodeAction.Request request, ClusterState state, ActionListener<AcknowledgedResponse> listener) {
        if (TransportPutShutdownNodeAction.isNoop(state.getMetadata().nodeShutdowns().getAll(), request)) {
            listener.onResponse((Object)AcknowledgedResponse.TRUE);
            return;
        }
        this.taskQueue.submitTask("put-node-shutdown-" + request.getNodeId(), (ClusterStateTaskListener)new PutShutdownNodeTask(request, listener), request.masterNodeTimeout());
    }

    private static boolean isNoop(Map<String, SingleNodeShutdownMetadata> shutdownMetadata, PutShutdownNodeAction.Request request) {
        SingleNodeShutdownMetadata existing = shutdownMetadata.get(request.getNodeId());
        return existing != null && existing.getType().equals((Object)request.getType()) && existing.getReason().equals(request.getReason()) && Objects.equals(existing.getAllocationDelay(), request.getAllocationDelay()) && Objects.equals(existing.getTargetNodeName(), request.getTargetNodeName());
    }

    protected ClusterBlockException checkBlock(PutShutdownNodeAction.Request request, ClusterState state) {
        return state.blocks().globalBlockedException(ClusterBlockLevel.METADATA_WRITE);
    }

    class PutShutdownNodeExecutor
    implements ClusterStateTaskExecutor<PutShutdownNodeTask> {
        PutShutdownNodeExecutor() {
        }

        public ClusterState execute(ClusterStateTaskExecutor.BatchExecutionContext<PutShutdownNodeTask> batchExecutionContext) throws Exception {
            ClusterState initialState = batchExecutionContext.initialState();
            HashMap<String, SingleNodeShutdownMetadata> shutdownMetadata = new HashMap<String, SingleNodeShutdownMetadata>(initialState.metadata().nodeShutdowns().getAll());
            Predicate<String> nodeExistsPredicate = arg_0 -> ((DiscoveryNodes)batchExecutionContext.initialState().getNodes()).nodeExists(arg_0);
            boolean changed = false;
            for (ClusterStateTaskExecutor.TaskContext taskContext : batchExecutionContext.taskContexts()) {
                PutShutdownNodeAction.Request request = ((PutShutdownNodeTask)taskContext.getTask()).request();
                try (Releasable ignored = taskContext.captureResponseHeaders();){
                    changed |= TransportPutShutdownNodeAction.putShutdownNodeState(shutdownMetadata, nodeExistsPredicate, request);
                }
                catch (Exception e) {
                    taskContext.onFailure(e);
                    continue;
                }
                RerouteService reroute = TransportPutShutdownNodeAction.this.clusterService.getRerouteService();
                taskContext.success(() -> TransportPutShutdownNodeAction.ackAndMaybeReroute(request, ((PutShutdownNodeTask)taskContext.getTask()).listener(), reroute));
            }
            if (!changed) {
                return batchExecutionContext.initialState();
            }
            return ClusterState.builder((ClusterState)batchExecutionContext.initialState()).metadata(Metadata.builder((Metadata)batchExecutionContext.initialState().metadata()).putCustom("node_shutdown", (Metadata.Custom)new NodesShutdownMetadata(shutdownMetadata))).build();
        }
    }

    record PutShutdownNodeTask(PutShutdownNodeAction.Request request, ActionListener<AcknowledgedResponse> listener) implements ClusterStateTaskListener
    {
        public void onFailure(Exception e) {
            logger.error(() -> "failed to put shutdown for node [" + this.request.getNodeId() + "]", (Throwable)e);
            this.listener.onFailure(e);
        }
    }
}

