/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.profiling;

import java.util.concurrent.Executor;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.master.TransportMasterNodeAction;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateObserver;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.node.NodeClosedException;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.core.XPackSettings;
import org.elasticsearch.xpack.profiling.GetStatusAction;
import org.elasticsearch.xpack.profiling.IndexStateResolver;
import org.elasticsearch.xpack.profiling.ProfilingDataStreamManager;
import org.elasticsearch.xpack.profiling.ProfilingIndexManager;
import org.elasticsearch.xpack.profiling.ProfilingIndexTemplateRegistry;
import org.elasticsearch.xpack.profiling.ProfilingPlugin;

public class TransportGetStatusAction
extends TransportMasterNodeAction<GetStatusAction.Request, GetStatusAction.Response> {
    private static final Logger log = LogManager.getLogger(TransportGetStatusAction.class);
    private final StatusResolver resolver;

    @Inject
    public TransportGetStatusAction(TransportService transportService, ClusterService clusterService, ThreadPool threadPool, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver) {
        super("cluster:monitor/profiling/status/get", transportService, clusterService, threadPool, actionFilters, GetStatusAction.Request::new, indexNameExpressionResolver, GetStatusAction.Response::new, (Executor)EsExecutors.DIRECT_EXECUTOR_SERVICE);
        this.resolver = new StatusResolver(clusterService);
    }

    protected void masterOperation(Task task, GetStatusAction.Request request, ClusterState state, ActionListener<GetStatusAction.Response> listener) {
        if (request.waitForResourcesCreated()) {
            this.createAndRegisterListener(listener, request.timeout());
        } else {
            listener.onResponse((Object)this.resolver.getResponse(state));
        }
    }

    private void createAndRegisterListener(ActionListener<GetStatusAction.Response> listener, TimeValue timeout) {
        DiscoveryNode localNode = this.clusterService.localNode();
        ClusterStateObserver.waitForState((ClusterService)this.clusterService, (ThreadContext)this.threadPool.getThreadContext(), (ClusterStateObserver.Listener)new StatusListener(listener, localNode, this.clusterService, this.resolver), clusterState -> this.resolver.getResponse((ClusterState)clusterState).isResourcesCreated(), (TimeValue)timeout, (Logger)log);
    }

    protected ClusterBlockException checkBlock(GetStatusAction.Request request, ClusterState state) {
        return state.blocks().globalBlockedException(ClusterBlockLevel.METADATA_READ);
    }

    private static class StatusResolver {
        private final ClusterService clusterService;

        private StatusResolver(ClusterService clusterService) {
            this.clusterService = clusterService;
        }

        private GetStatusAction.Response getResponse(ClusterState state) {
            IndexStateResolver indexStateResolver = new IndexStateResolver(this.getValue(state, ProfilingPlugin.PROFILING_CHECK_OUTDATED_INDICES));
            boolean pluginEnabled = this.getValue(state, (Setting<Boolean>)XPackSettings.PROFILING_ENABLED);
            boolean resourceManagementEnabled = this.getValue(state, ProfilingPlugin.PROFILING_TEMPLATES_ENABLED);
            boolean templatesCreated = ProfilingIndexTemplateRegistry.isAllResourcesCreated(state, this.clusterService.getSettings());
            boolean indicesCreated = ProfilingIndexManager.isAllResourcesCreated(state, indexStateResolver);
            boolean dataStreamsCreated = ProfilingDataStreamManager.isAllResourcesCreated(state, indexStateResolver);
            boolean resourcesCreated = templatesCreated && indicesCreated && dataStreamsCreated;
            boolean indicesPre891 = ProfilingIndexManager.isAnyResourceTooOld(state, indexStateResolver);
            boolean dataStreamsPre891 = ProfilingDataStreamManager.isAnyResourceTooOld(state, indexStateResolver);
            boolean anyPre891Data = indicesPre891 || dataStreamsPre891;
            return new GetStatusAction.Response(pluginEnabled, resourceManagementEnabled, resourcesCreated, anyPre891Data);
        }

        private boolean getValue(ClusterState state, Setting<Boolean> setting) {
            Metadata metadata = state.getMetadata();
            if (metadata.settings().hasValue(setting.getKey())) {
                return (Boolean)setting.get(metadata.settings());
            }
            return (Boolean)setting.get(this.clusterService.getSettings());
        }
    }

    private static class StatusListener
    implements ClusterStateObserver.Listener {
        private final ActionListener<GetStatusAction.Response> listener;
        private final DiscoveryNode localNode;
        private final ClusterService clusterService;
        private final StatusResolver resolver;

        private StatusListener(ActionListener<GetStatusAction.Response> listener, DiscoveryNode localNode, ClusterService clusterService, StatusResolver resolver) {
            this.listener = listener;
            this.localNode = localNode;
            this.clusterService = clusterService;
            this.resolver = resolver;
        }

        public void onNewClusterState(ClusterState state) {
            this.listener.onResponse((Object)this.resolver.getResponse(state));
        }

        public void onClusterServiceClose() {
            this.listener.onFailure((Exception)new NodeClosedException(this.localNode));
        }

        public void onTimeout(TimeValue timeout) {
            GetStatusAction.Response response = this.resolver.getResponse(this.clusterService.state());
            response.setTimedOut(true);
            this.listener.onResponse((Object)response);
        }
    }
}

