/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.profiling;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.Executor;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.HandledTransportAction;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.client.internal.ParentTaskAssigningClient;
import org.elasticsearch.client.internal.node.NodeClient;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.core.SuppressForbidden;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.profiling.Frame;
import org.elasticsearch.xpack.profiling.GetFlamegraphResponse;
import org.elasticsearch.xpack.profiling.GetStackTracesAction;
import org.elasticsearch.xpack.profiling.GetStackTracesRequest;
import org.elasticsearch.xpack.profiling.GetStackTracesResponse;
import org.elasticsearch.xpack.profiling.StackFrame;
import org.elasticsearch.xpack.profiling.StackTrace;

public class TransportGetFlamegraphAction
extends HandledTransportAction<GetStackTracesRequest, GetFlamegraphResponse> {
    private static final Logger log = LogManager.getLogger(TransportGetFlamegraphAction.class);
    private static final StackFrame EMPTY_STACKFRAME = new StackFrame("", "", 0, 0);
    private final NodeClient nodeClient;
    private final TransportService transportService;

    @Inject
    public TransportGetFlamegraphAction(NodeClient nodeClient, TransportService transportService, ActionFilters actionFilters) {
        super("indices:data/read/profiling/flamegraph", transportService, actionFilters, GetStackTracesRequest::new, (Executor)EsExecutors.DIRECT_EXECUTOR_SERVICE);
        this.nodeClient = nodeClient;
        this.transportService = transportService;
    }

    protected void doExecute(Task task, GetStackTracesRequest request, final ActionListener<GetFlamegraphResponse> listener) {
        ParentTaskAssigningClient client = new ParentTaskAssigningClient((Client)this.nodeClient, this.transportService.getLocalNode(), task);
        final long start = System.nanoTime();
        client.execute((ActionType)GetStackTracesAction.INSTANCE, (ActionRequest)request, (ActionListener)new ActionListener<GetStackTracesResponse>(){

            public void onResponse(GetStackTracesResponse response) {
                long responseStart = System.nanoTime();
                try {
                    GetFlamegraphResponse flamegraphResponse = TransportGetFlamegraphAction.buildFlamegraph(response);
                    log.debug("getFlamegraphAction took [" + (double)(System.nanoTime() - start) / 1000000.0 + "] ms (processing response: [" + (double)(System.nanoTime() - responseStart) / 1000000.0 + "] ms.");
                    listener.onResponse((Object)flamegraphResponse);
                }
                catch (Exception ex) {
                    listener.onFailure(ex);
                }
            }

            public void onFailure(Exception e) {
                listener.onFailure(e);
            }
        });
    }

    static GetFlamegraphResponse buildFlamegraph(GetStackTracesResponse response) {
        FlamegraphBuilder builder = new FlamegraphBuilder(response.getTotalFrames(), response.getSamplingRate());
        if (response.getTotalFrames() == 0) {
            return builder.build();
        }
        TreeMap<String, StackTrace> sortedStacktraces = new TreeMap<String, StackTrace>(response.getStackTraces());
        for (Map.Entry st : sortedStacktraces.entrySet()) {
            String stackTraceId = (String)st.getKey();
            StackTrace stackTrace = (StackTrace)st.getValue();
            int samples = response.getStackTraceEvents().getOrDefault(stackTraceId, 0);
            builder.setCurrentNode(0);
            builder.addSamplesInclusive(0, samples);
            builder.addSamplesExclusive(0, 0);
            int frameCount = stackTrace.frameIds.size();
            for (int i = 0; i < frameCount; ++i) {
                String frameId = stackTrace.frameIds.get(i);
                String fileId = stackTrace.fileIds.get(i);
                Integer frameType = stackTrace.typeIds.get(i);
                Integer addressOrLine = stackTrace.addressOrLines.get(i);
                StackFrame stackFrame = response.getStackFrames().getOrDefault(frameId, EMPTY_STACKFRAME);
                String executable = response.getExecutables().getOrDefault(fileId, "");
                for (Frame frame : stackFrame.frames()) {
                    int nodeId;
                    String frameGroupId = TransportGetFlamegraphAction.createFrameGroupId(fileId, addressOrLine, executable, frame.fileName(), frame.functionName());
                    if (builder.isExists(frameGroupId)) {
                        nodeId = builder.getNodeId(frameGroupId);
                        builder.addSamplesInclusive(nodeId, samples);
                    } else {
                        nodeId = builder.addNode(fileId, frameType, frame.inline(), executable, addressOrLine, frame.functionName(), frame.functionOffset(), frame.fileName(), frame.lineNumber(), samples, frameGroupId);
                    }
                    if (i == frameCount - 1) {
                        builder.addSamplesExclusive(nodeId, samples);
                    }
                    builder.setCurrentNode(nodeId);
                }
            }
        }
        return builder.build();
    }

    @SuppressForbidden(reason="Using pathSeparator constant to extract the filename with low overhead")
    private static String getFilename(String fullPath) {
        if (fullPath == null || fullPath.isEmpty()) {
            return fullPath;
        }
        int lastSeparatorIdx = fullPath.lastIndexOf(File.pathSeparator);
        return lastSeparatorIdx == -1 ? fullPath : fullPath.substring(lastSeparatorIdx + 1);
    }

    private static String createFrameGroupId(String fileId, Integer addressOrLine, String exeFilename, String sourceFilename, String functionName) {
        StringBuilder sb = new StringBuilder();
        if (functionName.isEmpty()) {
            sb.append(fileId);
            sb.append(addressOrLine);
        } else {
            sb.append(exeFilename);
            sb.append(functionName);
            sb.append(TransportGetFlamegraphAction.getFilename(sourceFilename));
        }
        return sb.toString();
    }

    private static class FlamegraphBuilder {
        private int currentNode = 0;
        private int size = 0;
        private final List<Map<String, Integer>> edges;
        private final List<String> fileIds;
        private final List<Integer> frameTypes;
        private final List<Boolean> inlineFrames;
        private final List<String> fileNames;
        private final List<Integer> addressOrLines;
        private final List<String> functionNames;
        private final List<Integer> functionOffsets;
        private final List<String> sourceFileNames;
        private final List<Integer> sourceLines;
        private final List<Integer> countInclusive;
        private final List<Integer> countExclusive;
        private final double samplingRate;

        FlamegraphBuilder(int frames, double samplingRate) {
            int capacity = (int)((double)frames * 1.1);
            this.edges = new ArrayList<Map<String, Integer>>(capacity);
            this.fileIds = new ArrayList<String>(capacity);
            this.frameTypes = new ArrayList<Integer>(capacity);
            this.inlineFrames = new ArrayList<Boolean>(capacity);
            this.fileNames = new ArrayList<String>(capacity);
            this.addressOrLines = new ArrayList<Integer>(capacity);
            this.functionNames = new ArrayList<String>(capacity);
            this.functionOffsets = new ArrayList<Integer>(capacity);
            this.sourceFileNames = new ArrayList<String>(capacity);
            this.sourceLines = new ArrayList<Integer>(capacity);
            this.countInclusive = new ArrayList<Integer>(capacity);
            this.countExclusive = new ArrayList<Integer>(capacity);
            int nodeId = this.addNode("", 0, false, "", 0, "", 0, "", 0, 0, null);
            this.setCurrentNode(nodeId);
            this.samplingRate = samplingRate;
        }

        public int addNode(String fileId, int frameType, boolean inline, String fileName, Integer addressOrLine, String functionName, int functionOffset, String sourceFileName, int sourceLine, int samples, String frameGroupId) {
            int node = this.size;
            this.edges.add(new HashMap());
            this.fileIds.add(fileId);
            this.frameTypes.add(frameType);
            this.inlineFrames.add(inline);
            this.fileNames.add(fileName);
            this.addressOrLines.add(addressOrLine);
            this.functionNames.add(functionName);
            this.functionOffsets.add(functionOffset);
            this.sourceFileNames.add(sourceFileName);
            this.sourceLines.add(sourceLine);
            this.countInclusive.add(samples);
            this.countExclusive.add(0);
            if (frameGroupId != null) {
                this.edges.get(this.currentNode).put(frameGroupId, node);
            }
            ++this.size;
            return node;
        }

        public void setCurrentNode(int nodeId) {
            this.currentNode = nodeId;
        }

        public boolean isExists(String frameGroupId) {
            return this.edges.get(this.currentNode).containsKey(frameGroupId);
        }

        public int getNodeId(String frameGroupId) {
            return this.edges.get(this.currentNode).get(frameGroupId);
        }

        public void addSamplesInclusive(int nodeId, int sampleCount) {
            Integer priorSampleCount = this.countInclusive.get(nodeId);
            this.countInclusive.set(nodeId, priorSampleCount + sampleCount);
        }

        public void addSamplesExclusive(int nodeId, int sampleCount) {
            Integer priorSampleCount = this.countExclusive.get(nodeId);
            this.countExclusive.set(nodeId, priorSampleCount + sampleCount);
        }

        public GetFlamegraphResponse build() {
            return new GetFlamegraphResponse(this.size, this.samplingRate, this.edges, this.fileIds, this.frameTypes, this.inlineFrames, this.fileNames, this.addressOrLines, this.functionNames, this.functionOffsets, this.sourceFileNames, this.sourceLines, this.countInclusive, this.countExclusive);
        }
    }
}

