/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.profiling;

import java.io.IOException;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xpack.profiling.Frame;

final class StackFrame
implements ToXContentObject {
    List<String> fileName;
    List<String> functionName;
    List<Integer> functionOffset;
    List<Integer> lineNumber;

    StackFrame(Object fileName, Object functionName, Object functionOffset, Object lineNumber) {
        this.fileName = StackFrame.listOf(fileName);
        this.functionName = StackFrame.listOf(functionName);
        this.functionOffset = StackFrame.listOf(functionOffset);
        this.lineNumber = StackFrame.listOf(lineNumber);
    }

    private static <T> List<T> listOf(Object o) {
        if (o instanceof List) {
            return (List)o;
        }
        if (o != null) {
            return List.of(o);
        }
        return Collections.emptyList();
    }

    public static StackFrame fromSource(Map<String, Object> source) {
        return new StackFrame(source.get("Stackframe.file.name"), source.get("Stackframe.function.name"), source.get("Stackframe.function.offset"), source.get("Stackframe.line.number"));
    }

    public boolean isEmpty() {
        return this.fileName.isEmpty() && this.functionName.isEmpty() && this.functionOffset.isEmpty() && this.lineNumber.isEmpty();
    }

    public Iterable<Frame> frames() {
        return new Frames();
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field("file_name", this.fileName);
        builder.field("function_name", this.functionName);
        builder.field("function_offset", this.functionOffset);
        builder.field("line_number", this.lineNumber);
        builder.endObject();
        return builder;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StackFrame that = (StackFrame)o;
        return Objects.equals(this.fileName, that.fileName) && Objects.equals(this.functionName, that.functionName) && Objects.equals(this.functionOffset, that.functionOffset) && Objects.equals(this.lineNumber, that.lineNumber);
    }

    public int hashCode() {
        return Objects.hash(this.fileName, this.functionName, this.functionOffset, this.lineNumber);
    }

    private class Frames
    implements Iterable<Frame> {
        private Frames() {
        }

        @Override
        public Iterator<Frame> iterator() {
            return new Iterator<Frame>(){
                private int currentElement = 0;

                @Override
                public boolean hasNext() {
                    return this.currentElement < StackFrame.this.fileName.size() || this.currentElement < StackFrame.this.functionName.size() || this.currentElement < StackFrame.this.functionOffset.size() || this.currentElement < StackFrame.this.lineNumber.size();
                }

                @Override
                public Frame next() {
                    if (!this.hasNext()) {
                        throw new NoSuchElementException();
                    }
                    Frame f = new Frame(Frames.get(StackFrame.this.fileName, this.currentElement, ""), Frames.get(StackFrame.this.functionName, this.currentElement, ""), Frames.get(StackFrame.this.functionOffset, this.currentElement, 0), Frames.get(StackFrame.this.lineNumber, this.currentElement, 0), this.currentElement > 0);
                    ++this.currentElement;
                    return f;
                }
            };
        }

        private static <T> T get(List<T> l, int index, T defaultValue) {
            return index < l.size() ? l.get(index) : defaultValue;
        }
    }
}

