/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.repositories.metering.action;

import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import org.elasticsearch.action.FailedNodeException;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.nodes.TransportNodesAction;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.repositories.RepositoriesService;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportRequest;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.repositories.metering.action.RepositoriesMeteringRequest;
import org.elasticsearch.xpack.repositories.metering.action.RepositoriesMeteringResponse;
import org.elasticsearch.xpack.repositories.metering.action.RepositoriesNodeMeteringResponse;

public final class TransportRepositoriesStatsAction
extends TransportNodesAction<RepositoriesMeteringRequest, RepositoriesMeteringResponse, RepositoriesNodeStatsRequest, RepositoriesNodeMeteringResponse> {
    private final RepositoriesService repositoriesService;

    @Inject
    public TransportRepositoriesStatsAction(ThreadPool threadPool, ClusterService clusterService, TransportService transportService, ActionFilters actionFilters, RepositoriesService repositoriesService) {
        super("cluster:monitor/xpack/repositories_metering/get_metrics", threadPool, clusterService, transportService, actionFilters, RepositoriesMeteringRequest::new, RepositoriesNodeStatsRequest::new, (Executor)threadPool.executor("generic"));
        this.repositoriesService = repositoriesService;
    }

    protected RepositoriesMeteringResponse newResponse(RepositoriesMeteringRequest request, List<RepositoriesNodeMeteringResponse> repositoriesNodeStatsResponses, List<FailedNodeException> failures) {
        return new RepositoriesMeteringResponse(this.clusterService.getClusterName(), repositoriesNodeStatsResponses, failures);
    }

    protected RepositoriesNodeStatsRequest newNodeRequest(RepositoriesMeteringRequest request) {
        return new RepositoriesNodeStatsRequest();
    }

    protected RepositoriesNodeMeteringResponse newNodeResponse(StreamInput in, DiscoveryNode node) throws IOException {
        return new RepositoriesNodeMeteringResponse(in);
    }

    protected RepositoriesNodeMeteringResponse nodeOperation(RepositoriesNodeStatsRequest request, Task task) {
        return new RepositoriesNodeMeteringResponse(this.clusterService.localNode(), this.repositoriesService.repositoriesStats());
    }

    static final class RepositoriesNodeStatsRequest
    extends TransportRequest {
        RepositoriesNodeStatsRequest() {
        }

        RepositoriesNodeStatsRequest(StreamInput in) throws IOException {
            super(in);
        }
    }
}

