/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.monitoring;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.cluster.metadata.ComposableIndexTemplate;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.xcontent.NamedXContentRegistry;
import org.elasticsearch.xpack.core.ilm.LifecyclePolicy;
import org.elasticsearch.xpack.core.monitoring.MonitoredSystem;
import org.elasticsearch.xpack.core.monitoring.MonitoringField;
import org.elasticsearch.xpack.core.template.IndexTemplateConfig;
import org.elasticsearch.xpack.core.template.IndexTemplateRegistry;
import org.elasticsearch.xpack.core.template.LifecyclePolicyConfig;

public class MonitoringTemplateRegistry
extends IndexTemplateRegistry {
    private static final Logger logger = LogManager.getLogger(MonitoringTemplateRegistry.class);
    public static final int REGISTRY_VERSION = 8080099;
    private static final String REGISTRY_VERSION_VARIABLE = "xpack.monitoring.template.release.version";
    private static final String TEMPLATE_VERSION = "7";
    private static final String TEMPLATE_VERSION_VARIABLE = "xpack.monitoring.template.version";
    private static final Map<String, String> ADDITIONAL_TEMPLATE_VARIABLES = Map.of("xpack.monitoring.template.version", "7");
    public static final String MONITORING_POLICY_NAME = ".monitoring-8-ilm-policy";
    private static final String MONITORING_POLICY_NAME_VARIABLE = "xpack.stack.monitoring.policy.name";
    public static final String MONITORING_POLICY_DEFAULT_RETENTION = "3d";
    private static final String MONITORING_POLICY_RETENTION_VARIABLE = "xpack.stack.monitoring.history.duration";
    private static final String MONITORING_POLICY_RETENTION_REASON_VARIABLE = "xpack.stack.monitoring.history.duration.reason";
    public static final int STACK_MONITORING_REGISTRY_VERSION = 8000108;
    private static final String STACK_MONITORING_REGISTRY_VERSION_VARIABLE = "xpack.stack.monitoring.template.release.version";
    private static final String STACK_TEMPLATE_VERSION = "8";
    private static final String STACK_TEMPLATE_VERSION_VARIABLE = "xpack.stack.monitoring.template.version";
    private static final Map<String, String> STACK_TEMPLATE_VARIABLES = Map.of("xpack.stack.monitoring.template.version", "8", "xpack.stack.monitoring.policy.name", ".monitoring-8-ilm-policy");
    public static final Setting<Boolean> MONITORING_TEMPLATES_ENABLED = Setting.boolSetting((String)"xpack.monitoring.templates.enabled", (boolean)true, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Dynamic});
    private final ClusterService clusterService;
    private volatile boolean monitoringTemplatesEnabled;
    public static final String ALERTS_INDEX_TEMPLATE_NAME = ".monitoring-alerts-7";
    public static final IndexTemplateConfig ALERTS_INDEX_TEMPLATE = new IndexTemplateConfig(".monitoring-alerts-7", "/monitoring-alerts-7.json", 8080099, "xpack.monitoring.template.release.version", ADDITIONAL_TEMPLATE_VARIABLES);
    public static final String BEATS_INDEX_TEMPLATE_NAME = ".monitoring-beats";
    public static final IndexTemplateConfig BEATS_INDEX_TEMPLATE = new IndexTemplateConfig(".monitoring-beats", "/monitoring-beats.json", 8080099, "xpack.monitoring.template.release.version", ADDITIONAL_TEMPLATE_VARIABLES);
    public static final String ES_INDEX_TEMPLATE_NAME = ".monitoring-es";
    public static final IndexTemplateConfig ES_INDEX_TEMPLATE = new IndexTemplateConfig(".monitoring-es", "/monitoring-es.json", 8080099, "xpack.monitoring.template.release.version", ADDITIONAL_TEMPLATE_VARIABLES);
    public static final String KIBANA_INDEX_TEMPLATE_NAME = ".monitoring-kibana";
    public static final IndexTemplateConfig KIBANA_INDEX_TEMPLATE = new IndexTemplateConfig(".monitoring-kibana", "/monitoring-kibana.json", 8080099, "xpack.monitoring.template.release.version", ADDITIONAL_TEMPLATE_VARIABLES);
    public static final String LOGSTASH_INDEX_TEMPLATE_NAME = ".monitoring-logstash";
    public static final IndexTemplateConfig LOGSTASH_INDEX_TEMPLATE = new IndexTemplateConfig(".monitoring-logstash", "/monitoring-logstash.json", 8080099, "xpack.monitoring.template.release.version", ADDITIONAL_TEMPLATE_VARIABLES);
    public static final String BEATS_STACK_INDEX_TEMPLATE_NAME = ".monitoring-beats-mb";
    public static final IndexTemplateConfig BEATS_STACK_INDEX_TEMPLATE = new IndexTemplateConfig(".monitoring-beats-mb", "/monitoring-beats-mb.json", 8000108, "xpack.stack.monitoring.template.release.version", STACK_TEMPLATE_VARIABLES);
    public static final String ES_STACK_INDEX_TEMPLATE_NAME = ".monitoring-es-mb";
    public static final IndexTemplateConfig ES_STACK_INDEX_TEMPLATE = new IndexTemplateConfig(".monitoring-es-mb", "/monitoring-es-mb.json", 8000108, "xpack.stack.monitoring.template.release.version", STACK_TEMPLATE_VARIABLES);
    public static final String KIBANA_STACK_INDEX_TEMPLATE_NAME = ".monitoring-kibana-mb";
    public static final IndexTemplateConfig KIBANA_STACK_INDEX_TEMPLATE = new IndexTemplateConfig(".monitoring-kibana-mb", "/monitoring-kibana-mb.json", 8000108, "xpack.stack.monitoring.template.release.version", STACK_TEMPLATE_VARIABLES);
    public static final String LOGSTASH_STACK_INDEX_TEMPLATE_NAME = ".monitoring-logstash-mb";
    public static final IndexTemplateConfig LOGSTASH_STACK_INDEX_TEMPLATE = new IndexTemplateConfig(".monitoring-logstash-mb", "/monitoring-logstash-mb.json", 8000108, "xpack.stack.monitoring.template.release.version", STACK_TEMPLATE_VARIABLES);
    public static final String ENTERPRISE_SEARCH_STACK_INDEX_TEMPLATE_NAME = ".monitoring-ent-search-mb";
    public static final IndexTemplateConfig ENTERPRISE_SEARCH_STACK_INDEX_TEMPLATE = new IndexTemplateConfig(".monitoring-ent-search-mb", "/monitoring-ent-search-mb.json", 8000108, "xpack.stack.monitoring.template.release.version", STACK_TEMPLATE_VARIABLES);
    public static final String[] TEMPLATE_NAMES = new String[]{".monitoring-alerts-7", ".monitoring-beats", ".monitoring-es", ".monitoring-kibana", ".monitoring-logstash"};
    private static final Map<String, IndexTemplateConfig> MONITORED_SYSTEM_CONFIG_LOOKUP = new HashMap<String, IndexTemplateConfig>();
    private static final Map<String, ComposableIndexTemplate> COMPOSABLE_INDEX_TEMPLATE_CONFIGS;

    public static IndexTemplateConfig getTemplateConfigForMonitoredSystem(MonitoredSystem system) {
        return Optional.ofNullable(MONITORED_SYSTEM_CONFIG_LOOKUP.get(system.getSystem())).orElseThrow(() -> new IllegalArgumentException("Invalid system [" + system + "]"));
    }

    public MonitoringTemplateRegistry(Settings nodeSettings, ClusterService clusterService, ThreadPool threadPool, Client client, NamedXContentRegistry xContentRegistry) {
        super(nodeSettings, clusterService, threadPool, client, xContentRegistry);
        this.clusterService = clusterService;
        this.monitoringTemplatesEnabled = (Boolean)MONITORING_TEMPLATES_ENABLED.get(nodeSettings);
    }

    protected List<LifecyclePolicyConfig> getLifecycleConfigs() {
        HashMap<String, Object> templateVars = new HashMap<String, Object>();
        if (MonitoringField.HISTORY_DURATION.exists(this.settings)) {
            templateVars.put(MONITORING_POLICY_RETENTION_VARIABLE, ((TimeValue)MonitoringField.HISTORY_DURATION.get(this.settings)).getStringRep());
            templateVars.put(MONITORING_POLICY_RETENTION_REASON_VARIABLE, "the value of the [" + MonitoringField.HISTORY_DURATION.getKey() + "] setting at node startup");
        } else {
            templateVars.put(MONITORING_POLICY_RETENTION_VARIABLE, MONITORING_POLICY_DEFAULT_RETENTION);
            templateVars.put(MONITORING_POLICY_RETENTION_REASON_VARIABLE, "the monitoring plugin default");
        }
        LifecyclePolicyConfig monitoringPolicy = new LifecyclePolicyConfig(MONITORING_POLICY_NAME, "/monitoring-mb-ilm-policy.json", templateVars);
        return List.of(monitoringPolicy);
    }

    public void initialize() {
        super.initialize();
        this.clusterService.getClusterSettings().addSettingsUpdateConsumer(MONITORING_TEMPLATES_ENABLED, this::updateEnabledSetting);
    }

    private void updateEnabledSetting(boolean newValue) {
        if (newValue) {
            this.monitoringTemplatesEnabled = true;
        } else {
            logger.info("monitoring templates [{}] will not be installed or reinstalled", (Object)this.getLegacyTemplateConfigs().stream().map(IndexTemplateConfig::getTemplateName).collect(Collectors.joining(",")));
            this.monitoringTemplatesEnabled = false;
        }
    }

    protected List<IndexTemplateConfig> getLegacyTemplateConfigs() {
        if (this.monitoringTemplatesEnabled) {
            return Arrays.asList(ALERTS_INDEX_TEMPLATE, BEATS_INDEX_TEMPLATE, ES_INDEX_TEMPLATE, KIBANA_INDEX_TEMPLATE, LOGSTASH_INDEX_TEMPLATE);
        }
        return Collections.emptyList();
    }

    protected Map<String, ComposableIndexTemplate> getComposableTemplateConfigs() {
        return this.monitoringTemplatesEnabled ? COMPOSABLE_INDEX_TEMPLATE_CONFIGS : Map.of();
    }

    protected List<LifecyclePolicy> getLifecyclePolicies() {
        if (this.monitoringTemplatesEnabled) {
            return this.lifecyclePolicies;
        }
        return Collections.emptyList();
    }

    protected String getOrigin() {
        return "monitoring";
    }

    protected boolean requiresMasterNode() {
        return true;
    }

    static {
        MONITORED_SYSTEM_CONFIG_LOOKUP.put(MonitoredSystem.BEATS.getSystem(), BEATS_INDEX_TEMPLATE);
        MONITORED_SYSTEM_CONFIG_LOOKUP.put(MonitoredSystem.ES.getSystem(), ES_INDEX_TEMPLATE);
        MONITORED_SYSTEM_CONFIG_LOOKUP.put(MonitoredSystem.KIBANA.getSystem(), KIBANA_INDEX_TEMPLATE);
        MONITORED_SYSTEM_CONFIG_LOOKUP.put(MonitoredSystem.LOGSTASH.getSystem(), LOGSTASH_INDEX_TEMPLATE);
        COMPOSABLE_INDEX_TEMPLATE_CONFIGS = MonitoringTemplateRegistry.parseComposableTemplates((IndexTemplateConfig[])new IndexTemplateConfig[]{BEATS_STACK_INDEX_TEMPLATE, ES_STACK_INDEX_TEMPLATE, KIBANA_STACK_INDEX_TEMPLATE, LOGSTASH_STACK_INDEX_TEMPLATE, ENTERPRISE_SEARCH_STACK_INDEX_TEMPLATE});
    }
}

